/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigModes;
import org.neo4j.kernel.api.impl.index.LuceneSettings;

public final class IndexWriterConfigBuilder {
    private static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private final IndexWriterConfigModes.Mode mode;
    private final Config config;
    private Analyzer analyzer = KEYWORD_ANALYZER;
    private Codec codec;

    public IndexWriterConfigBuilder(IndexWriterConfigModes.Mode mode, Config config) {
        this.mode = mode;
        this.config = config;
    }

    public IndexWriterConfigBuilder withAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public IndexWriterConfigBuilder withCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public IndexWriterConfig build() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer).setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy())).setUseCompoundFile(true).setMaxFullFlushMergeWaitMillis(0L);
        if (this.codec != null) {
            writerConfig.setCodec(this.codec);
        }
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(((Double)this.config.get(LuceneSettings.lucene_nocfs_ratio)).doubleValue());
        mergePolicy.setMinMergeMB(((Double)this.config.get(LuceneSettings.lucene_min_merge)).doubleValue());
        mergePolicy.setMaxMergeMB(((Double)this.config.get(LuceneSettings.lucene_max_merge)).doubleValue());
        writerConfig.setMergePolicy((MergePolicy)this.mode.visitWithConfig((LogMergePolicy)mergePolicy, this.config));
        return this.mode.visitWithConfig(writerConfig, this.config);
    }
}

