/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.FeatureToggles;

public interface DirectoryFactory
extends AutoCloseable {
    public static final DirectoryFactory PERSISTENT = new DirectoryFactory(){
        private final int MAX_MERGE_SIZE_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_merge_size_mb", (int)5);
        private final int MAX_CACHED_MB = FeatureToggles.getInteger(DirectoryFactory.class, (String)"max_cached_mb", (int)50);
        private final boolean USE_DEFAULT_DIRECTORY_FACTORY = FeatureToggles.flag(DirectoryFactory.class, (String)"default_directory_factory", (boolean)true);

        @Override
        public Directory open(Path dir) throws IOException {
            Files.createDirectories(dir, new FileAttribute[0]);
            FSDirectory directory = this.USE_DEFAULT_DIRECTORY_FACTORY ? FSDirectory.open((Path)dir) : new NIOFSDirectory(dir);
            return new NRTCachingDirectory((Directory)directory, (double)this.MAX_MERGE_SIZE_MB, (double)this.MAX_CACHED_MB);
        }

        @Override
        public void close() {
        }
    };

    public static DirectoryFactory directoryFactory(FileSystemAbstraction fs) {
        return fs.isPersistent() ? PERSISTENT : new InMemoryDirectoryFactory(fs);
    }

    public Directory open(Path var1) throws IOException;

    public static final class InMemoryDirectoryFactory
    implements DirectoryFactory {
        private final Map<Path, Directory> directories = new HashMap<Path, Directory>();
        private final FileSystemAbstraction fs;

        public InMemoryDirectoryFactory() {
            this(null);
        }

        public InMemoryDirectoryFactory(FileSystemAbstraction fs) {
            this.fs = fs;
        }

        @Override
        public synchronized Directory open(Path dir) {
            if (!this.directories.containsKey(dir)) {
                this.directories.put(dir, (Directory)this.openFromFs(dir));
            }
            return new UncloseableDirectory(this.directories.get(dir));
        }

        private ByteBuffersDirectory openFromFs(Path dir) {
            ByteBuffersDirectory directory;
            block18: {
                directory = new ByteBuffersDirectory();
                if (this.fs != null) {
                    try {
                        if (!this.fs.fileExists(dir)) break block18;
                        if (!this.fs.isDirectory(dir)) {
                            throw new RuntimeException("File " + String.valueOf(dir) + " existed, but was not a directory");
                        }
                        for (Path file : this.fs.listFiles(dir)) {
                            try (InputStream in = this.fs.openAsInputStream(file);
                                 IndexOutput out = directory.createOutput(file.getFileName().toString(), new IOContext());){
                                int length = in.available();
                                byte[] bytes = new byte[length];
                                int bytesRead = in.read(bytes, 0, length);
                                if (bytesRead < length) {
                                    throw new RuntimeException("Couldn't read it all " + bytesRead + " < " + length);
                                }
                                out.writeBytes(bytes, 0, length);
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            return directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            block17: {
                try {
                    if (this.fs == null) break block17;
                    for (Map.Entry<Path, Directory> entry : this.directories.entrySet()) {
                        Path directoryPath = entry.getKey();
                        this.fs.deleteRecursively(directoryPath);
                        this.fs.mkdirs(directoryPath);
                        Directory directory = entry.getValue();
                        for (String name : directory.listAll()) {
                            Path filePath = directoryPath.resolve(name);
                            try (OutputStream out = this.fs.openAsOutputStream(filePath, false);
                                 IndexInput in = directory.openInput(name, new IOContext());){
                                int length = Math.toIntExact(in.length());
                                byte[] bytes = new byte[length];
                                in.readBytes(bytes, 0, length);
                                out.write(bytes, 0, length);
                            }
                        }
                    }
                }
                finally {
                    IOUtils.closeAll(this.directories.values());
                    this.directories.clear();
                }
            }
        }
    }

    public static final class UncloseableDirectory
    extends FilterDirectory {
        public UncloseableDirectory(Directory delegate) {
            super(delegate);
        }

        public void close() {
        }
    }

    public static final class Single
    implements DirectoryFactory {
        private final Directory directory;

        public Single(Directory directory) {
            this.directory = directory;
        }

        @Override
        public Directory open(Path dir) {
            return this.directory;
        }

        @Override
        public void close() {
        }
    }
}

