/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class ArrayEncoder {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();

    private ArrayEncoder() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static String encode(Value array) {
        if (!Values.isArrayValue((Value)array)) {
            throw new IllegalArgumentException("Only works with arrays");
        }
        ValueEncoder encoder = new ValueEncoder();
        array.writeTo((ValueWriter)encoder);
        return encoder.result();
    }

    static class ValueEncoder
    implements ValueWriter<RuntimeException> {
        private final StringBuilder builder = new StringBuilder();

        ValueEncoder() {
        }

        public String result() {
            return this.builder.toString();
        }

        public void writeNull() {
        }

        public void writeBoolean(boolean value) {
            this.builder.append(value);
            this.builder.append('|');
        }

        public void writeInteger(byte value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(short value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(int value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(long value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeFloatingPoint(float value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeFloatingPoint(double value) {
            this.builder.append(value);
            this.builder.append('|');
        }

        public void writeString(String value) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode((String)value)));
            this.builder.append('|');
        }

        public void writeString(char value) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode((String)Character.toString(value))));
            this.builder.append('|');
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
            this.builder.append(crs.getTable().getTableId());
            this.builder.append(':');
            this.builder.append(crs.getCode());
            this.builder.append(':');
            int index = 0;
            for (double c : coordinate) {
                if (index > 0) {
                    this.builder.append(';');
                }
                this.builder.append(c);
                ++index;
            }
            this.builder.append('|');
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
            this.builder.append(DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos).prettyPrint());
            this.builder.append('|');
        }

        public void writeDate(LocalDate localDate) throws RuntimeException {
            this.builder.append(DateValue.date((LocalDate)localDate).prettyPrint());
            this.builder.append('|');
        }

        public void writeLocalTime(LocalTime localTime) throws RuntimeException {
            this.builder.append(LocalTimeValue.localTime((LocalTime)localTime).prettyPrint());
            this.builder.append('|');
        }

        public void writeTime(OffsetTime offsetTime) throws RuntimeException {
            this.builder.append(TimeValue.time((OffsetTime)offsetTime).prettyPrint());
            this.builder.append('|');
        }

        public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
            this.builder.append(LocalDateTimeValue.localDateTime((LocalDateTime)localDateTime).prettyPrint());
            this.builder.append('|');
        }

        public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
            this.builder.append(DateTimeValue.datetime((ZonedDateTime)zonedDateTime).prettyPrint());
            this.builder.append('|');
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) {
            if (size > 0) {
                this.builder.append(ValueEncoder.typeChar(arrayType));
            }
        }

        public void endArray() {
        }

        public void writeByteArray(byte[] value) {
            this.builder.append('D');
            for (byte b : value) {
                this.builder.append((double)b);
                this.builder.append('|');
            }
        }

        private static char typeChar(ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case BOOLEAN: {
                    return 'Z';
                }
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return 'D';
                }
                case CHAR: 
                case STRING: {
                    return 'L';
                }
                case POINT: {
                    return 'P';
                }
                case ZONED_DATE_TIME: 
                case LOCAL_DATE_TIME: 
                case DATE: 
                case ZONED_TIME: 
                case LOCAL_TIME: {
                    return 'T';
                }
                case DURATION: {
                    return 'A';
                }
            }
            throw new UnsupportedOperationException("Not supported array type: " + String.valueOf(arrayType));
        }
    }
}

