/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.Set;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BoltResponse<T>
implements Response {
    protected final StatementResult result;
    private final TransactionManager transactionManager;
    private final Logger LOGGER = LoggerFactory.getLogger(BoltResponse.class);

    public BoltResponse(StatementResult result, TransactionManager transactionManager) {
        this.result = result;
        this.transactionManager = transactionManager;
    }

    public T next() {
        try {
            return this.fetchNext();
        }
        catch (ClientException ce) {
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            if (tx != null) {
                tx.rollback();
            }
            this.LOGGER.debug("Error executing Cypher: {}, {}", (Object)ce.neo4jErrorCode(), (Object)ce.getMessage());
            throw new CypherException("Error executing Cypher", (Throwable)ce, ce.neo4jErrorCode(), ce.getMessage());
        }
    }

    public abstract T fetchNext();

    public void close() {
        if (this.transactionManager.getCurrentTransaction() != null) {
            this.result.consume();
        }
    }

    public String[] columns() {
        Record record;
        if (this.result.hasNext() && (record = this.result.peek()) != null) {
            Set columns = this.result.peek().asMap().keySet();
            return columns.toArray(new String[columns.size()]);
        }
        return new String[0];
    }
}

