/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.graphschema.GraphSchema;
import org.neo4j.procedure.builtin.graphschema.GraphSchemaGraphyResultWrapper;
import org.neo4j.procedure.builtin.graphschema.GraphSchemaJSONResultWrapper;

public class Introspect {
    @Context
    public Transaction transaction;

    @Deprecated
    @Internal
    @SystemProcedure
    @Procedure(name="internal.introspect.asJson", mode=Mode.READ)
    @Description(value="Call with {useConstantIds: false} to generate substitute ids for all tokens and use {prettyPrint: true} for enabling pretty printing;{quoteTokens: false} will disable quotation of tokens.")
    public Stream<GraphSchemaJSONResultWrapper> introspectAsJson(@Name(value="params") Map<String, Object> params) throws Exception {
        Config config = new Config(params);
        GraphSchema graphSchema = GraphSchema.build(this.transaction, config);
        return Stream.of(GraphSchemaJSONResultWrapper.of(graphSchema, config));
    }

    @Deprecated
    @Internal
    @SystemProcedure
    @Procedure(name="internal.introspect.asGraph", mode=Mode.READ)
    @Description(value="Visualizes the JSON generated by this introspector in a graphy way")
    public Stream<GraphSchemaGraphyResultWrapper> introspectAndVisualize(@Name(value="params") Map<String, Object> params) throws Exception {
        GraphSchema graphSchema = GraphSchema.build(this.transaction, new Config(params));
        boolean flat = (Boolean)params.getOrDefault("flat", false);
        return Stream.of(flat ? GraphSchemaGraphyResultWrapper.flat(graphSchema) : GraphSchemaGraphyResultWrapper.full(graphSchema));
    }

    record Config(boolean useConstantIds, boolean prettyPrint, boolean quoteTokens, boolean sampleOnly) {
        Config(Map<String, Object> params) {
            this((Boolean)params.getOrDefault("useConstantIds", true), (Boolean)params.getOrDefault("prettyPrint", false), (Boolean)params.getOrDefault("quoteTokens", true), (Boolean)params.getOrDefault("sampleOnly", true));
        }
    }
}

