/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.evaluator.Evaluator;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.impl.ByteArrayConverter;
import org.neo4j.procedure.impl.CompositeConverter;
import org.neo4j.procedure.impl.ListConverter;
import org.neo4j.procedure.impl.MapConverter;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public class TypeCheckers {
    private static final ExpressionEvaluator EVALUATOR = Evaluator.expressionEvaluator();
    private static final Function<String, DefaultParameterValue> PARSE_STRING = DefaultParameterValue::ntString;
    private static final Function<String, DefaultParameterValue> PARSE_INTEGER = s -> DefaultParameterValue.ntInteger((long)Long.parseLong(s));
    private static final Function<String, DefaultParameterValue> PARSE_FLOAT = s -> DefaultParameterValue.ntFloat((double)Double.parseDouble(s));
    private static final Function<String, DefaultParameterValue> PARSE_NUMBER = new CompositeConverter((Neo4jTypes.AnyType)Neo4jTypes.NTNumber, PARSE_INTEGER, PARSE_FLOAT);
    private static final Function<String, DefaultParameterValue> PARSE_BOOLEAN = s -> DefaultParameterValue.ntBoolean((boolean)TypeCheckers.parseBooleanOrFail(s));
    private static final MapConverter PARSE_MAP = new MapConverter(EVALUATOR);
    private static final ListConverter PARSE_LIST = new ListConverter((Type)((Object)Object.class), Neo4jTypes.NTAny, EVALUATOR);
    private static final ByteArrayConverter PARSE_BYTE_ARRAY = new ByteArrayConverter(EVALUATOR);
    private static final CompositeConverter PARSE_ANY = new CompositeConverter(Neo4jTypes.NTAny, DefaultValueConverter.nullParser(Neo4jTypes.NTAny), PARSE_MAP, PARSE_LIST, PARSE_BOOLEAN, PARSE_NUMBER, PARSE_STRING);
    private static final DefaultValueConverter TO_ANY = new DefaultValueConverter(Neo4jTypes.NTAny, PARSE_ANY);
    private static final DefaultValueConverter TO_STRING = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTString, PARSE_STRING);
    private static final DefaultValueConverter TO_INTEGER = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTInteger, PARSE_INTEGER);
    private static final DefaultValueConverter TO_FLOAT = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTFloat, PARSE_FLOAT);
    private static final DefaultValueConverter TO_NUMBER = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTNumber, PARSE_NUMBER);
    private static final DefaultValueConverter TO_BOOLEAN = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTBoolean, PARSE_BOOLEAN);
    private static final DefaultValueConverter TO_MAP = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTMap, PARSE_MAP);
    private static final DefaultValueConverter TO_LIST = TypeCheckers.toList(TO_ANY, Object.class);
    private final DefaultValueConverter TO_BYTE_ARRAY = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTByteArray, PARSE_BYTE_ARRAY);
    private final Map<Type, DefaultValueConverter> javaToNeo = new HashMap<Type, DefaultValueConverter>();

    public TypeCheckers() {
        this.registerScalarsAndCollections();
    }

    private void registerScalarsAndCollections() {
        this.registerType(String.class, TO_STRING);
        this.registerType(TextValue.class, TO_STRING);
        this.registerType(Long.TYPE, TO_INTEGER);
        this.registerType(Long.class, TO_INTEGER);
        this.registerType(IntegralValue.class, TO_INTEGER);
        this.registerType(Double.TYPE, TO_FLOAT);
        this.registerType(Double.class, TO_FLOAT);
        this.registerType(FloatingPointValue.class, TO_FLOAT);
        this.registerType(Number.class, TO_NUMBER);
        this.registerType(NumberValue.class, TO_NUMBER);
        this.registerType(Boolean.TYPE, TO_BOOLEAN);
        this.registerType(Boolean.class, TO_BOOLEAN);
        this.registerType(BooleanValue.class, TO_BOOLEAN);
        this.registerType(Map.class, TO_MAP);
        this.registerType(MapValue.class, TO_MAP);
        this.registerType(List.class, TO_LIST);
        this.registerType(ListValue.class, TO_LIST);
        this.registerType(Object.class, TO_ANY);
        this.registerType(AnyValue.class, TO_ANY);
        this.registerType(byte[].class, this.TO_BYTE_ARRAY);
        this.registerType(ByteArray.class, this.TO_BYTE_ARRAY);
        this.registerType(ZonedDateTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime));
        this.registerType(DateTimeValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime));
        this.registerType(LocalDateTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalDateTime));
        this.registerType(LocalDateTimeValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalDateTime));
        this.registerType(LocalDate.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDate));
        this.registerType(DateValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDate));
        this.registerType(OffsetTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTTime));
        this.registerType(TimeValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTTime));
        this.registerType(LocalTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime));
        this.registerType(LocalTimeValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime));
        this.registerType(TemporalAmount.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDuration));
        this.registerType(DurationValue.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDuration));
    }

    TypeChecker checkerFor(Type javaType) throws ProcedureException {
        return this.converterFor(javaType);
    }

    DefaultValueConverter converterFor(Type javaType) throws ProcedureException {
        DefaultValueConverter converter;
        if (this.isAnyValue(javaType)) {
            javaType = this.findValidSuperClass(javaType);
        }
        if ((converter = this.javaToNeo.get(javaType)) != null) {
            return converter;
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type rawType = pt.getRawType();
            if (rawType == List.class) {
                Type type = pt.getActualTypeArguments()[0];
                return TypeCheckers.toList(this.converterFor(type), type);
            }
            if (rawType == Map.class) {
                Type type = pt.getActualTypeArguments()[0];
                if (type != String.class) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Maps are required to have `String` keys - but this map has `%s` keys.", new Object[]{type.getTypeName()});
                }
                return TO_MAP;
            }
        }
        throw this.javaToNeoMappingError(javaType);
    }

    private boolean isAnyValue(Type type) {
        return type instanceof Class && AnyValue.class.isAssignableFrom((Class)type);
    }

    private Type findValidSuperClass(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            while (!this.javaToNeo.containsKey(aClass)) {
                aClass = aClass.getSuperclass();
            }
            return aClass;
        }
        return type;
    }

    void registerType(Class<?> javaClass, DefaultValueConverter toNeo) {
        this.javaToNeo.put(javaClass, toNeo);
    }

    @VisibleForTesting
    Set<Type> allTypes() {
        return this.javaToNeo.keySet();
    }

    private static boolean parseBooleanOrFail(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("%s is not a valid boolean expression", s));
    }

    private static DefaultValueConverter toList(DefaultValueConverter inner, Type type) {
        return new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)inner.type()), new ListConverter(type, inner.type(), EVALUATOR));
    }

    private ProcedureException javaToNeoMappingError(Type cls) {
        List types = Iterables.asList(this.javaToNeo.keySet()).stream().filter(t -> !this.isAnyValue((Type)t)).map(Type::getTypeName).sorted(String::compareTo).collect(Collectors.toList());
        return new ProcedureException((Status)Status.Statement.TypeError, "Don't know how to map `%s` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: %s", new Object[]{cls.getTypeName(), types});
    }

    public static final class DefaultValueConverter
    extends TypeChecker {
        private final Function<String, DefaultParameterValue> parser;

        DefaultValueConverter(Neo4jTypes.AnyType type) {
            this(type, DefaultValueConverter.nullParser(type));
        }

        private DefaultValueConverter(Neo4jTypes.AnyType type, Function<String, DefaultParameterValue> parser) {
            super(type);
            this.parser = parser;
        }

        public Optional<DefaultParameterValue> defaultValue(String defaultValue) throws ProcedureException {
            if (defaultValue.equals(" <[6795b15e-8693-4a21-b57a-4a7b87f09a5a]> ")) {
                return Optional.empty();
            }
            try {
                return Optional.of(this.parser.apply(defaultValue));
            }
            catch (Exception e) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Default value `%s` could not be parsed as a %s", new Object[]{defaultValue, this.type.toString()});
            }
        }

        private static Function<String, DefaultParameterValue> nullParser(Neo4jTypes.AnyType neoType) {
            return s -> {
                if (s.equalsIgnoreCase("null")) {
                    return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)neoType);
                }
                throw new IllegalArgumentException(String.format("A %s can only have a `defaultValue = \"null\"", neoType.toString()));
            };
        }
    }

    public static abstract class TypeChecker {
        final Neo4jTypes.AnyType type;

        private TypeChecker(Neo4jTypes.AnyType type) {
            this.type = type;
        }

        public Neo4jTypes.AnyType type() {
            return this.type;
        }
    }
}

