/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Optional;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.router.impl.query.AbstractQueryTargetService;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryTargetParser;

public class StandardQueryTargetService
extends AbstractQueryTargetService {
    private final QueryTargetParser queryTargetParser;
    private final DatabaseReferenceResolver databaseReferenceResolver;

    public StandardQueryTargetService(DatabaseReference sessionDatabase, QueryTargetParser queryTargetParser, DatabaseReferenceResolver databaseReferenceResolver) {
        super(sessionDatabase);
        this.queryTargetParser = queryTargetParser;
        this.databaseReferenceResolver = databaseReferenceResolver;
    }

    @Override
    public DatabaseReference determineTarget(Query query) {
        Optional<DatabaseReference> parsedTarget = this.queryTargetParser.parseQueryTarget(query).map(CatalogName::qualifiedNameString).map(this.databaseReferenceResolver::resolve);
        return parsedTarget.orElse(this.sessionDatabase);
    }
}

