/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import java.util.Locale;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class SchemaRuleException
extends SchemaKernelException {
    private final SchemaDescriptorSupplier schemaThing;
    private final String messageTemplate;

    protected SchemaRuleException(ErrorGqlStatusObject gqlStatusObject, Status status, String messageTemplate, SchemaDescriptorSupplier schemaThing, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, status, String.format(messageTemplate, SchemaRuleException.describe(schemaThing), schemaThing.schema().userDescription(tokenNameLookup)));
        this.schemaThing = schemaThing;
        this.messageTemplate = messageTemplate;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(this.messageTemplate, SchemaRuleException.describe(this.schemaThing), this.schemaThing.schema().userDescription(tokenNameLookup));
    }

    public static String describe(SchemaDescriptorSupplier schemaThing) {
        String tagType;
        SchemaDescriptor schema = schemaThing.schema();
        switch (schema.entityType()) {
            default: {
                throw new MatchException(null, null);
            }
            case NODE: {
                String string = "label";
                break;
            }
            case RELATIONSHIP: {
                String string = tagType = "relationship type";
            }
        }
        if (schemaThing instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)schemaThing;
            return switch (constraint.type()) {
                case ConstraintType.UNIQUE -> tagType + " uniqueness constraint";
                case ConstraintType.EXISTS -> tagType + " property existence constraint";
                case ConstraintType.UNIQUE_EXISTS -> schema.entityType().name().toLowerCase(Locale.ROOT) + " key constraint";
                default -> throw new AssertionError((Object)("Unknown constraint type: " + String.valueOf((Object)constraint.type())));
            };
        }
        if (schemaThing instanceof IndexDescriptor) {
            IndexDescriptor index = (IndexDescriptor)schemaThing;
            return index.getIndexType().name().toLowerCase(Locale.ROOT) + " " + tagType + " index";
        }
        return tagType + " schema";
    }
}

