/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.EndpointType;

public enum ConstraintType {
    UNIQUE(true, false, false),
    EXISTS(false, true, false),
    UNIQUE_EXISTS(true, true, false),
    PROPERTY_TYPE(false, false, true),
    RELATIONSHIP_ENDPOINT_LABEL(false, false, false),
    NODE_LABEL_EXISTENCE(false, false, false);

    private final boolean isUnique;
    private final boolean mustExist;
    private final boolean isType;

    private ConstraintType(boolean isUnique, boolean mustExist, boolean isType) {
        this.isUnique = isUnique;
        this.mustExist = mustExist;
        this.isType = isType;
    }

    public boolean enforcesUniqueness() {
        return this.isUnique;
    }

    public boolean enforcesPropertyExistence() {
        return this.mustExist;
    }

    public boolean enforcesPropertyType() {
        return this.isType;
    }

    public String userDescription(EntityType entityType, EndpointType endpointType) {
        String name = entityType.name();
        String endpointTypeCypherName = null;
        if (endpointType != null) {
            endpointTypeCypherName = switch (endpointType) {
                default -> throw new MatchException(null, null);
                case EndpointType.START -> "SOURCE";
                case EndpointType.END -> "TARGET";
            };
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> name + " PROPERTY EXISTENCE";
            case 0 -> {
                if (entityType == EntityType.NODE) {
                    yield "NODE PROPERTY UNIQUENESS";
                }
                yield "RELATIONSHIP PROPERTY UNIQUENESS";
            }
            case 2 -> name + " KEY";
            case 3 -> name + " PROPERTY TYPE";
            case 4 -> "RELATIONSHIP " + endpointTypeCypherName + " LABEL";
            case 5 -> "NODE LABEL EXISTENCE";
        };
    }
}

