/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReservedSchemaRuleNames {
    UNNAMED_INDEX("Unnamed index"),
    NO_INDEX("<No index>"),
    NO_CONSTRAINT("<No constraint>"),
    NO_RULE("<No rule>"),
    NO_SCHEMA("<No schema>"),
    NO_TRIGGER("<No trigger>"),
    NO_SEQUENCE("<No sequence>"),
    NO_CATALOG("<No catalog>"),
    NO_DATABASE("<No database>"),
    NO_GRAPH("<No graph>"),
    NO_MAP("<No map>"),
    NO_OBJECT("<No object>");

    private static final Set<String> RESERVED_NAMES;
    private final String reservedName;

    private ReservedSchemaRuleNames(String reservedName) {
        this.reservedName = reservedName;
    }

    public static boolean contains(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public static Set<String> getReservedNames() {
        return RESERVED_NAMES;
    }

    public String getReservedName() {
        return this.reservedName;
    }

    static {
        RESERVED_NAMES = Stream.of(ReservedSchemaRuleNames.values()).map(ReservedSchemaRuleNames::getReservedName).collect(Collectors.toUnmodifiableSet());
    }
}

