/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;

public class AuthProcedures {
    @Context
    public SecurityContext securityContext;
    private static final List<String> changeRequiredList = List.of("password_change_required");

    @SystemProcedure
    @Description(value="Show the current user.")
    @Procedure(name="dbms.showCurrentUser", mode=Mode.DBMS)
    public Stream<UserResult> showCurrentUser() {
        String username = this.securityContext.subject().executingUser();
        return Stream.of(new UserResult(username, false));
    }

    public static class UserResult {
        @Description(value="The name of the current user.")
        public final String username;
        @Description(value="The roles assigned to the current user.")
        public final List<String> roles = null;
        @Description(value="The flags set on the current user.")
        public final List<String> flags;

        UserResult(String username, boolean changeRequired) {
            this.username = username;
            this.flags = changeRequired ? changeRequiredList : Collections.emptyList();
        }
    }
}

