/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class InsecureRandom
extends SecureRandom {
    private static Random random() {
        return ThreadLocalRandom.current();
    }

    @Override
    public String getAlgorithm() {
        return "insecure";
    }

    @Override
    public void setSeed(byte[] seed) {
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public void nextBytes(byte[] bytes) {
        InsecureRandom.random().nextBytes(bytes);
    }

    @Override
    public byte[] generateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        InsecureRandom.random().nextBytes(seed);
        return seed;
    }

    @Override
    public int nextInt() {
        return InsecureRandom.random().nextInt();
    }

    @Override
    public int nextInt(int n) {
        return InsecureRandom.random().nextInt(n);
    }

    @Override
    public boolean nextBoolean() {
        return InsecureRandom.random().nextBoolean();
    }

    @Override
    public long nextLong() {
        return InsecureRandom.random().nextLong();
    }

    @Override
    public float nextFloat() {
        return InsecureRandom.random().nextFloat();
    }

    @Override
    public double nextDouble() {
        return InsecureRandom.random().nextDouble();
    }

    @Override
    public double nextGaussian() {
        return InsecureRandom.random().nextGaussian();
    }
}

