/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.storageengine.api.TransactionId;

public class HighestTransactionId {
    private final AtomicReference<TransactionId> highest = new AtomicReference();

    public HighestTransactionId(long initialTransactionId, int initialChecksum, long commitTimestamp, long consensusIndex) {
        this.set(initialTransactionId, initialChecksum, commitTimestamp, consensusIndex);
    }

    public boolean offer(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        TransactionId high = this.highest.get();
        if (transactionId < high.transactionId()) {
            return false;
        }
        TransactionId update = new TransactionId(transactionId, checksum, commitTimestamp, consensusIndex);
        while (!this.highest.compareAndSet(high, update)) {
            high = this.highest.get();
            if (high.transactionId() < transactionId) continue;
            return false;
        }
        return true;
    }

    public final void set(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        this.highest.set(new TransactionId(transactionId, checksum, commitTimestamp, consensusIndex));
    }

    public TransactionId get() {
        return this.highest.get();
    }
}

