/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.util;

import java.io.Serializable;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Multiplier;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Multiplier$
implements Serializable {
    public static final Multiplier$ MODULE$ = new Multiplier$();
    private static final Multiplier ZERO = new Multiplier(0.0);
    private static final Multiplier ONE = new Multiplier(1.0);

    public Multiplier ZERO() {
        return ZERO;
    }

    public Multiplier ONE() {
        return ONE;
    }

    public Multiplier lift(double amount) {
        return new Multiplier(amount);
    }

    public Multiplier min(Multiplier l, Multiplier r) {
        return new Multiplier(Math.min(l.coefficient(), r.coefficient()));
    }

    public Multiplier max(Multiplier l, Multiplier r) {
        return new Multiplier(Math.max(l.coefficient(), r.coefficient()));
    }

    public Option<Multiplier> ofDivision(Cardinality dividend, Cardinality divisor) {
        if (divisor.amount() == 0.0) {
            return None$.MODULE$;
        }
        return this.of(dividend.amount() / divisor.amount());
    }

    public Option<Multiplier> of(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value) || value < 0.0) {
            return None$.MODULE$;
        }
        return new Some((Object)new Multiplier(value));
    }

    public Multiplier apply(double coefficient) {
        return new Multiplier(coefficient);
    }

    public Option<Object> unapply(Multiplier x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)x$0.coefficient()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Multiplier$.class);
    }

    private Multiplier$() {
    }
}

