/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Objects;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Equality;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;

public class GraphReferenceValue
extends AnyValue {
    private final DatabaseReference dbRef;
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(GraphReferenceValue.class) + HeapEstimator.shallowSizeOfInstance(DatabaseReference.class);

    public GraphReferenceValue(DatabaseReference dbRef) {
        this.dbRef = dbRef;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    public DatabaseReference getDbRef() {
        return this.dbRef;
    }

    @Override
    protected boolean equalTo(Object other) {
        if (other instanceof GraphReferenceValue) {
            GraphReferenceValue val = (GraphReferenceValue)other;
            return this.dbRef == val.dbRef;
        }
        return false;
    }

    @Override
    protected int computeHash() {
        return Objects.hashCode(this);
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        throw new UnsupportedOperationException("GraphReferenceValue.writeTo not implemented");
    }

    @Override
    public Equality ternaryEquals(AnyValue other) {
        if (other == Values.NO_VALUE) {
            return Equality.UNDEFINED;
        }
        if (this.equalTo(other)) {
            return Equality.TRUE;
        }
        return Equality.FALSE;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        throw new UnsupportedOperationException("GraphReferenceValue.map not implemented");
    }

    @Override
    public String getTypeName() {
        return "GraphReference";
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.UNKNOWN;
    }
}

