/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.SingletonMapValue;

public class MapValueBuilder {
    private final Map<String, AnyValue> map;
    private long payloadSize;

    public MapValueBuilder() {
        this.map = new HashMap<String, AnyValue>();
    }

    public MapValueBuilder(int expectedSize) {
        this.map = new HashMap<String, AnyValue>(MapValueBuilder.capacity(expectedSize));
    }

    public AnyValue add(String key, AnyValue value) {
        AnyValue put = this.map.put(key, value);
        this.payloadSize = put == null ? (this.payloadSize += HeapEstimator.sizeOf((String)key) + value.estimatedHeapUsage()) : (this.payloadSize += value.estimatedHeapUsage() - put.estimatedHeapUsage());
        return put;
    }

    public void clear() {
        this.map.clear();
        this.payloadSize = 0L;
    }

    public MapValue build() {
        int size = this.map.size();
        if (size == 0) {
            return MapValue.EMPTY;
        }
        if (size == 1) {
            Map.Entry first = (Map.Entry)Iterables.first(this.map.entrySet());
            return new SingletonMapValue((String)first.getKey(), (AnyValue)first.getValue());
        }
        return new MapValue.MapWrappingMapValue(this.map, this.payloadSize);
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Preconditions.requirePositive((int)expectedSize);
            return expectedSize + 1;
        }
        return (int)((float)expectedSize / 0.75f + 1.0f);
    }
}

