/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.NonPrimitiveArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class PointArray
extends NonPrimitiveArray<PointValue> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PointArray.class);
    private final PointValue[] value;

    PointArray(PointValue[] value) {
        assert (value != null);
        this.value = value;
    }

    protected PointValue[] value() {
        return this.value;
    }

    public PointValue pointValue(int offset) {
        return this.value()[offset];
    }

    @Override
    public boolean equals(Geometry[] x) {
        return Arrays.equals(this.value(), x);
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof PointArray && Arrays.equals(this.value(), ((PointArray)other).value());
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.GEOMETRY_ARRAY;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPointArray(this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value());
    }

    @Override
    public AnyValue value(int offset) {
        return Values.point(this.value[offset]);
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((PointArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "PointArray";
    }

    public long estimatedHeapUsage() {
        int length = this.value.length;
        return SHALLOW_SIZE + (length == 0 ? 0L : HeapEstimator.sizeOfObjectArray((long)this.value[0].estimatedHeapUsage(), (int)length));
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof PointValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        PointValue[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = (PointValue)added;
        return new PointArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        PointValue[] newArray = new PointValue[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = (PointValue)prepended;
        return new PointArray(newArray);
    }
}

