/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueComparator;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValueGroup;

class AnyValueComparator
implements TernaryComparator<AnyValue> {
    private final Comparator<VirtualValueGroup> virtualValueGroupComparator;
    private final ValueComparator valueComparator;

    AnyValueComparator(ValueComparator valueComparator, Comparator<VirtualValueGroup> virtualValueGroupComparator) {
        this.virtualValueGroupComparator = virtualValueGroupComparator;
        this.valueComparator = valueComparator;
    }

    @Override
    public int compare(AnyValue v1, AnyValue v2) {
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (v1 == v2) {
            return 0;
        }
        if (v1 == Values.NO_VALUE) {
            return 1;
        }
        if (v2 == Values.NO_VALUE) {
            return -1;
        }
        boolean isSequence1 = v1.isSequenceValue();
        boolean isSequence2 = v2.isSequenceValue();
        if (isSequence1 && isSequence2) {
            return ((SequenceValue)((Object)v1)).compareToSequence((SequenceValue)((Object)v2), this);
        }
        if (isSequence1) {
            return this.compareSequenceAndNonSequence(v2);
        }
        if (isSequence2) {
            return -this.compareSequenceAndNonSequence(v1);
        }
        boolean isValue1 = v1 instanceof Value;
        boolean isValue2 = v2 instanceof Value;
        int x = Boolean.compare(isValue1, isValue2);
        if (x == 0) {
            if (isValue1) {
                return this.valueComparator.compare((Value)v1, (Value)v2);
            }
            return this.compareVirtualValues((VirtualValue)v1, (VirtualValue)v2);
        }
        return x;
    }

    @Override
    public Comparison ternaryCompare(AnyValue v1, AnyValue v2) {
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (v1 == Values.NO_VALUE || v2 == Values.NO_VALUE) {
            return Comparison.UNDEFINED;
        }
        boolean isSequence1 = v1.isSequenceValue();
        boolean isSequence2 = v2.isSequenceValue();
        if (isSequence1 && isSequence2) {
            return ((SequenceValue)((Object)v1)).ternaryCompareToSequence((SequenceValue)((Object)v2), this);
        }
        if (isSequence1 || isSequence2) {
            return Comparison.UNDEFINED;
        }
        boolean isValue1 = v1 instanceof Value;
        boolean isValue2 = v2 instanceof Value;
        if (isValue1 && isValue2) {
            return this.valueComparator.ternaryCompare((Value)v1, (Value)v2);
        }
        if (!isValue1 && !isValue2) {
            return this.ternaryCompareVirtualValues((VirtualValue)v1, (VirtualValue)v2);
        }
        return Comparison.UNDEFINED;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AnyValueComparator;
    }

    public int hashCode() {
        return 1;
    }

    private int compareVirtualValues(VirtualValue v1, VirtualValue v2) {
        VirtualValueGroup id2;
        VirtualValueGroup id1 = v1.valueGroup();
        int x = this.virtualValueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.unsafeCompareTo(v2, this);
        }
        return x;
    }

    private Comparison ternaryCompareVirtualValues(VirtualValue v1, VirtualValue v2) {
        VirtualValueGroup id2;
        VirtualValueGroup id1 = v1.valueGroup();
        if (id1 == (id2 = v2.valueGroup())) {
            return v1.unsafeTernaryCompareTo(v2, this);
        }
        return Comparison.UNDEFINED;
    }

    private int compareSequenceAndNonSequence(AnyValue v) {
        boolean isValue2 = v instanceof Value;
        if (isValue2) {
            return -1;
        }
        return this.virtualValueGroupComparator.compare(VirtualValueGroup.LIST, ((VirtualValue)v).valueGroup());
    }
}

