/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public abstract class LogEntrySerializer<T extends LogEntry> {
    protected static final int NO_RETURN_VALUE = 0;
    private final byte type;

    protected LogEntrySerializer(byte type) {
        this.type = type;
    }

    byte type() {
        return this.type;
    }

    public abstract T parse(KernelVersion var1, ReadableChannel var2, LogPositionMarker var3, CommandReaderFactory var4, MemoryTracker var5) throws IOException;

    public abstract int write(WritableChannel var1, T var2) throws IOException;

    public static void writeLogEntryHeader(KernelVersion kernelVersion, byte type, WritableChannel channel) throws IOException {
        channel.putVersion(kernelVersion.version()).put(type).putContentType((byte)64);
    }
}

