/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryDetachedCheckpointV5_20;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntrySerializerV5_20
extends LogEntrySerializer<LogEntryDetachedCheckpointV5_20> {
    public static final int RECORD_LENGTH_BYTES = 232;
    public static final int MAX_DESCRIPTION_LENGTH = 91;

    public DetachedCheckpointLogEntrySerializerV5_20() {
        super((byte)9);
    }

    @Override
    public LogEntryDetachedCheckpointV5_20 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        long checkpointTimeMillis = channel.getLong();
        byte[] storeIdBuffer = new byte[64];
        channel.get(storeIdBuffer, storeIdBuffer.length);
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        TransactionId transactionId = new TransactionId(channel.getLong(), channel.getLong(), KernelVersion.getForVersion((byte)channel.get()), channel.getInt(), channel.getLong(), channel.getLong());
        long appendIndex = channel.getLong();
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[91];
        channel.get(bytes, 91);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV5_20(version, transactionId, appendIndex, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason);
    }

    @Override
    public int write(WritableChannel channel, LogEntryDetachedCheckpointV5_20 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        DetachedCheckpointLogEntrySerializerV5_20.writeLogEntryHeader(logEntry.kernelVersion(), (byte)9, channel);
        byte[] storeIdBuffer = new byte[64];
        StoreIdSerialization.serializeWithFixedSize((StoreId)logEntry.getStoreId(), (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        byte[] reasonBytes = logEntry.getReason().getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 91));
        byte[] descriptionBytes = new byte[91];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        LogPosition logPosition = logEntry.getCheckpointedLogPosition();
        TransactionId transactionId = logEntry.getTransactionId();
        channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(logEntry.getCheckpointTime()).put(storeIdBuffer, storeIdBuffer.length).putLong(transactionId.id()).putLong(transactionId.appendIndex()).put(transactionId.kernelVersion().version()).putInt(transactionId.checksum()).putLong(transactionId.commitTimestamp()).putLong(transactionId.consensusIndex()).putLong(logEntry.getLastAppendIndex()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        return channel.putChecksum();
    }
}

