/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannelProvider;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeWriteChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogFilesMetadata;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogFilesPreAllocator;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogFilesPruner;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogHeaderFactory;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.kernel.impl.transaction.log.enveloped.PruneStrategy;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.memory.MemoryTracker;

public class EnvelopedLogFiles
implements EnvelopeReadChannelProvider,
AutoCloseable {
    public static final int INITIAL_CHECKSUM = 0;
    public static final long BASE_INDEX = 0L;
    public static final int MINIMUM_SEGMENTS = 2;
    private final int segmentBlockSize;
    private final int writerBufferedBlocks;
    private final MemoryTracker memoryTracker;
    private final LogRotation logRotation;
    private final LogTracers logTracers = LogTracers.NULL;
    private final LogsRepository logsRepository;
    private final long maxFileSize;
    private final LogHeaderFactory logHeaderFactory;
    private final LogFilesPruner logFilesPruner;
    private final LogFilesPreAllocator logFilesPreAllocator;
    private LogChannelContext<StoreChannel> currentWriteChannel;
    private EnvelopeWriteChannel appendingChannel;

    public EnvelopedLogFiles(FileSystemAbstraction fs, Path directory, String baseFileName, LogHeaderFactory logHeaderFactory, int segmentBlockSize, int writerBufferedBlocks, int totalSegments, MemoryTracker memoryTracker, PruneStrategy pruneStrategy, LogFilesPreAllocator logFilesPreAllocator) {
        if (totalSegments < 2) {
            throw new IllegalArgumentException(String.format("Must have at least %d segments. Got %d", 2, totalSegments));
        }
        this.logFilesPreAllocator = logFilesPreAllocator;
        this.logHeaderFactory = logHeaderFactory;
        this.logsRepository = new LogsRepository(fs, directory, baseFileName);
        this.segmentBlockSize = segmentBlockSize;
        this.writerBufferedBlocks = writerBufferedBlocks;
        this.memoryTracker = memoryTracker;
        this.maxFileSize = (long)totalSegments * (long)segmentBlockSize;
        this.logRotation = new EnvelopedLogRotation(this, this.maxFileSize);
        this.logFilesPruner = new LogFilesPruner(this.logsRepository, pruneStrategy);
    }

    public EnvelopeWriteChannel currentWriteChannel() {
        if (this.appendingChannel == null) {
            throw new IllegalStateException("Writer channel has not been initialised");
        }
        return this.appendingChannel;
    }

    @Override
    public EnvelopeReadChannel openReadChannel() throws IOException {
        if (this.logsRepository.isEmpty()) {
            throw new IllegalStateException("No log files found " + String.valueOf(this.logsRepository));
        }
        long version = this.logsRepository.logVersions(false)[0];
        return this.envelopedReadChannel(this.logsRepository.openReadChannel(version), version);
    }

    @Override
    public EnvelopeReadChannel openReadChannel(long fileWithIndex) throws IOException {
        long[] logFileVersions = this.logsRepository.logVersions(false);
        int low = 0;
        int high = logFileVersions.length - 1;
        while (low <= high) {
            long midVal;
            LogHeader midLogHeader;
            int mid = low + high >>> 1;
            long midVersion = logFileVersions[mid];
            try (LogChannelContext<StoreChannel> channel = this.logsRepository.openReadChannel(midVersion);){
                midLogHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)channel.channel(), true, null, this.memoryTracker);
            }
            long l = midVal = midLogHeader == null ? Long.MAX_VALUE : midLogHeader.getLastAppendIndex();
            if (midVal < fileWithIndex) {
                low = mid + 1;
                continue;
            }
            if (midVal > fileWithIndex) {
                high = mid - 1;
                continue;
            }
            low = mid;
            break;
        }
        if (low == 0) {
            return null;
        }
        long fileVersion = logFileVersions[low - 1];
        return this.envelopedReadChannel(this.logsRepository.openReadChannel(fileVersion), fileVersion);
    }

    public long initialise() throws IOException {
        this.logsRepository.initialise();
        if (!this.logsRepository.isEmpty()) {
            long[] versions;
            for (long version : versions = this.logsRepository.logVersions(true)) {
                try (EnvelopeReadChannel readChannel = this.envelopedReadChannel(this.logsRepository.openReadChannel(version), version);){
                    if (readChannel.logHeader() == null) continue;
                    try {
                        while (true) {
                            readChannel.goToNextEntry();
                        }
                    }
                    catch (ReadPastEndException readPastEndException) {
                        int prevChecksum = readChannel.getChecksum();
                        LogChannelContext<StoreChannel> logChannelCtx = this.openWriteChannel(readChannel.getLogVersion(), readChannel.position());
                        boolean isLogBoundary = readChannel.entryIndex() == -1L;
                        long latestLogIndex = isLogBoundary ? readChannel.logHeader().getLastAppendIndex() : readChannel.entryIndex();
                        this.updateState(logChannelCtx, prevChecksum, latestLogIndex);
                        long l = latestLogIndex;
                        if (readChannel != null) {
                            readChannel.close();
                        }
                        return l;
                    }
                }
            }
        }
        LogChannelContext<StoreChannel> logChannelCtx = this.createNewStoreChannel(0L, this.logHeaderFactory.createLogHeader(0L, -1L, 0, this.segmentBlockSize));
        this.updateState(logChannelCtx, 0, -1L);
        return -1L;
    }

    public EnvelopeWriteChannel truncate(long fromIndex) throws IOException {
        int offset;
        int prevChecksum;
        long position;
        long prevTerm;
        long version;
        long lastAppendedIndex;
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("Negative values is not allowed " + fromIndex);
        }
        long l = lastAppendedIndex = this.appendingChannel == null ? -1L : this.appendingChannel.currentIndex();
        if (this.appendingChannel != null && fromIndex > lastAppendedIndex) {
            throw new IllegalArgumentException("Cannot truncate at index " + fromIndex + " when last appended index is " + lastAppendedIndex);
        }
        try (EnvelopeReadChannel readChannel = this.openReadChannel(fromIndex);){
            if (readChannel == null) {
                throw new IllegalArgumentException(fromIndex + " has been pruned");
            }
            version = readChannel.getLogVersion();
            prevTerm = readChannel.currentTerm();
            position = readChannel.position();
            prevChecksum = readChannel.logHeader().getPreviousLogFileChecksum();
            while (readChannel.entryIndex() < fromIndex) {
                prevChecksum = readChannel.getChecksum();
                prevTerm = readChannel.currentTerm();
                version = readChannel.getLogVersion();
                position = readChannel.goToNextEnvelope();
            }
            offset = readChannel.getSegmentOffset(position);
        }
        if (this.currentWriteChannel.version() != version) {
            this.appendingChannel = null;
            this.currentWriteChannel.channel().close();
            this.currentWriteChannel = null;
            this.logsRepository.deleteLogFilesFrom(version + 1L);
            this.currentWriteChannel = this.openWriteChannel(version, position);
            this.appendingChannel = this.envelopedWriteChannel(this.currentWriteChannel, -1, Integer.MAX_VALUE);
        }
        this.appendingChannel.truncateToPosition(position, prevChecksum, fromIndex - 1L, prevTerm);
        if (offset > 0) {
            this.appendingChannel.insertStartOffset(offset);
        }
        this.appendingChannel.prepareForFlush().flush();
        return this.appendingChannel;
    }

    public void forceRotate() throws IOException {
        this.appendingChannel.truncateToPosition(this.appendingChannel.position(), this.appendingChannel.currentChecksum(), this.appendingChannel.currentIndex(), this.appendingChannel.currentTerm());
    }

    public void skip(long index, int checksum, int offset) throws IOException {
        if (index > this.appendingChannel.currentIndex()) {
            long prunedVersion = this.logsRepository.logVersionsRange().to();
            this.logsRepository.deleteLogFilesTo(prunedVersion);
            long nextVersion = prunedVersion + 1L;
            LogChannelContext<StoreChannel> newStoreChannel = this.createNewStoreChannel(nextVersion, this.logHeaderFactory.createLogHeader(nextVersion, index, checksum, this.segmentBlockSize));
            this.updateState(newStoreChannel, checksum, index);
            if (offset > 0) {
                this.currentWriteChannel().insertStartOffset(offset);
                this.currentWriteChannel().prepareForFlush().flush();
            }
        }
    }

    public long prune(long index) throws IOException {
        long versionToPrune;
        try (EnvelopeReadChannel reader = this.openReadChannel(index);){
            if (reader == null) {
                long l = -1L;
                return l;
            }
            long logVersion = reader.getLogVersion();
            versionToPrune = logVersion - 1L;
            if (!this.logsRepository.logVersionsRange().isWithinRange(versionToPrune)) {
                long l = -1L;
                return l;
            }
        }
        EnvelopeWriteChannel envelopeWriteChannel = this.currentWriteChannel();
        long prunedVersion = this.logFilesPruner.pruneUpTo(versionToPrune, envelopeWriteChannel.currentIndex(), envelopeWriteChannel.position(), this.currentWriteChannel.version());
        if (prunedVersion == -1L) {
            return -1L;
        }
        assert (!this.logsRepository.isEmpty());
        LogFilesMetadata logFilesMetadata = this.logFilesMetadata();
        logFilesMetadata.next();
        return logFilesMetadata.get().logHeader().getLastAppendIndex();
    }

    private void rotateCurrentFile(long lastAppendIndex, int checksum) throws IOException {
        if (this.appendingChannel == null) {
            throw new IllegalStateException("Cannot rotate if not initialised");
        }
        long nextVersion = this.currentWriteChannel.version() + 1L;
        LogChannelContext<StoreChannel> newStoreChannel = this.createNewStoreChannel(nextVersion, this.logHeaderFactory.createLogHeader(nextVersion, lastAppendIndex, checksum, this.segmentBlockSize));
        this.appendingChannel.prepareForFlush().flush();
        this.currentWriteChannel.channel().truncate(this.currentWriteChannel.channel().position());
        this.updateState(newStoreChannel, checksum, lastAppendIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.appendingChannel != null) {
            this.appendingChannel.close();
            this.currentWriteChannel = null;
        }
    }

    private void updateState(LogChannelContext<StoreChannel> logChannelCtx, int checksumAtPosition, long prevIndex) throws IOException {
        if (this.appendingChannel == null) {
            this.appendingChannel = this.envelopedWriteChannel(logChannelCtx, checksumAtPosition, prevIndex);
        } else {
            this.appendingChannel.prepareForFlush().flush();
            this.currentWriteChannel.channel().flush();
            if (prevIndex != this.appendingChannel.currentIndex()) {
                this.appendingChannel = this.envelopedWriteChannel(logChannelCtx, checksumAtPosition, prevIndex);
            } else {
                this.appendingChannel.setChannel(logChannelCtx.channel());
            }
            this.currentWriteChannel.channel().close();
        }
        this.currentWriteChannel = logChannelCtx;
    }

    private LogChannelContext<StoreChannel> createNewStoreChannel(long version, LogHeader logHeader) throws IOException {
        LogChannelContext<StoreChannel> logChannelCtx = this.logsRepository.createWriteChannel(version);
        this.logFilesPreAllocator.preAllocateLogFile(logChannelCtx, this.maxFileSize);
        logChannelCtx.channel().position(0L);
        LogFormat.writeLogHeader((StoreChannel)logChannelCtx.channel(), (LogHeader)logHeader, (MemoryTracker)this.memoryTracker);
        logChannelCtx.channel().flush();
        logChannelCtx.channel().position((long)this.segmentBlockSize);
        return logChannelCtx;
    }

    private LogChannelContext<StoreChannel> openWriteChannel(long version, long position) throws IOException {
        LogChannelContext<StoreChannel> logChannelCtx = this.logsRepository.openWriteChannel(version);
        position = position == 0L ? (long)this.segmentBlockSize : position;
        logChannelCtx.channel().position(position);
        return logChannelCtx;
    }

    private EnvelopeWriteChannel envelopedWriteChannel(LogChannelContext<StoreChannel> logChannelCtx, int checksumAtPosition, long prevIndex) throws IOException {
        return new EnvelopeWriteChannel(logChannelCtx.channel(), (ScopedBuffer)this.scoopedBuffer(), this.segmentBlockSize, checksumAtPosition, prevIndex, this.logTracers, this.logRotation);
    }

    private HeapScopedBuffer scoopedBuffer() {
        return new HeapScopedBuffer(this.writerBufferedBlocks * this.segmentBlockSize, ByteOrder.LITTLE_ENDIAN, this.memoryTracker);
    }

    EnvelopeReadChannel envelopedReadChannel(LogChannelContext<StoreChannel> logChannelCtx, long version) throws IOException {
        PhysicalLogVersionedStoreChannel logVersionedChannel = this.logVersionedChannel(logChannelCtx, version);
        return new EnvelopeReadChannel((LogVersionedStoreChannel)logVersionedChannel, this.segmentBlockSize, (LogVersionBridge)new EnvelopedLogVersionBridge(this), this.memoryTracker, false);
    }

    private PhysicalLogVersionedStoreChannel logVersionedChannel(LogChannelContext<StoreChannel> logChannelCtx, long version) throws IOException {
        return new PhysicalLogVersionedStoreChannel(logChannelCtx.channel(), version, LogFormat.V9, logChannelCtx.path(), ChannelNativeAccessor.EMPTY_ACCESSOR, this.logTracers);
    }

    private LogVersionedStoreChannel safeOpenChannel(long version) throws IOException {
        LongRange longRange = this.logsRepository.logVersionsRange();
        if (longRange.isWithinRange(version)) {
            return this.logVersionedChannel(this.logsRepository.openReadChannel(version), version);
        }
        return null;
    }

    public LogFilesMetadata logFilesMetadata() throws IOException {
        return this.logFilesMetadata(false);
    }

    public LogFilesMetadata logFilesMetadata(boolean reversed) throws IOException {
        return new LogFilesMetadata(this.logsRepository, reversed);
    }

    public void remove() throws IOException {
        this.close();
        this.logsRepository.deleteLogFilesFrom(0L);
    }

    private static class EnvelopedLogRotation
    implements LogRotation {
        private final EnvelopedLogFiles envelopedLogFiles;
        private final long maxFileSize;

        EnvelopedLogRotation(EnvelopedLogFiles envelopedLogFiles, long maxFileSize) {
            this.envelopedLogFiles = envelopedLogFiles;
            this.maxFileSize = maxFileSize;
        }

        @Override
        public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public boolean locklessBatchedRotateLogIfNeeded(LogRotateEvents logRotateEvents, long lastAppendIndex, KernelVersion kernelVersion, int checksum, LogFormat logFormat) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            return this.rotateLogIfNeeded(logRotateEvents);
        }

        @Override
        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, boolean force) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public void rotateLogFile(LogRotateEvents logRotateEvents, long lastAppendIndex, int previousChecksum) throws IOException {
            try (LogRotateEvent event = logRotateEvents.beginLogRotate();){
                this.envelopedLogFiles.rotateCurrentFile(lastAppendIndex, previousChecksum);
                event.rotationCompleted(0L);
            }
        }

        @Override
        public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum, LogFormat logFormat) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public long rotationSize() {
            return this.maxFileSize;
        }
    }

    private static class EnvelopedLogVersionBridge
    implements LogVersionBridge {
        private final EnvelopedLogFiles envelopedLogFiles;

        public EnvelopedLogVersionBridge(EnvelopedLogFiles envelopedLogFiles) {
            this.envelopedLogFiles = envelopedLogFiles;
        }

        @Override
        public LogVersionedStoreChannel next(LogVersionedStoreChannel channel, boolean raw) throws IOException {
            LogVersionedStoreChannel nextChannel = this.envelopedLogFiles.safeOpenChannel(channel.getLogVersion() + 1L);
            if (nextChannel != null) {
                channel.close();
                return nextChannel;
            }
            return channel;
        }
    }
}

