/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvent;

public class CountingLogRotateEvent
implements LogRotateEvent {
    private final AtomicLong rotationCounter = new AtomicLong();
    private final AtomicLong accumulatedRotationTimeMillis = new AtomicLong();
    private volatile long lastRotationTimeMillis;

    @Override
    public void rotationCompleted(long rotationMillis) {
        this.rotationCounter.incrementAndGet();
        this.accumulatedRotationTimeMillis.addAndGet(rotationMillis);
        this.lastRotationTimeMillis = rotationMillis;
    }

    @Override
    public void close() {
    }

    public long numberOfLogRotations() {
        return this.rotationCounter.get();
    }

    public long logRotationAccumulatedTotalTimeMillis() {
        return this.accumulatedRotationTimeMillis.get();
    }

    public long lastLogRotationTimeMillis() {
        return this.lastRotationTimeMillis;
    }
}

