/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;

class LogsRepository {
    static final long BASE_VERSION = 0L;
    private static final char VERSION_SUFFIX = '.';
    private final FileSystemAbstraction fs;
    private final Path directory;
    private final String baseName;
    private final Pattern pattern;

    LogsRepository(FileSystemAbstraction fs, Path directory, String baseName) {
        if (fs.fileExists(directory) && !fs.isDirectory(directory)) {
            throw new IllegalArgumentException("Not a directory: " + String.valueOf(directory));
        }
        this.fs = fs;
        this.directory = directory;
        this.baseName = baseName;
        this.pattern = Pattern.compile(baseName + ".(?<VERSION>[0-9]*)");
    }

    LogChannelContext<StoreChannel> openReadChannel(long version) throws IOException {
        return this.openLogChannel(version, Set.of(StandardOpenOption.READ));
    }

    LogChannelContext<StoreChannel> createWriteChannel(long version) throws IOException {
        return this.openLogChannel(version, Set.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE));
    }

    LogChannelContext<StoreChannel> openWriteChannel(long version) throws IOException {
        return this.openLogChannel(version, Set.of(StandardOpenOption.WRITE));
    }

    private LogChannelContext<StoreChannel> openLogChannel(long version, Set<OpenOption> options) throws IOException {
        Path path = this.getPathFor(version);
        return new LogChannelContext<StoreChannel>(this.fs.open(path, options), path, version);
    }

    void deleteLogFilesFrom(long fromVersion) throws IOException {
        this.deleteLogFilesWithinRange(LongRange.range((long)fromVersion, (long)Long.MAX_VALUE));
    }

    void deleteLogFilesTo(long toVersion) throws IOException {
        this.deleteLogFilesWithinRange(LongRange.range((long)0L, (long)toVersion));
    }

    private void deleteLogFilesWithinRange(LongRange range) throws IOException {
        Path[] listLogFiles;
        boolean reverse = range.to() == Long.MAX_VALUE;
        for (Path path : listLogFiles = this.listLogFiles(reverse)) {
            Long version = this.getVersion(path.getFileName().toString());
            if (!range.isWithinRange(version.longValue())) {
                return;
            }
            this.fs.deleteFile(path);
        }
    }

    long[] logVersions(boolean reversed) throws IOException {
        return Arrays.stream(this.listLogFiles(reversed)).mapToLong(path -> this.getVersion(path.getFileName().toString())).toArray();
    }

    LongRange logVersionsRange() throws IOException {
        long[] versions = this.logVersions(false);
        if (versions.length == 0) {
            return LongRange.EMPTY_RANGE;
        }
        return LongRange.range((long)versions[0], (long)versions[versions.length - 1]);
    }

    boolean isEmpty() throws IOException {
        return this.listLogFiles(false).length == 0;
    }

    private Long getVersion(String fileName) {
        Matcher matcher = this.pattern.matcher(fileName);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unexpected file with no version. Got " + fileName);
        }
        return Long.parseLong(matcher.group("VERSION"));
    }

    private Path[] listLogFiles(boolean reverse) throws IOException {
        Comparator comparator = (o1, o2) -> this.getVersion(o1.getFileName().toString()).compareTo(this.getVersion(o2.getFileName().toString()));
        if (reverse) {
            comparator = comparator.reversed();
        }
        Path[] paths = this.fs.listFiles(this.directory, entry -> entry.getFileName().toString().startsWith(this.baseName));
        Arrays.sort(paths, comparator);
        return paths;
    }

    private Path getPathFor(long version) {
        return this.directory.resolve(this.baseName + "." + version);
    }

    public void initialise() throws IOException {
        if (!this.fs.fileExists(this.directory)) {
            this.fs.mkdir(this.directory);
        }
    }
}

