/*
 * Decompiled with CFR 0.152.
 */
package apoc;

import apoc.ApocConfig;
import apoc.ApocGlobalComponents;
import apoc.Pools;
import apoc.RegisterComponentFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;

public class ApocExtensionFactory
extends ExtensionFactory<Dependencies> {
    public ApocExtensionFactory() {
        super(ExtensionType.DATABASE, "APOC");
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        GraphDatabaseAPI db = dependencies.graphdatabaseAPI();
        LogService log = dependencies.log();
        return new ApocLifecycle(log, db, dependencies);
    }

    public static interface Dependencies {
        public GraphDatabaseAPI graphdatabaseAPI();

        public JobScheduler scheduler();

        public LogService log();

        public AvailabilityGuard availabilityGuard();

        public DatabaseManagementService databaseManagementService();

        public ApocConfig apocConfig();

        public DatabaseEventListeners databaseEventListeners();

        public GlobalProcedures globalProceduresRegistry();

        public RegisterComponentFactory.RegisterComponentLifecycle registerComponentLifecycle();

        public Pools pools();
    }

    public static class ApocLifecycle
    extends LifecycleAdapter {
        private final Log userLog;
        private final GraphDatabaseAPI db;
        private final Dependencies dependencies;
        private final Map<String, Lifecycle> services = new HashMap<String, Lifecycle>();
        private final Collection<ApocGlobalComponents> apocGlobalComponents;
        private final Collection<AvailabilityListener> registeredListeners = new ArrayList<AvailabilityListener>();

        public ApocLifecycle(LogService log, GraphDatabaseAPI db, Dependencies dependencies) {
            this.db = db;
            this.dependencies = dependencies;
            this.userLog = log.getUserLog(ApocExtensionFactory.class);
            this.apocGlobalComponents = Services.loadAll(ApocGlobalComponents.class);
        }

        public static void withNonSystemDatabase(GraphDatabaseService db, Consumer<Void> consumer) {
            if (!"system".equals(db.databaseName())) {
                consumer.accept(null);
            }
        }

        public void init() {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> {
                for (ApocGlobalComponents c : this.apocGlobalComponents) {
                    this.services.putAll(c.getServices(this.db, this.dependencies));
                }
                String databaseName = this.db.databaseName();
                this.services.values().forEach(lifecycle -> this.dependencies.registerComponentLifecycle().addResolver(databaseName, lifecycle.getClass(), lifecycle));
            });
        }

        public void start() {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> this.services.forEach((key, value) -> {
                try {
                    value.start();
                }
                catch (Exception e) {
                    this.userLog.error("failed to start service " + key, (Throwable)e);
                }
            }));
            AvailabilityGuard availabilityGuard = this.dependencies.availabilityGuard();
            for (ApocGlobalComponents c : this.apocGlobalComponents) {
                for (AvailabilityListener listener : c.getListeners(this.db, this.dependencies)) {
                    this.registeredListeners.add(listener);
                    availabilityGuard.addListener(listener);
                }
            }
        }

        public void stop() {
            ApocLifecycle.withNonSystemDatabase((GraphDatabaseService)this.db, aVoid -> this.services.forEach((key, value) -> {
                try {
                    value.stop();
                }
                catch (Exception e) {
                    this.userLog.error("failed to stop service " + key, (Throwable)e);
                }
            }));
            AvailabilityGuard availabilityGuard = this.dependencies.availabilityGuard();
            this.registeredListeners.forEach(arg_0 -> ((AvailabilityGuard)availabilityGuard).removeListener(arg_0));
            this.registeredListeners.clear();
        }

        public Collection<AvailabilityListener> getRegisteredListeners() {
            return this.registeredListeners;
        }
    }
}

