/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.CountingReader;
import apoc.export.util.SizeCounter;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.SeekableByteChannel;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.input.BOMInputStream;

public class CountingInputStream
extends FilterInputStream
implements SizeCounter {
    public static final int BUFFER_SIZE = 0x100000;
    private final long total;
    private long count = 0L;

    public CountingInputStream(InputStream stream, long total) {
        super(CountingInputStream.toBufferedStream(stream));
        this.total = total;
    }

    private static BufferedInputStream toBufferedStream(InputStream stream) {
        BOMInputStream bomInputStream = new BOMInputStream(stream);
        return new BufferedInputStream((InputStream)bomInputStream, 0x100000);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int read = super.read(buf, off, len);
        this.count += (long)read;
        return read;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        return super.read();
    }

    @Override
    public long skip(long n) throws IOException {
        this.count += n;
        return super.skip(n);
    }

    @Override
    public long getPercent() {
        if (this.total <= 0L) {
            return 0L;
        }
        return this.count * 100L / this.total;
    }

    public CountingReader asReader() throws IOException {
        InputStreamReader reader = new InputStreamReader(this.in, "UTF-8");
        return new CountingReader(reader, this.total);
    }

    public SeekableByteChannel asChannel() throws IOException {
        return new SeekableInMemoryByteChannel(this.readAllBytes());
    }
}

