/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.meta.Types;
import apoc.util.Util;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;

public class Mapping {
    final String name;
    final Collection<String> nullValues;
    final Types type;
    final boolean array;
    final boolean ignore;
    final char arraySep;
    private final Pattern arrayPattern;
    private final Map<String, Object> optionalData;

    public Mapping(String name, Map<String, Object> mapping, char arraySep, boolean ignore) {
        this.name = mapping.getOrDefault("name", name).toString();
        this.array = (Boolean)mapping.getOrDefault("array", false);
        this.optionalData = (Map)mapping.get("optionalData");
        this.ignore = (Boolean)mapping.getOrDefault("ignore", ignore);
        this.nullValues = mapping.getOrDefault("nullValues", Collections.emptyList());
        this.arraySep = Util.parseCharFromConfig(mapping, "arraySep", arraySep);
        this.type = Types.from(mapping.getOrDefault("type", "STRING").toString());
        this.arrayPattern = Pattern.compile(String.valueOf(this.arraySep), 16);
        if (this.type == null) {
            throw new RuntimeException("In specified mapping, there is no type by the name " + mapping.getOrDefault("type", "STRING").toString());
        }
    }

    public Object convert(String value) {
        return this.array ? this.convertArray(value) : this.convertType(value);
    }

    private Object convertArray(String value) {
        String[] values = this.arrayPattern.split(value);
        ArrayList<Object> result = new ArrayList<Object>(values.length);
        for (String v : values) {
            result.add(this.convertType(v));
        }
        return result;
    }

    private Object convertType(String value) {
        if (this.nullValues.contains(value) || StringUtils.isBlank((CharSequence)value) && !this.type.equals((Object)Types.STRING)) {
            return null;
        }
        if (this.type == Types.STRING) {
            return value;
        }
        Supplier<ZoneId> timezone = () -> ZoneId.of((String)this.optionalData.getOrDefault("timezone", ApocConfig.apocConfig().getString(GraphDatabaseSettings.db_temporal_timezone.name())));
        switch (this.type) {
            case POINT: {
                return Util.toPoint(Util.fromJson(value, Map.class), this.optionalData);
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.parse((CharSequence)value).asObjectCopy();
            }
            case LOCAL_TIME: {
                return LocalTimeValue.parse((CharSequence)value).asObjectCopy();
            }
            case DATE_TIME: {
                return DateTimeValue.parse((CharSequence)value, timezone).asObjectCopy();
            }
            case TIME: {
                return TimeValue.parse((CharSequence)value, timezone).asObjectCopy();
            }
            case DATE: {
                return DateValue.parse((CharSequence)value).asObjectCopy();
            }
            case DURATION: {
                return DurationValue.parse((CharSequence)value);
            }
            case INTEGER: {
                return Util.toLong(value);
            }
            case FLOAT: {
                return Util.toDouble(value);
            }
            case BOOLEAN: {
                return Util.toBoolean(value);
            }
            case NULL: {
                return null;
            }
            case LIST: {
                return Arrays.stream(this.arrayPattern.split(value)).map(this::convertType).collect(Collectors.toList());
            }
        }
        return value;
    }
}

