/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.collection;

import apoc.util.collection.ResourceIteratorCloseFailedException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;

public abstract class AbstractResourceIterable<T>
implements ResourceIterable<T> {
    private TrackingResourceIterator<?>[] trackedIterators = new TrackingResourceIterator[2];
    private BitSet trackedIteratorsInUse = new BitSet();
    private boolean closed;

    protected abstract ResourceIterator<T> newIterator();

    public final ResourceIterator<T> iterator() {
        if (this.closed) {
            throw new ResourceIteratorCloseFailedException(ResourceIterable.class.getSimpleName() + " has already been closed");
        }
        return new TrackingResourceIterator<T>(Objects.requireNonNull(this.newIterator()), this::register, this::unregister);
    }

    public final void close() {
        if (!this.closed) {
            try {
                this.internalClose();
            }
            finally {
                this.closed = true;
                this.onClosed();
            }
        }
    }

    protected void onClosed() {
    }

    private void register(TrackingResourceIterator<?> iterator) {
        if (this.trackedIteratorsInUse.cardinality() == this.trackedIterators.length) {
            this.trackedIterators = Arrays.copyOf(this.trackedIterators, this.trackedIterators.length << 1);
        }
        int freeIndex = this.trackedIteratorsInUse.nextClearBit(0);
        this.trackedIterators[freeIndex] = iterator;
        this.trackedIteratorsInUse.set(freeIndex);
    }

    private void unregister(TrackingResourceIterator<?> iterator) {
        int lastSetBit = this.trackedIteratorsInUse.previousSetBit(this.trackedIterators.length);
        for (int i = 0; i <= lastSetBit; ++i) {
            if (this.trackedIterators[i] != iterator) continue;
            this.trackedIterators[i] = null;
            this.trackedIteratorsInUse.clear(i);
            break;
        }
    }

    private void internalClose() {
        Throwable closeThrowable = null;
        int lastSetBit = this.trackedIteratorsInUse.previousSetBit(this.trackedIterators.length);
        for (int i = 0; i <= lastSetBit; ++i) {
            if (this.trackedIterators[i] == null) continue;
            try {
                this.trackedIterators[i].internalClose();
                continue;
            }
            catch (Exception e) {
                if (closeThrowable == null) {
                    closeThrowable = new ResourceIteratorCloseFailedException("Exception closing a resource iterator.", e);
                    continue;
                }
                closeThrowable.addSuppressed(e);
            }
        }
        this.trackedIterators = null;
        this.trackedIteratorsInUse = null;
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }

    private static final class TrackingResourceIterator<T>
    implements ResourceIterator<T> {
        private final ResourceIterator<T> delegate;
        private final Consumer<TrackingResourceIterator<?>> registerCallback;
        private final Consumer<TrackingResourceIterator<?>> unregisterCallback;
        private boolean closed;

        private TrackingResourceIterator(ResourceIterator<T> delegate, Consumer<TrackingResourceIterator<?>> registerCallback, Consumer<TrackingResourceIterator<?>> unregisterCallback) {
            this.delegate = delegate;
            this.registerCallback = registerCallback;
            this.unregisterCallback = unregisterCallback;
            registerCallback.accept(this);
        }

        public boolean hasNext() {
            boolean hasNext = this.delegate.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        public T next() {
            return (T)this.delegate.next();
        }

        public <R> ResourceIterator<R> map(Function<T, R> map) {
            return new TrackingResourceIterator<T>(super.map(map), this.registerCallback, this.unregisterCallback);
        }

        public void close() {
            if (!this.closed) {
                this.internalClose();
                this.unregisterCallback.accept(this);
            }
        }

        private void internalClose() {
            try {
                this.delegate.close();
            }
            finally {
                this.closed = true;
            }
        }
    }
}

