/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;

public class UuidUtil {
    public static String fromHexToBase64(String hexUuid) {
        UUID uuid = UUID.fromString(hexUuid);
        return UuidUtil.generateBase64Uuid(uuid);
    }

    public static String fromBase64ToHex(String base64Uuid) {
        Object valueForConversion;
        if (base64Uuid == null) {
            throw new NullPointerException();
        }
        if (base64Uuid.isBlank()) {
            throw new IllegalStateException("Expected not empty UUID value");
        }
        if (base64Uuid.endsWith("==")) {
            if (base64Uuid.length() != 24) {
                throw new IllegalStateException("Invalid UUID length. Expected 24 characters");
            }
            valueForConversion = base64Uuid;
        } else {
            if (base64Uuid.length() != 22) {
                throw new IllegalStateException("Invalid UUID length. Expected 22 characters");
            }
            valueForConversion = base64Uuid + "==";
        }
        byte[] buffer = Base64.getDecoder().decode((String)valueForConversion);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb <<= 8;
            msb |= (long)(buffer[i] & 0xFF);
        }
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb <<= 8;
            lsb |= (long)(buffer[i] & 0xFF);
        }
        UUID uuid = new UUID(msb, lsb);
        return uuid.toString();
    }

    public static String generateBase64Uuid(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        String encoded = Base64.getEncoder().encodeToString(bb.array());
        return encoded.substring(0, encoded.length() - 2);
    }
}

