/*
 * Decompiled with CFR 0.152.
 */
package apoc.es;

import apoc.Extended;
import apoc.load.LoadJsonUtils;
import apoc.result.MapResult;
import apoc.util.MapUtil;
import apoc.util.UrlResolver;
import apoc.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class ElasticSearch {
    private static final String fullQueryTemplate = "/%s/%s/%s?%s";
    private static final String fullQuerySearchTemplate = "/%s/%s/_search?%s";
    private static final Pattern KEY_VALUE = Pattern.compile("(.*)(:|=)(.*)");

    protected String getElasticSearchUrl(String hostOrKey) {
        return new UrlResolver("http", "localhost", 9200).getUrl("es", hostOrKey);
    }

    protected String getQueryUrl(String hostOrKey, String index, String type, String id, Object query) {
        return this.getElasticSearchUrl(hostOrKey) + this.formatQueryUrl(index, type, id, query);
    }

    protected String getSearchQueryUrl(String hostOrKey, String index, String type, Object query) {
        return this.getElasticSearchUrl(hostOrKey) + this.formatSearchQueryUrl(index, type, query);
    }

    private String formatSearchQueryUrl(String index, String type, Object query) {
        String queryUrl = String.format(fullQuerySearchTemplate, index == null ? "_all" : index, type == null ? "_all" : type, this.toQueryParams(query));
        return queryUrl.endsWith("?") ? queryUrl.substring(0, queryUrl.length() - 1) : queryUrl;
    }

    private String formatQueryUrl(String index, String type, String id, Object query) {
        String queryUrl = String.format(fullQueryTemplate, index == null ? "_all" : index, type == null ? "_all" : type, id == null ? "" : id, this.toQueryParams(query));
        return queryUrl.endsWith("?") ? queryUrl.substring(0, queryUrl.length() - 1) : queryUrl;
    }

    protected String toPayload(Object payload) {
        if (payload == null) {
            return null;
        }
        if (payload instanceof Map) {
            return Util.toJson((Object)payload);
        }
        return payload.toString();
    }

    private String contentType(Object payload) {
        return "application/json";
    }

    protected String toQueryParams(Object query) {
        if (query == null) {
            return "";
        }
        if (query instanceof Map) {
            Map map = (Map)query;
            if (map.isEmpty()) {
                return "";
            }
            return map.entrySet().stream().map(e -> (String)e.getKey() + "=" + Util.encodeUrlComponent((String)e.getValue().toString())).collect(Collectors.joining("&"));
        }
        return Pattern.compile("&").splitAsStream(query.toString()).map(KEY_VALUE::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1) + matcher.group(2) + Util.encodeUrlComponent((String)matcher.group(3))).collect(Collectors.joining("&"));
    }

    @Procedure
    @Description(value="apoc.es.stats(host-url-Key) - elastic search statistics")
    public Stream<MapResult> stats(@Name(value="host") String hostOrKey) {
        String url = this.getElasticSearchUrl(hostOrKey);
        return ElasticSearch.loadJsonStream(url + "/_stats", null, null);
    }

    @Procedure
    @Description(value="apoc.es.get(host-or-port,index-or-null,type-or-null,id-or-null,query-or-null,payload-or-null) yield value - perform a GET operation on elastic search")
    public Stream<MapResult> get(@Name(value="host") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="id") String id, @Name(value="query") Object query, @Name(value="payload") Object payload) {
        return ElasticSearch.loadJsonStream(this.getQueryUrl(hostOrKey, index, type, id, query), MapUtil.map((Object[])new Object[]{"content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.query(host-or-port,index-or-null,type-or-null,query-or-null,payload-or-null) yield value - perform a SEARCH operation on elastic search")
    public Stream<MapResult> query(@Name(value="host") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="query") Object query, @Name(value="payload") Object payload) {
        return ElasticSearch.loadJsonStream(this.getSearchQueryUrl(hostOrKey, index, type, query), MapUtil.map((Object[])new Object[]{"content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.getRaw(host-or-port,path,payload-or-null) yield value - perform a raw GET operation on elastic search")
    public Stream<MapResult> getRaw(@Name(value="host") String hostOrKey, @Name(value="path") String suffix, @Name(value="payload") Object payload) {
        String url = this.getElasticSearchUrl(hostOrKey);
        return ElasticSearch.loadJsonStream(url + "/" + suffix, MapUtil.map((Object[])new Object[]{"content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.postRaw(host-or-port,path,payload-or-null) yield value - perform a raw POST operation on elastic search")
    public Stream<MapResult> postRaw(@Name(value="host") String hostOrKey, @Name(value="path") String suffix, @Name(value="payload") Object payload) {
        String url = this.getElasticSearchUrl(hostOrKey);
        return ElasticSearch.loadJsonStream(url + "/" + suffix, MapUtil.map((Object[])new Object[]{"method", "POST", "content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.post(host-or-port,index-or-null,type-or-null,query-or-null,payload-or-null) yield value - perform a POST operation on elastic search")
    public Stream<MapResult> post(@Name(value="host") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="query") Object query, @Name(value="payload", defaultValue="{}") Map<String, Object> payload) {
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        return ElasticSearch.loadJsonStream(this.getQueryUrl(hostOrKey, index, type, null, query), MapUtil.map((Object[])new Object[]{"method", "POST", "content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    @Procedure
    @Description(value="apoc.es.put(host-or-port,index-or-null,type-or-null,id-or-null,query-or-null,payload-or-null) yield value - perform a PUT operation on elastic search")
    public Stream<MapResult> put(@Name(value="host") String hostOrKey, @Name(value="index") String index, @Name(value="type") String type, @Name(value="id") String id, @Name(value="query") Object query, @Name(value="payload", defaultValue="{}") Map<String, Object> payload) {
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        return ElasticSearch.loadJsonStream(this.getQueryUrl(hostOrKey, index, type, id, query), MapUtil.map((Object[])new Object[]{"method", "PUT", "content-type", this.contentType(payload)}), this.toPayload(payload));
    }

    private static Stream<MapResult> loadJsonStream(@Name(value="url") Object url, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload) {
        return LoadJsonUtils.loadJsonStream((Object)url, headers, (String)payload, (String)"", (boolean)true, null, null, null);
    }
}

