/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.Extended;
import apoc.mongodb.MongoDBUtils;
import apoc.mongodb.MongoDbConfig;
import apoc.result.MapResult;
import apoc.util.UrlResolver;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class MongoDB {
    @Context
    public Log log;

    private MongoDBUtils.Coll getColl(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        String url = this.getMongoDBUrl(hostOrKey);
        return MongoDBUtils.Coll.Factory.create(url, db, collection, compatibleValues, extractReferences, objectIdAsMap);
    }

    @Procedure(value="apoc.mongodb.get.byObjectId")
    @Description(value="apoc.mongodb.get.byObjectId(hostOrKey, db, collection, objectIdValue, config(default:{})) - get the document by Object id value")
    public Stream<MapResult> byObjectId(@Name(value="host") String hostOrKey, @Name(value="db") String db, @Name(value="collection") String collection, @Name(value="objectIdValue") String objectIdValue, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        MongoDbConfig conf = new MongoDbConfig(config);
        return this.executeMongoQuery(hostOrKey, db, collection, conf.isCompatibleValues(), conf.isExtractReferences(), conf.isObjectIdAsMap(), coll -> {
            Map<String, Object> result = coll.first(Map.of(conf.getIdFieldName(), new ObjectId(objectIdValue)));
            return result == null || result.isEmpty() ? Stream.empty() : Stream.of(new MapResult(result));
        }, e -> this.log.error("apoc.mongodb.get.byObjectId - hostOrKey = [" + hostOrKey + "], db = [" + db + "], collection = [" + collection + "], objectIdValue = [" + objectIdValue + "]", (Throwable)e));
    }

    private String getMongoDBUrl(String hostOrKey) {
        return new UrlResolver("mongodb", "localhost", 27017).getUrl("mongodb", hostOrKey);
    }

    private <T> Stream<T> executeMongoQuery(String hostOrKey, String db, String collection, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap, Function<MongoDBUtils.Coll, Stream<T>> execute, Consumer<Exception> onError) {
        MongoDBUtils.Coll coll = null;
        try {
            coll = MongoDBUtils.getMongoColl(() -> this.getColl(hostOrKey, db, collection, compatibleValues, extractReferences, objectIdAsMap));
            return (Stream)execute.apply(coll).onClose(coll::safeClose);
        }
        catch (Exception e) {
            if (coll != null) {
                coll.safeClose();
            }
            onError.accept(e);
            throw new RuntimeException(e);
        }
    }
}

