/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.netpreserve.jwarc.ChunkedBody;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpParser;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public class HttpResponse
extends HttpMessage {
    private final int status;
    private final String reason;

    HttpResponse(int status, String reason, MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
        this.status = status;
        this.reason = reason;
    }

    @Override
    void serializeHeaderTo(Appendable output) throws IOException {
        output.append(this.version().toString());
        output.append(' ');
        output.append(Integer.toString(this.status));
        output.append(' ');
        output.append(this.reason);
        output.append("\r\n");
        this.headers().appendTo(output);
        output.append("\r\n");
    }

    public static HttpResponse parse(ReadableByteChannel channel) throws IOException {
        return HttpResponse.parse(channel, null);
    }

    public static HttpResponse parseStrictly(ReadableByteChannel channel) throws IOException {
        return HttpResponse.parse(channel, null, true, false);
    }

    static HttpResponse parse(ReadableByteChannel channel, WritableByteChannel copyTo) throws IOException {
        return HttpResponse.parse(channel, copyTo, false, false);
    }

    static HttpResponse parseWithoutBody(ReadableByteChannel channel, WritableByteChannel copyTo) throws IOException {
        return HttpResponse.parse(channel, copyTo, false, true);
    }

    private static HttpResponse parse(ReadableByteChannel channel, WritableByteChannel copyTo, boolean strict, boolean withoutBody) throws IOException {
        MessageBody body;
        ByteArrayOutputStream headerBuffer = new ByteArrayOutputStream();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.flip();
        HttpParser parser = new HttpParser();
        if (strict) {
            parser.strictResponse();
        } else {
            parser.lenientResponse();
        }
        parser.parse(channel, buffer, Channels.newChannel(headerBuffer));
        byte[] headerBytes = headerBuffer.toByteArray();
        if (copyTo != null) {
            copyTo.write(ByteBuffer.wrap(headerBytes));
            copyTo.write(buffer.duplicate());
        }
        MessageHeaders headers = parser.headers();
        if (withoutBody) {
            body = MessageBody.empty();
        } else if (headers.contains("Transfer-Encoding", "chunked")) {
            ChunkedBody chunkedBody = new ChunkedBody(channel, buffer);
            if (strict) {
                chunkedBody.strict();
            }
            body = chunkedBody;
        } else {
            body = LengthedBody.createFromContentLength(channel, buffer, headers.first("Content-Length").map(Long::parseLong).orElse(null));
        }
        HttpResponse response = new HttpResponse(parser.status(), parser.reason(), parser.version(), headers, body);
        response.serializedHeader = headerBytes;
        return response;
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public static class Builder
    extends HttpMessage.AbstractBuilder<HttpResponse, Builder> {
        private final int status;
        private final String reasonPhrase;

        public Builder(int status, String reasonPhrase) {
            this.status = status;
            this.reasonPhrase = reasonPhrase;
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this.status, this.reasonPhrase, this.version, new MessageHeaders(this.headerMap), this.makeBody());
        }
    }
}

