/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DartClientCodegen.class);
    public static final String BROWSER_CLIENT = "browserClient";
    public static final String PUB_NAME = "pubName";
    public static final String PUB_VERSION = "pubVersion";
    public static final String PUB_DESCRIPTION = "pubDescription";
    public static final String PUB_AUTHOR = "pubAuthor";
    public static final String PUB_AUTHOR_EMAIL = "pubAuthorEmail";
    public static final String PUB_HOMEPAGE = "pubHomepage";
    public static final String USE_ENUM_EXTENSION = "useEnumExtension";
    public static final String SUPPORT_DART2 = "supportDart2";
    protected boolean browserClient = true;
    protected String pubName = "openapi";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "OpenAPI API client";
    protected String pubAuthor = "Author";
    protected String pubAuthorEmail = "author@homepage";
    protected String pubHomepage = "homepage";
    protected boolean useEnumExtension = false;
    protected String sourceFolder = "";
    protected String apiDocPath = "doc" + File.separator;
    protected String modelDocPath = "doc" + File.separator;
    protected String apiTestPath = "test" + File.separator;
    protected String modelTestPath = "test" + File.separator;

    public DartClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.importMapping.clear();
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.templateDir = "dart2";
        this.embeddedTemplateDir = "dart2";
        this.apiPackage = "lib.api";
        this.modelPackage = "lib.model";
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelTestTemplateFiles.put("model_test.mustache", ".dart");
        this.apiTestTemplateFiles.put("api_test.mustache", ".dart");
        ArrayList<String> reservedWordsList = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(DartClientCodegen.class.getResourceAsStream("/dart/dart-keywords.txt"), Charset.forName("UTF-8")));
            while (reader.ready()) {
                reservedWordsList.add(reader.readLine());
            }
            reader.close();
        }
        catch (Exception e) {
            LOGGER.error("Error reading dart keywords. Exception: {}", (Object)e.getMessage());
        }
        this.setReservedWordsLowerCase(reservedWordsList);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "bool", "int", "num", "double"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("number", "num");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("File", "MultipartFile");
        this.typeMapping.put("binary", "MultipartFile");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("ByteArray", "String");
        this.cliOptions.add(new CliOption(BROWSER_CLIENT, "Is the client browser based (for Dart 1.x only)"));
        this.cliOptions.add(new CliOption(PUB_NAME, "Name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_VERSION, "Version in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_DESCRIPTION, "Description in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_AUTHOR, "Author name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_AUTHOR_EMAIL, "Email address of the author in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_HOMEPAGE, "Homepage in generated pubspec"));
        this.cliOptions.add(new CliOption(USE_ENUM_EXTENSION, "Allow the 'x-enum-values' extension for enums"));
        this.cliOptions.add(new CliOption("sourceFolder", "Source folder for generated code"));
        this.cliOptions.add(CliOption.newBoolean(SUPPORT_DART2, "Support Dart 2.x (Dart 1.x support has been deprecated)").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "dart";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart (1.x (deprecated) or 2.x) client library.";
    }

    protected void defaultProcessOpts() {
        super.processOpts();
    }

    @Override
    public void processOpts() {
        this.defaultProcessOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(BROWSER_CLIENT)) {
            this.setBrowserClient(this.convertPropertyToBooleanAndWriteBack(BROWSER_CLIENT));
        } else {
            this.additionalProperties.put(BROWSER_CLIENT, this.browserClient);
        }
        if (this.additionalProperties.containsKey(PUB_NAME)) {
            this.setPubName((String)this.additionalProperties.get(PUB_NAME));
        } else {
            this.additionalProperties.put(PUB_NAME, this.pubName);
        }
        if (this.additionalProperties.containsKey(PUB_VERSION)) {
            this.setPubVersion((String)this.additionalProperties.get(PUB_VERSION));
        } else {
            this.additionalProperties.put(PUB_VERSION, this.pubVersion);
        }
        if (this.additionalProperties.containsKey(PUB_DESCRIPTION)) {
            this.setPubDescription((String)this.additionalProperties.get(PUB_DESCRIPTION));
        } else {
            this.additionalProperties.put(PUB_DESCRIPTION, this.pubDescription);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR)) {
            this.setPubAuthor((String)this.additionalProperties.get(PUB_AUTHOR));
        } else {
            this.additionalProperties.put(PUB_AUTHOR, this.pubAuthor);
        }
        if (this.additionalProperties.containsKey(PUB_AUTHOR_EMAIL)) {
            this.setPubAuthorEmail((String)this.additionalProperties.get(PUB_AUTHOR_EMAIL));
        } else {
            this.additionalProperties.put(PUB_AUTHOR_EMAIL, this.pubAuthorEmail);
        }
        if (this.additionalProperties.containsKey(PUB_HOMEPAGE)) {
            this.setPubHomepage((String)this.additionalProperties.get(PUB_HOMEPAGE));
        } else {
            this.additionalProperties.put(PUB_HOMEPAGE, this.pubHomepage);
        }
        if (this.additionalProperties.containsKey(USE_ENUM_EXTENSION)) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack(USE_ENUM_EXTENSION));
        } else {
            this.additionalProperties.put(USE_ENUM_EXTENSION, this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        Object isSupportDart2 = this.additionalProperties.get(SUPPORT_DART2);
        if (Boolean.FALSE.equals(isSupportDart2) || isSupportDart2 instanceof String && !Boolean.parseBoolean((String)isSupportDart2)) {
            LOGGER.info("Dart version: 1.x");
            this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", ".analysis_options"));
        } else {
            LOGGER.info("Dart version: 2.x");
            if (this.templateDir == null) {
                this.templateDir = "dart2";
                this.embeddedTemplateDir = "dart2";
            }
        }
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", libFolder, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("api_exception.mustache", libFolder, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("api_helper.mustache", libFolder, "api_helper.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_bearer_auth.mustache", authFolder, "http_bearer_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.apiTestPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.modelTestPath.replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath.replace('/', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if ((name = StringUtils.camelize(name, true)).matches("^\\d.*")) {
            name = "n" + name;
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (this.typeMapping.containsValue(name)) {
            return StringUtils.camelize(name);
        }
        return StringUtils.camelize(this.modelNamePrefix + "_" + name + "_" + this.modelNameSuffix);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelDocFilename(String name) {
        return super.toModelDocFilename(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_test";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_test";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            return "{}";
        }
        if (ModelUtils.isArraySchema(schema)) {
            return "[]";
        }
        if (schema.getDefault() != null) {
            if (ModelUtils.isStringSchema(schema)) {
                return "\"" + schema.getDefault().toString().replaceAll("\"", "\\\"") + "\"";
            }
            return schema.getDefault().toString();
        }
        return "null";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean succes = this.buildEnumFromVendorExtension(cm) || this.buildEnumFromValues(cm);
            for (CodegenProperty var : cm.vars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    private boolean buildEnumFromValues(CodegenModel cm) {
        if (!cm.isEnum || cm.allowableValues == null) {
            return false;
        }
        Map<String, Object> allowableValues = cm.allowableValues;
        List values = (List)allowableValues.get("values");
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, cm.dataType);
        cm.allowableValues.put("enumVars", enumVars);
        return true;
    }

    private boolean buildEnumFromVendorExtension(CodegenModel cm) {
        if (!(cm.isEnum && cm.allowableValues != null && this.useEnumExtension && cm.vendorExtensions.containsKey("x-enum-values"))) {
            return false;
        }
        Object extension = cm.vendorExtensions.get("x-enum-values");
        List values = (List)extension;
        ArrayList enumVars = new ArrayList();
        for (Map value : values) {
            HashMap<String, String> enumVar = new HashMap<String, String>();
            String name = StringUtils.camelize((String)value.get("identifier"), true);
            if (this.isReservedWord(name)) {
                name = this.escapeReservedWord(name);
            }
            enumVar.put("name", name);
            enumVar.put("value", this.toEnumValue(value.get("numericValue").toString(), cm.dataType));
            if (value.containsKey("description")) {
                enumVar.put("description", value.get("description").toString());
            }
            enumVars.add(enumVar);
        }
        cm.allowableValues.put("enumVars", enumVars);
        return true;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        String var = value.replaceAll("\\W+", "_");
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            var = "Number" + var;
        }
        return this.escapeReservedWord(StringUtils.camelize(var, true));
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return StringUtils.camelize(operationId, true);
    }

    public void setBrowserClient(boolean browserClient) {
        this.browserClient = browserClient;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setPubAuthor(String pubAuthor) {
        this.pubAuthor = pubAuthor;
    }

    public void setPubAuthorEmail(String pubAuthorEmail) {
        this.pubAuthorEmail = pubAuthorEmail;
    }

    public void setPubHomepage(String pubHomepage) {
        this.pubHomepage = pubHomepage;
    }

    public void setUseEnumExtension(boolean useEnumExtension) {
        this.useEnumExtension = useEnumExtension;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String dartPostProcessFile = System.getenv("DART_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dartPostProcessFile)) {
            return;
        }
        HashSet<String> supportedFileType = new HashSet<String>(Arrays.asList("supporting-mustache", "model-test", "model", "api-test", "api"));
        if (!supportedFileType.contains(fileType)) {
            return;
        }
        if ("dart".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = dartPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

