/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.utils.OnceLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfImplementorAdditionalData {
    private String implementorName;
    private List<String> additionalInterfaces = new ArrayList<String>();
    private List<CodegenProperty> additionalProps = new ArrayList<CodegenProperty>();
    private List<Map<String, String>> additionalImports = new ArrayList<Map<String, String>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(OneOfImplementorAdditionalData.class);

    public OneOfImplementorAdditionalData(String implementorName) {
        this.implementorName = implementorName;
    }

    public String getImplementorName() {
        return this.implementorName;
    }

    public void addFromInterfaceModel(CodegenModel cm, List<Map<String, String>> modelsImports) {
        this.additionalInterfaces.add(cm.classname);
        ArrayList<CodegenProperty> toAdd = new ArrayList<CodegenProperty>(cm.vars);
        ArrayList<String> omitAdding = new ArrayList<String>();
        for (CodegenModel codegenModel : cm.interfaceModels) {
            for (CodegenProperty v : codegenModel.vars) {
                omitAdding.add(v.baseName);
            }
        }
        for (CodegenProperty codegenProperty : toAdd) {
            if (omitAdding.contains(codegenProperty.baseName)) continue;
            this.additionalProps.add(codegenProperty.clone());
        }
        for (Map map : modelsImports) {
            this.additionalImports.add(new HashMap(map));
        }
    }

    public void addToImplementor(CodegenConfig cc, CodegenModel implcm, List<Map<String, String>> implImports, boolean addInterfaceImports) {
        OnceLogger.once(LOGGER).warn("4.3.0 has deprecated the use of vendor extensions which don't follow lower-kebab casing standards with x- prefix.");
        implcm.getVendorExtensions().putIfAbsent("implements", new ArrayList());
        implcm.getVendorExtensions().putIfAbsent("x-implements", implcm.getVendorExtensions().get("implements"));
        for (String intf : this.additionalInterfaces) {
            List impl = (List)implcm.getVendorExtensions().get("implements");
            impl.add(intf);
            if (!addInterfaceImports) continue;
            implcm.imports.add(intf);
            HashMap<String, String> importsItem = new HashMap<String, String>();
            importsItem.put("import", cc.toModelImport(intf));
            implImports.add(importsItem);
        }
        if (implcm.vars.size() > 0 && this.additionalProps.size() > 0) {
            implcm.vars.get((int)(implcm.vars.size() - 1)).hasMore = true;
        }
        for (int i = 0; i < this.additionalProps.size(); ++i) {
            CodegenProperty var = this.additionalProps.get(i);
            var.hasMore = i != this.additionalProps.size() - 1;
            implcm.vars.add(var);
        }
        for (Map<String, String> oneImport : this.additionalImports) {
            if (implImports.contains(oneImport) || oneImport.getOrDefault("import", "").startsWith(cc.modelPackage())) continue;
            implImports.add(oneImport);
        }
    }

    public String toString() {
        return "OneOfImplementorAdditionalData{implementorName='" + this.implementorName + '\'' + ", additionalInterfaces=" + this.additionalInterfaces + ", additionalProps=" + this.additionalProps + ", additionalImports=" + this.additionalImports + '}';
    }
}

