/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;

public class ProcessUtils {
    public static void addIndexToProperties(List<Object> models, int initialIndex) {
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            int i = initialIndex;
            for (CodegenProperty var : cm.vars) {
                var.vendorExtensions.put("x-index", i);
                ++i;
            }
            int j = initialIndex;
            for (CodegenProperty var : cm.allVars) {
                var.vendorExtensions.put("x-index", j);
                ++j;
            }
        }
    }

    public static void addIndexToProperties(List<Object> models) {
        ProcessUtils.addIndexToProperties(models, 0);
    }

    public static boolean hasHttpBasicMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isBasicBasic)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasApiKeyMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isApiKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpSignatureMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isHttpSignature)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpBearerMethods(List<CodegenSecurity> authMethods) {
        if (authMethods != null && !authMethods.isEmpty()) {
            for (CodegenSecurity cs : authMethods) {
                if (!Boolean.TRUE.equals(cs.isBasicBearer)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasOAuthMethods(List<CodegenSecurity> authMethods) {
        for (CodegenSecurity cs : authMethods) {
            if (!Boolean.TRUE.equals(cs.isOAuth)) continue;
            return true;
        }
        return false;
    }

    public static List<CodegenSecurity> getOAuthMethods(List<CodegenSecurity> authMethods) {
        ArrayList<CodegenSecurity> oauthMethods = new ArrayList<CodegenSecurity>();
        for (CodegenSecurity cs : authMethods) {
            if (!Boolean.TRUE.equals(cs.isOAuth)) continue;
            oauthMethods.add(cs);
        }
        return oauthMethods;
    }

    public static boolean hasOAuthMethods(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes = ProcessUtils.getSecuritySchemes(openAPI);
        if (securitySchemes != null) {
            for (Map.Entry<String, SecurityScheme> scheme : securitySchemes.entrySet()) {
                if (!SecurityScheme.Type.OAUTH2.equals((Object)scheme.getValue().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpBearerMethods(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes = ProcessUtils.getSecuritySchemes(openAPI);
        if (securitySchemes != null) {
            for (Map.Entry<String, SecurityScheme> scheme : securitySchemes.entrySet()) {
                if (!SecurityScheme.Type.HTTP.equals((Object)scheme.getValue().getType()) || !"bearer".equals(scheme.getValue().getScheme())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpBasicMethods(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes = ProcessUtils.getSecuritySchemes(openAPI);
        if (securitySchemes != null) {
            for (Map.Entry<String, SecurityScheme> scheme : securitySchemes.entrySet()) {
                if (!SecurityScheme.Type.HTTP.equals((Object)scheme.getValue().getType()) || !"basic".equals(scheme.getValue().getScheme())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasHttpSignatureMethods(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes = ProcessUtils.getSecuritySchemes(openAPI);
        if (securitySchemes != null) {
            for (Map.Entry<String, SecurityScheme> scheme : securitySchemes.entrySet()) {
                if (!SecurityScheme.Type.HTTP.equals((Object)scheme.getValue().getType()) || !"signature".equals(scheme.getValue().getScheme())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasApiKeyMethods(OpenAPI openAPI) {
        Map<String, SecurityScheme> securitySchemes = ProcessUtils.getSecuritySchemes(openAPI);
        if (securitySchemes != null) {
            for (Map.Entry<String, SecurityScheme> scheme : securitySchemes.entrySet()) {
                if (!SecurityScheme.Type.APIKEY.equals((Object)scheme.getValue().getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, SecurityScheme> getSecuritySchemes(OpenAPI openAPI) {
        if (openAPI == null) {
            return null;
        }
        return openAPI.getComponents() != null ? openAPI.getComponents().getSecuritySchemes() : null;
    }
}

