/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.api.TemplatingExecutor;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.openapitools.codegen.templating.TemplateNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager
implements TemplatingExecutor,
TemplateProcessor {
    private final TemplateManagerOptions options;
    private final TemplatingEngineAdapter engineAdapter;
    private final TemplatePathLocator[] templateLoaders;
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateManager.class);

    public TemplateManager(TemplateManagerOptions options, TemplatingEngineAdapter engineAdapter, TemplatePathLocator[] templateLoaders) {
        this.options = options;
        this.engineAdapter = engineAdapter;
        this.templateLoaders = templateLoaders;
    }

    private String getFullTemplateFile(String name) {
        String template = Arrays.stream(this.templateLoaders).map(i -> i.getFullTemplatePath(name)).filter(Objects::nonNull).findFirst().orElse("");
        if (StringUtils.isEmpty((CharSequence)template)) {
            throw new TemplateNotFoundException(name);
        }
        if (name == null || name.contains("..")) {
            throw new IllegalArgumentException("Template location must be constrained to template directory.");
        }
        return template;
    }

    public String getFullTemplateContents(String name) {
        return this.readTemplate(this.getFullTemplateFile(name));
    }

    public Path getFullTemplatePath(String name) {
        return Paths.get(this.getFullTemplateFile(name), new String[0]);
    }

    public static String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }

    /*
     * Exception decompiling
     */
    public String readTemplate(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = this.getInputStream(name);
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    private InputStream getInputStream(String name) throws FileNotFoundException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(TemplateManager.getCPResourcePath(name));
        if (is == null) {
            if (name == null || name.contains("..")) {
                throw new IllegalArgumentException("Template location must be constrained to template directory.");
            }
            is = new FileInputStream(name);
        }
        return is;
    }

    public File write(Map<String, Object> data, String template, File target) throws IOException {
        InputStream is;
        if (this.engineAdapter.handlesFile(template)) {
            String templateContent = this.engineAdapter.compileTemplate((TemplatingExecutor)this, data, template);
            return this.writeToFile(target.getPath(), templateContent);
        }
        try {
            String fullTemplatePath = this.getFullTemplateFile(template);
            is = this.getInputStream(fullTemplatePath);
        }
        catch (TemplateNotFoundException ex) {
            is = new FileInputStream(Paths.get(template, new String[0]).toFile());
        }
        return this.writeToFile(target.getAbsolutePath(), IOUtils.toByteArray((InputStream)is));
    }

    public void ignore(Path path, String context) {
        LOGGER.info("Ignored {} ({})", (Object)path, (Object)context);
    }

    public void skip(Path path, String context) {
        LOGGER.info("Skipped {} ({})", (Object)path, (Object)context);
    }

    public File writeToFile(String filename, String contents) throws IOException {
        return this.writeToFile(filename, contents.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToFile(String filename, byte[] contents) throws IOException {
        File outputFile = Paths.get(filename, new String[0]).toFile();
        if (this.options.isMinimalUpdate()) {
            String tempFilename = filename + ".tmp";
            File tempFile = null;
            try {
                tempFile = this.writeToFileRaw(tempFilename, contents);
                if (!this.filesEqual(tempFile, outputFile)) {
                    LOGGER.info("writing file {}", (Object)filename);
                    Files.move(tempFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    tempFile = null;
                }
                LOGGER.info("skipping unchanged file {}", (Object)filename);
            }
            finally {
                if (tempFile != null && tempFile.exists()) {
                    try {
                        Files.delete(tempFile.toPath());
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error removing temporary file {}", (Object)tempFile, (Object)ex);
                    }
                }
            }
        } else {
            LOGGER.info("writing file {}", (Object)filename);
            outputFile = this.writeToFileRaw(filename, contents);
        }
        return outputFile;
    }

    private File writeToFileRaw(String filename, byte[] contents) throws IOException {
        File output = Paths.get(filename, new String[0]).toFile();
        if (this.options.isSkipOverwrite() && output.exists()) {
            LOGGER.info("skip overwrite of file {}", (Object)filename);
            return output;
        }
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = Paths.get(output.getParent(), new String[0]).toFile();
            parent.mkdirs();
        }
        Files.write(output.toPath(), contents, new OpenOption[0]);
        return output;
    }

    private boolean filesEqual(File file1, File file2) throws IOException {
        return file1.exists() && file2.exists() && Arrays.equals(Files.readAllBytes(file1.toPath()), Files.readAllBytes(file2.toPath()));
    }
}

