/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppPistacheServerCodegen
extends AbstractCppCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppPistacheServerCodegen.class);
    protected String implFolder = "impl";
    protected boolean isAddExternalLibs = true;
    protected boolean isUseStructModel = false;
    public static final String OPTIONAL_EXTERNAL_LIB = "addExternalLibs";
    public static final String OPTIONAL_EXTERNAL_LIB_DESC = "Add the Possibility to fetch and compile external Libraries needed by this Framework.";
    public static final String OPTION_USE_STRUCT_MODEL = "useStructModel";
    public static final String OPTION_USE_STRUCT_MODEL_DESC = "Use struct-based model template instead of get/set-based model template";
    public static final String HELPERS_PACKAGE_NAME = "helpersPackage";
    public static final String HELPERS_PACKAGE_NAME_DESC = "Specify the package name to be used for the helpers (e.g. org.openapitools.server.helpers).";
    protected final String PREFIX = "";
    protected String helpersPackage = "";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "cpp-pistache-server";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API server (based on Pistache)";
    }

    public CppPistacheServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            this.modelNamePrefix = "";
        }
        this.helpersPackage = "org.openapitools.server.helpers";
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-impl-header.mustache", ".h");
        this.apiTemplateFiles.put("api-impl-source.mustache", ".cpp");
        this.templateDir = "cpp-pistache-server";
        this.embeddedTemplateDir = "cpp-pistache-server";
        this.cliOptions.clear();
        this.addSwitch(OPTIONAL_EXTERNAL_LIB, OPTIONAL_EXTERNAL_LIB_DESC, this.isAddExternalLibs);
        this.addOption(HELPERS_PACKAGE_NAME, HELPERS_PACKAGE_NAME_DESC, this.helpersPackage);
        this.addOption("reservedWordPrefix", "Prefix to prepend to reserved words in order to avoid conflicts", this.reservedWordPrefix);
        this.addSwitch(OPTION_USE_STRUCT_MODEL, OPTION_USE_STRUCT_MODEL_DESC, this.isUseStructModel);
        this.addOption("variableNameFirstCharacterUppercase", "Make first character of variable name uppercase (eg. value -> Value)", Boolean.toString(this.variableNameFirstCharacterUppercase));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", "model", this.modelNamePrefix + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-source.mustache", "model", this.modelNamePrefix + "Helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("main-api-server.mustache", "", this.modelNamePrefix + "main-api-server.cpp"));
        this.supportingFiles.add(new SupportingFile("cmake.mustache", "", "CMakeLists.txt"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "std::string");
        this.typeMapping.put("DateTime", "std::string");
        this.typeMapping.put("string", "std::string");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "std::string");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "std::string");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("UUID", "std::string");
        this.typeMapping.put("URI", "std::string");
        this.typeMapping.put("ByteArray", "std::string");
        this.importMapping = new HashMap();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("Object", "#include \"Object.h\"");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(HELPERS_PACKAGE_NAME)) {
            this.helpersPackage = (String)this.additionalProperties.get(HELPERS_PACKAGE_NAME);
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.additionalProperties().put("prefix", this.modelNamePrefix);
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", "model", this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-source.mustache", "model", this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("main-api-server.mustache", "", this.modelNamePrefix + "main-api-server.cpp"));
            this.supportingFiles.add(new SupportingFile("cmake.mustache", "", "CMakeLists.txt"));
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        }
        if (this.additionalProperties.containsKey("reservedWordPrefix")) {
            this.reservedWordPrefix = (String)this.additionalProperties.get("reservedWordPrefix");
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("helpersNamespaceDeclarations", this.helpersPackage.split("\\."));
        this.additionalProperties.put("helpersNamespace", this.helpersPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("reservedWordPrefix", this.reservedWordPrefix);
        if (this.additionalProperties.containsKey(OPTIONAL_EXTERNAL_LIB)) {
            this.setAddExternalLibs(this.convertPropertyToBooleanAndWriteBack(OPTIONAL_EXTERNAL_LIB));
        } else {
            this.additionalProperties.put(OPTIONAL_EXTERNAL_LIB, this.isAddExternalLibs);
        }
        this.setupModelTemplate();
    }

    private void setupModelTemplate() {
        if (this.additionalProperties.containsKey(OPTION_USE_STRUCT_MODEL)) {
            this.isUseStructModel = this.convertPropertyToBooleanAndWriteBack(OPTION_USE_STRUCT_MODEL);
        }
        if (this.isUseStructModel) {
            LOGGER.info("Using struct-based model template");
            this.modelTemplateFiles.put("model-struct-header.mustache", ".h");
            this.modelTemplateFiles.put("model-struct-source.mustache", ".cpp");
        } else {
            LOGGER.info("Using get/set-based model template");
            this.modelTemplateFiles.put("model-header.mustache", ".h");
            this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        }
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        Schema response;
        ApiResponse apiResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (apiResponse = this.findMethodResponse(operation.getResponses())) != null && (response = ModelUtils.getSchemaFromResponse(apiResponse)) != null) {
            CodegenProperty cm = this.fromProperty("response", response);
            op.vendorExtensions.put("x-codegen-response", cm);
            if ("HttpContent".equals(cm.dataType)) {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        String pathForPistache = path.replaceAll("\\{(.*?)}", ":$1");
        op.vendorExtensions.put("x-codegen-pistache-path", pathForPistache);
        return op;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        String classname = (String)operations.get("classname");
        operations.put("classnameSnakeUpperCase", StringUtils.underscore(classname).toUpperCase(Locale.ROOT));
        operations.put("classnameSnakeLowerCase", StringUtils.underscore(classname).toLowerCase(Locale.ROOT));
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            boolean consumeJson = false;
            boolean isParsingSupported = true;
            if (op.bodyParam != null) {
                if (op.bodyParam.vendorExtensions == null) {
                    op.bodyParam.vendorExtensions = new HashMap<String, Object>();
                }
                boolean isStringOrDate = op.bodyParam.isString || op.bodyParam.isDate;
                op.bodyParam.vendorExtensions.put("x-codegen-pistache-is-string-or-date", isStringOrDate);
            }
            if (op.consumes != null) {
                for (Map<String, String> consume : op.consumes) {
                    if (consume.get("mediaType") == null || !consume.get("mediaType").equals("application/json")) continue;
                    consumeJson = true;
                }
            }
            op.httpMethod = op.httpMethod.substring(0, 1).toUpperCase(Locale.ROOT) + op.httpMethod.substring(1).toLowerCase(Locale.ROOT);
            for (CodegenParameter param : op.allParams) {
                if (param.isFormParam) {
                    isParsingSupported = false;
                }
                if (param.isFile) {
                    isParsingSupported = false;
                }
                if (param.isCookieParam) {
                    isParsingSupported = false;
                }
                if (param.isHeaderParam) {
                    param.dataType = "Pistache::Optional<Pistache::Http::Header::Raw>";
                    param.baseType = "Pistache::Optional<Pistache::Http::Header::Raw>";
                    continue;
                }
                if (!param.isQueryParam) continue;
                if (param.isPrimitiveType) {
                    param.dataType = "Pistache::Optional<" + param.dataType + ">";
                    continue;
                }
                param.dataType = "Pistache::Optional<" + param.dataType + ">";
                param.baseType = "Pistache::Optional<" + param.baseType + ">";
            }
            if (op.vendorExtensions == null) {
                op.vendorExtensions = new HashMap<String, Object>();
            }
            op.vendorExtensions.put("x-codegen-pistache-consumes-json", consumeJson);
            op.vendorExtensions.put("x-codegen-pistache-is-parsing-supported", isParsingSupported);
            for (String hdr : op.imports) {
                if (this.importMapping.containsKey(hdr)) continue;
                operations.put("hasModelImport", true);
            }
        }
        return objs;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("impl-header.mustache")) {
            int ix = result.lastIndexOf(File.separatorChar);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 2) + "Impl.h";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        } else if (templateName.endsWith("impl-source.mustache")) {
            int ix = result.lastIndexOf(File.separatorChar);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 4) + "Impl.cpp";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        }
        return result;
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<std::string, " + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            return "std::string";
        }
        if (ModelUtils.isStringSchema(p) || ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isFileSchema(p) || this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "\"\"";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "\"\"";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (ModelUtils.isFloatSchema(p)) {
                return "0.0f";
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (ModelUtils.isLongSchema(p)) {
                return "0L";
            }
            return "0";
        }
        if (ModelUtils.isByteArraySchema(p)) {
            return "\"\"";
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(this.getAdditionalProperties(p));
            return "std::map<std::string, " + inner + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "std::vector<" + inner + ">()";
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "\"\"";
        }
        return "";
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/model").replace("/", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/api").replace("/", File.separator);
    }

    private String implFileFolder() {
        return (this.outputFolder + "/" + this.implFolder).replace("/", File.separator);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return this.toModelName(str);
    }

    public void setAddExternalLibs(boolean value) {
        this.isAddExternalLibs = value;
    }
}

