/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openapitools.codegen.config.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.ext.LoggerWrapper;

public class OnceLogger
extends LoggerWrapper {
    static final String CACHE_SIZE_PROPERTY = "org.openapitools.codegen.utils.oncelogger.cachesize";
    static final String ENABLE_ONCE_LOGGER_PROPERTY = "org.openapitools.codegen.utils.oncelogger.enabled";
    static final String EXPIRY_PROPERTY = "org.openapitools.codegen.utils.oncelogger.expiry";
    static Cache<String, AtomicInteger> messageCountCache;
    private static final String FQCN;
    private static final Marker MARKER;
    private static int maxCacheSize;
    private static int expireMillis;
    private static int maxRepetitions;

    OnceLogger(Logger logger) {
        this(logger, FQCN);
    }

    OnceLogger(Logger logger, String fqcn) {
        super(logger, fqcn);
    }

    static void caffeineCache(Ticker ticker, int expireMillis) {
        messageCountCache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)expireMillis, TimeUnit.MILLISECONDS).ticker(ticker).build();
    }

    public static Logger once(Logger logger) {
        try {
            if (Boolean.parseBoolean(GlobalSettings.getProperty(ENABLE_ONCE_LOGGER_PROPERTY, "true"))) {
                return new OnceLogger(logger);
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to wrap logger instance in OnceLogger. Falling back to non-decorated implementation, which may be noisy.");
        }
        return logger;
    }

    public void trace(String msg) {
        if (!this.isTraceEnabled() || !this.isTraceEnabled(MARKER)) {
            return;
        }
        if (this.shouldLog(msg)) {
            super.trace(MARKER, msg);
        }
    }

    private boolean shouldLog(String msg) {
        AtomicInteger counter = (AtomicInteger)messageCountCache.get((Object)msg, i -> new AtomicInteger(0));
        return counter.incrementAndGet() <= maxRepetitions;
    }

    public void debug(String msg) {
        if (!this.isDebugEnabled() || !this.isDebugEnabled(MARKER)) {
            return;
        }
        if (this.shouldLog(msg)) {
            super.debug(MARKER, msg);
        }
    }

    public void info(String msg) {
        if (!this.isInfoEnabled() || !this.isInfoEnabled(MARKER)) {
            return;
        }
        if (this.shouldLog(msg)) {
            super.info(MARKER, msg);
        }
    }

    public void warn(String msg) {
        if (!this.isWarnEnabled() || !this.isWarnEnabled(MARKER)) {
            return;
        }
        if (this.shouldLog(msg)) {
            super.warn(MARKER, msg);
        }
    }

    public void error(String msg) {
        if (!this.isErrorEnabled() || !this.isErrorEnabled(MARKER)) {
            return;
        }
        if (this.shouldLog(msg)) {
            super.error(MARKER, msg);
        }
    }

    static {
        FQCN = OnceLogger.class.getName();
        MARKER = MarkerFactory.getMarker((String)"ONCE");
        maxCacheSize = Integer.parseInt(GlobalSettings.getProperty(CACHE_SIZE_PROPERTY, "200"));
        expireMillis = Integer.parseInt(GlobalSettings.getProperty(EXPIRY_PROPERTY, "2000"));
        maxRepetitions = 1;
        OnceLogger.caffeineCache(Ticker.systemTicker(), expireMillis);
    }
}

