/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractDartCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartDioClientCodegen
extends AbstractDartCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(DartDioClientCodegen.class);
    public static final String NULLABLE_FIELDS = "nullableFields";
    public static final String DATE_LIBRARY = "dateLibrary";
    private static final String CLIENT_NAME = "clientName";
    private boolean nullableFields = false;
    private String dateLibrary = "core";

    public DartDioClientCodegen() {
        this.modifyFeatureSet(features -> features.includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.Authorizations, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/dart-dio";
        this.embeddedTemplateDir = "dart-dio";
        this.setTemplateDir(this.embeddedTemplateDir);
        this.cliOptions.add(new CliOption(NULLABLE_FIELDS, "Make all fields nullable in the JSON payload"));
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use").defaultValue(this.getDateLibrary());
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put("core", "Dart core library (DateTime)");
        dateOptions.put("timemachine", "Time Machine is date and time library for Flutter, Web, and Server with support for timezones, calendars, cultures, formatting and parsing.");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        this.typeMapping.put("Array", "BuiltList");
        this.typeMapping.put("array", "BuiltList");
        this.typeMapping.put("List", "BuiltList");
        this.typeMapping.put("set", "BuiltSet");
        this.typeMapping.put("map", "BuiltMap");
        this.typeMapping.put("file", "Uint8List");
        this.typeMapping.put("binary", "Uint8List");
        this.typeMapping.put("object", "JsonObject");
        this.typeMapping.put("AnyType", "JsonObject");
        this.additionalReservedWords.addAll(Sets.newHashSet((Object[])new String[]{"EnumClass", "BuiltList", "BuiltSet", "BuiltMap", "Uint8List", "JsonObject"}));
        this.importMapping.put("BuiltList", "package:built_collection/built_collection.dart");
        this.importMapping.put("BuiltSet", "package:built_collection/built_collection.dart");
        this.importMapping.put("BuiltMap", "package:built_collection/built_collection.dart");
        this.importMapping.put("JsonObject", "package:built_value/json_object.dart");
        this.importMapping.put("Uint8List", "dart:typed_data");
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public boolean getNullableFields() {
        return this.nullableFields;
    }

    public void setNullableFields(boolean nullableFields) {
        this.nullableFields = nullableFields;
    }

    @Override
    public String getName() {
        return "dart-dio";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Dio client library.";
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"escapeBuiltValueEnum", (fragment, writer) -> writer.write(fragment.execute().replace("$", "\\$")));
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            if (ModelUtils.isArraySchema(schema)) {
                if (ModelUtils.isSet(schema)) {
                    return "SetBuilder()";
                }
                return "ListBuilder()";
            }
            if (ModelUtils.isMapSchema(schema)) {
                return "MapBuilder()";
            }
            if (ModelUtils.isDateSchema(schema) || ModelUtils.isDateTimeSchema(schema)) {
                return null;
            }
            if (ModelUtils.isStringSchema(schema)) {
                return "'" + schema.getDefault().toString().replaceAll("'", "\\'") + "'";
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(NULLABLE_FIELDS)) {
            this.setNullableFields(this.convertPropertyToBooleanAndWriteBack(NULLABLE_FIELDS));
        } else {
            this.additionalProperties.put(NULLABLE_FIELDS, this.nullableFields);
        }
        if (!this.additionalProperties.containsKey(CLIENT_NAME)) {
            this.additionalProperties.put(CLIENT_NAME, StringUtils.camelize(this.pubName));
        }
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        this.supportingFiles.add(new SupportingFile("api_util.mustache", libFolder, "api_util.dart"));
        this.supportingFiles.add(new SupportingFile("serializers.mustache", libFolder, "serializers.dart"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        String authFolder = libFolder + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/basic_auth.mustache", authFolder, "basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/auth.mustache", authFolder, "auth.dart"));
        if ("core".equals(this.dateLibrary)) {
            this.additionalProperties.put("core", "true");
        } else if ("timemachine".equals(this.dateLibrary)) {
            this.additionalProperties.put("timeMachine", "true");
            this.typeMapping.put("date", "OffsetDate");
            this.typeMapping.put("Date", "OffsetDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.typeMapping.put("datetime", "OffsetDateTime");
            this.additionalReservedWords.addAll(Sets.newHashSet((Object[])new String[]{"OffsetDate", "OffsetDateTime"}));
            this.importMapping.put("OffsetDate", "package:time_machine/time_machine.dart");
            this.importMapping.put("OffsetDateTime", "package:time_machine/time_machine.dart");
            this.supportingFiles.add(new SupportingFile("local_date_serializer.mustache", libFolder, "local_date_serializer.dart"));
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models, 1);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            HashSet<String> modelImports = new HashSet<String>();
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (String modelImport : cm.imports) {
                if (!this.needToImport(modelImport)) continue;
                if (this.importMapping().containsKey(modelImport)) {
                    modelImports.add(this.importMapping().get(modelImport));
                    continue;
                }
                modelImports.add("package:" + this.pubName + "/model/" + StringUtils.underscore(modelImport) + ".dart");
            }
            cm.imports = modelImports;
            boolean hasVars = cm.vars.size() > 0;
            cm.vendorExtensions.put("x-has-vars", hasVars);
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (this.nullableFields) {
            property.isNullable = true;
        }
        if (property.isEnum) {
            model.imports.add("BuiltSet");
        }
        property.getVendorExtensions().put("x-built-value-serializer-type", this.createBuiltValueSerializerType(property));
    }

    private String createBuiltValueSerializerType(CodegenProperty property) {
        StringBuilder sb = new StringBuilder("const FullType(");
        if (property.isContainer) {
            this.appendCollection(sb, property);
        } else {
            sb.append(property.datatypeWithEnum);
        }
        sb.append(")");
        return sb.toString();
    }

    private void appendCollection(StringBuilder sb, CodegenProperty property) {
        sb.append(property.baseType);
        sb.append(", [FullType(");
        if (property.isMap) {
            sb.append("String), FullType(");
        }
        if (property.items.isContainer) {
            this.appendCollection(sb, property.items);
        } else {
            sb.append(property.items.datatypeWithEnum);
        }
        sb.append(")]");
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        HashSet serializers = new HashSet();
        HashSet<String> modelImports = new HashSet<String>();
        HashSet<String> fullImports = new HashSet<String>();
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            boolean isJson = true;
            boolean isForm = false;
            boolean isMultipart = false;
            if (op.consumes != null) {
                for (Map map : op.consumes) {
                    if (!map.containsKey("mediaType")) continue;
                    String type = (String)map.get("mediaType");
                    isJson = type.equalsIgnoreCase("application/json");
                    isForm = type.equalsIgnoreCase("application/x-www-form-urlencoded");
                    isMultipart = type.equalsIgnoreCase("multipart/form-data");
                    break;
                }
            }
            for (CodegenParameter codegenParameter : op.bodyParams) {
                if (codegenParameter.baseType != null && codegenParameter.baseType.equalsIgnoreCase("Uint8List") && isMultipart) {
                    codegenParameter.baseType = "MultipartFile";
                    codegenParameter.dataType = "MultipartFile";
                }
                if (!codegenParameter.isContainer) continue;
                HashMap<String, Object> serializer = new HashMap<String, Object>();
                serializer.put("isArray", codegenParameter.isArray);
                serializer.put("uniqueItems", codegenParameter.uniqueItems);
                serializer.put("isMap", codegenParameter.isMap);
                serializer.put("baseType", codegenParameter.baseType);
                serializers.add(serializer);
            }
            op.vendorExtensions.put("x-is-json", isJson);
            op.vendorExtensions.put("x-is-form", isForm);
            op.vendorExtensions.put("x-is-multipart", isMultipart);
            if (op.getHasFormParams()) {
                fullImports.add("package:" + this.pubName + "/api_util.dart");
            }
            HashSet<String> imports = new HashSet<String>();
            for (String item : op.imports) {
                if (!this.needToImport(item)) continue;
                if (this.importMapping().containsKey(item)) {
                    fullImports.add(this.importMapping().get(item));
                    continue;
                }
                imports.add(StringUtils.underscore(item));
            }
            modelImports.addAll(imports);
            op.imports = imports;
            if (op.returnContainer == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("isArray", Objects.equals("array", op.returnContainer) || Objects.equals("set", op.returnContainer));
            hashMap.put("uniqueItems", op.uniqueItems);
            hashMap.put("isMap", Objects.equals("map", op.returnContainer));
            hashMap.put("baseType", op.returnBaseType);
            serializers.add(hashMap);
        }
        objs.put("modelImports", modelImports);
        objs.put("fullImports", fullImports);
        objs.put("serializers", serializers);
        return objs;
    }
}

