/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;

public class WsdlSchemaCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "projectName";

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public String getName() {
        return "wsdl-schema";
    }

    @Override
    public String getHelp() {
        return "Generates WSDL files.";
    }

    public WsdlSchemaCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "wsdl-schema";
        this.templateDir = "wsdl-schema";
        this.embeddedTemplateDir = "wsdl-schema";
        this.apiPackage = "Apis";
        this.modelPackage = "Models";
        this.cliOptions.add(new CliOption("hostname", "the hostname of the service"));
        this.cliOptions.add(new CliOption("soapPath", "basepath of the soap services"));
        this.cliOptions.add(new CliOption("serviceName", "service name for the wsdl"));
        this.additionalProperties.put("hostname", "localhost");
        this.additionalProperties.put("soapPath", "soap");
        this.additionalProperties.put("serviceName", "ServiceV1");
        this.supportingFiles.add(new SupportingFile("wsdl-converter.mustache", "", "service.wsdl"));
        this.supportingFiles.add(new SupportingFile("jaxb-customization.mustache", "", "jaxb-customization.xml"));
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        String title = info.getTitle();
        String description = info.getDescription();
        info.setDescription(this.processOpenapiSpecDescription(description));
        info.setTitle(this.escapeTitle(title));
    }

    private String escapeTitle(String title) {
        String normalizedTitle = Normalizer.normalize(title, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        return super.escapeUnsafeCharacters(normalizedTitle);
    }

    public String processOpenapiSpecDescription(String description) {
        if (description != null) {
            return description.replaceAll("\\s+", " ");
        }
        return "No description provided";
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.operationId = this.generateOperationId(op);
            for (CodegenParameter param : op.allParams) {
                Map<String, Object> paramVendorExtensions = param.vendorExtensions;
                this.normalizeDataType(param);
                if ("null".equals(param.defaultValue) || param.defaultValue == null) {
                    paramVendorExtensions.put("x-param-has-defaultvalue", false);
                } else {
                    paramVendorExtensions.put("x-param-has-defaultvalue", true);
                }
                if (param.minimum != null || param.maximum != null || param.minLength != null || param.maxLength != null) {
                    paramVendorExtensions.put("x-param-has-minormax", true);
                } else {
                    paramVendorExtensions.put("x-param-has-minormax", false);
                }
                if (!param.isEnum) continue;
                param.baseName = param.baseName.substring(0, 1).toUpperCase(Locale.getDefault()) + param.baseName.substring(1);
            }
            for (CodegenResponse response : op.responses) {
                if (response.isModel) {
                    response.dataType = response.dataType.substring(0, 1).toUpperCase(Locale.getDefault()) + response.dataType.substring(1);
                }
                if (!response.isArray) continue;
                response.baseType = response.baseType.substring(0, 1).toUpperCase(Locale.getDefault()) + response.baseType.substring(1);
            }
            for (CodegenParameter param : op.bodyParams) {
                this.normalizeDataType(param);
            }
            for (CodegenParameter param : op.pathParams) {
                this.normalizeDataType(param);
            }
            for (CodegenParameter param : op.queryParams) {
                this.normalizeDataType(param);
            }
            for (CodegenParameter param : op.formParams) {
                this.normalizeDataType(param);
            }
        }
        return objs;
    }

    private void normalizeDataType(CodegenParameter param) {
        if (param.isPrimitiveType) {
            param.dataType = param.dataType.toLowerCase(Locale.getDefault());
        }
        if (param.dataFormat != null && param.dataFormat.equalsIgnoreCase("date")) {
            param.dataType = "date";
        }
        if (param.dataFormat != null && param.dataFormat.equalsIgnoreCase("date-time")) {
            param.dataType = "dateTime";
        }
        if (param.dataFormat != null && param.dataFormat.equalsIgnoreCase("uuid")) {
            param.dataType = "string";
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object mo : models) {
            Map mod = (Map)mo;
            CodegenModel model = (CodegenModel)mod.get("model");
            Map<String, Object> modelVendorExtensions = model.getVendorExtensions();
            for (CodegenProperty var : model.vars) {
                Map<String, Object> propertyVendorExtensions = var.getVendorExtensions();
                if ("string".equals(var.openApiType)) {
                    var.baseType = var.baseType.substring(0, 1).toLowerCase(Locale.getDefault()) + var.baseType.substring(1);
                }
                if (var.isEnum) {
                    var.name = var.name.substring(0, 1).toUpperCase(Locale.getDefault()) + var.name.substring(1);
                }
                if ("null".equals(var.defaultValue) || var.defaultValue == null) {
                    propertyVendorExtensions.put("x-prop-has-defaultvalue", false);
                } else {
                    propertyVendorExtensions.put("x-prop-has-defaultvalue", true);
                }
                if (var.minimum != null || var.maximum != null || var.minLength != null || var.maxLength != null) {
                    propertyVendorExtensions.put("x-prop-has-minormax", true);
                } else {
                    propertyVendorExtensions.put("x-prop-has-minormax", false);
                }
                if (!"array".equals(var.openApiType) || !var.items.dataType.startsWith("oneOf<")) continue;
                String schemaNamesString = var.items.dataType.substring(6, var.items.dataType.length() - 1);
                ArrayList<String> oneofSchemas = new ArrayList<String>(Arrays.asList(schemaNamesString.split("\\s*,\\s*")));
                for (int i = 0; i < oneofSchemas.size(); ++i) {
                    oneofSchemas.set(i, this.lowerCaseStringExceptFirstLetter((String)oneofSchemas.get(i)));
                }
                propertyVendorExtensions.put("x-oneof-schemas", oneofSchemas);
            }
        }
        return super.postProcessModelsEnum(objs);
    }

    public String generateOperationId(CodegenOperation op) {
        int i;
        String newOperationid = this.lowerCaseStringExceptFirstLetter(op.httpMethod);
        String[] pathElements = op.path.split("/");
        ArrayList<String> pathParameters = new ArrayList<String>();
        for (i = 0; i < pathElements.length; ++i) {
            if (pathElements[i].contains("{")) {
                pathParameters.add(pathElements[i]);
                pathElements[i] = "";
            }
            if (pathElements[i].length() <= 0) continue;
            newOperationid = newOperationid + this.lowerCaseStringExceptFirstLetter(pathElements[i]);
        }
        if (pathParameters.size() > 0) {
            for (i = 0; i < pathParameters.size(); ++i) {
                String pathParameter = (String)pathParameters.get(i);
                pathParameter = this.lowerCaseStringExceptFirstLetter(pathParameter.substring(1, pathParameter.length() - 1));
                newOperationid = i == 0 ? newOperationid + "By" + pathParameter : newOperationid + "And" + pathParameter;
            }
        }
        return newOperationid;
    }

    public String lowerCaseStringExceptFirstLetter(String value) {
        String newOperationid = value.toLowerCase(Locale.getDefault());
        return newOperationid.substring(0, 1).toUpperCase(Locale.getDefault()) + newOperationid.substring(1);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

