/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinServerDeprecatedCodegen
extends AbstractKotlinCodegen {
    public static final String DEFAULT_LIBRARY = "ktor";
    private final Logger LOGGER = LoggerFactory.getLogger(KotlinServerDeprecatedCodegen.class);
    private Boolean autoHeadFeatureEnabled = true;
    private Boolean conditionalHeadersFeatureEnabled = false;
    private Boolean hstsFeatureEnabled = true;
    private Boolean corsFeatureEnabled = false;
    private Boolean compressionFeatureEnabled = true;
    private Map<String, List<String>> optionsSupportedPerFramework = new ImmutableMap.Builder().put((Object)"ktor", Arrays.asList("featureAutoHead", "featureConditionalHeaders", "featureHSTS", "featureCORS", "featureCompression")).build();

    public KotlinServerDeprecatedCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.DEPRECATED).build();
        this.artifactId = "kotlin-server-deprecated";
        this.packageName = "org.openapitools.server";
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-server-deprecated";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.templateDir = "kotlin-server-deprecated";
        this.embeddedTemplateDir = "kotlin-server-deprecated";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ktor framework");
        CliOption library = new CliOption("library", "library template (sub-template)");
        library.setDefault(DEFAULT_LIBRARY);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
        this.addSwitch("featureAutoHead", "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.", this.getAutoHeadFeatureEnabled());
        this.addSwitch("featureConditionalHeaders", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getConditionalHeadersFeatureEnabled());
        this.addSwitch("featureHSTS", "Avoid sending content if client already has same content, by checking ETag or LastModified properties.", this.getHstsFeatureEnabled());
        this.addSwitch("featureCORS", "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.", this.getCorsFeatureEnabled());
        this.addSwitch("featureCompression", "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.", this.getCompressionFeatureEnabled());
    }

    public Boolean getAutoHeadFeatureEnabled() {
        return this.autoHeadFeatureEnabled;
    }

    public void setAutoHeadFeatureEnabled(Boolean autoHeadFeatureEnabled) {
        this.autoHeadFeatureEnabled = autoHeadFeatureEnabled;
    }

    public Boolean getCompressionFeatureEnabled() {
        return this.compressionFeatureEnabled;
    }

    public void setCompressionFeatureEnabled(Boolean compressionFeatureEnabled) {
        this.compressionFeatureEnabled = compressionFeatureEnabled;
    }

    public Boolean getConditionalHeadersFeatureEnabled() {
        return this.conditionalHeadersFeatureEnabled;
    }

    public void setConditionalHeadersFeatureEnabled(Boolean conditionalHeadersFeatureEnabled) {
        this.conditionalHeadersFeatureEnabled = conditionalHeadersFeatureEnabled;
    }

    public Boolean getCorsFeatureEnabled() {
        return this.corsFeatureEnabled;
    }

    public void setCorsFeatureEnabled(Boolean corsFeatureEnabled) {
        this.corsFeatureEnabled = corsFeatureEnabled;
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin server (Ktor v1.1.3). IMPORTANT: this generator has been deprecated. Please migrate to `kotlin-server` which supports Ktor v1.5.2+.";
    }

    public Boolean getHstsFeatureEnabled() {
        return this.hstsFeatureEnabled;
    }

    public void setHstsFeatureEnabled(Boolean hstsFeatureEnabled) {
        this.hstsFeatureEnabled = hstsFeatureEnabled;
    }

    @Override
    public String getName() {
        return "kotlin-server-deprecated";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary(DEFAULT_LIBRARY);
            this.additionalProperties.put("library", DEFAULT_LIBRARY);
            this.LOGGER.info("`library` option is empty. Default to {}", (Object)DEFAULT_LIBRARY);
        }
        if (this.additionalProperties.containsKey("featureAutoHead")) {
            this.setAutoHeadFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureAutoHead"));
        } else {
            this.additionalProperties.put("featureAutoHead", this.getAutoHeadFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureConditionalHeaders")) {
            this.setConditionalHeadersFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureConditionalHeaders"));
        } else {
            this.additionalProperties.put("featureConditionalHeaders", this.getConditionalHeadersFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureHSTS")) {
            this.setHstsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureHSTS"));
        } else {
            this.additionalProperties.put("featureHSTS", this.getHstsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCORS")) {
            this.setCorsFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCORS"));
        } else {
            this.additionalProperties.put("featureCORS", this.getCorsFeatureEnabled());
        }
        if (this.additionalProperties.containsKey("featureCompression")) {
            this.setCompressionFeatureEnabled(this.convertPropertyToBooleanAndWriteBack("featureCompression"));
        } else {
            this.additionalProperties.put("featureCompression", this.getCompressionFeatureEnabled());
        }
        boolean generateApis = this.additionalProperties.containsKey("generateApis") && (Boolean)this.additionalProperties.get("generateApis") != false;
        String packageFolder = (this.sourceFolder + File.separator + this.packageName).replace(".", File.separator);
        String resourcesFolder = "src/main/resources";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("gradle.properties", "", "gradle.properties"));
        this.supportingFiles.add(new SupportingFile("AppMain.kt.mustache", packageFolder, "AppMain.kt"));
        this.supportingFiles.add(new SupportingFile("Configuration.kt.mustache", packageFolder, "Configuration.kt"));
        if (generateApis) {
            this.supportingFiles.add(new SupportingFile("Paths.kt.mustache", packageFolder, "Paths.kt"));
        }
        this.supportingFiles.add(new SupportingFile("application.conf.mustache", resourcesFolder, "application.conf"));
        this.supportingFiles.add(new SupportingFile("logback.xml", resourcesFolder, "logback.xml"));
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("ApiKeyAuth.kt.mustache", infrastructureFolder, "ApiKeyAuth.kt"));
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f      #");
        System.out.println("################################################################################");
    }

    public static class Constants {
        public static final String KTOR = "ktor";
        public static final String AUTOMATIC_HEAD_REQUESTS = "featureAutoHead";
        public static final String AUTOMATIC_HEAD_REQUESTS_DESC = "Automatically provide responses to HEAD requests for existing routes that have the GET verb defined.";
        public static final String CONDITIONAL_HEADERS = "featureConditionalHeaders";
        public static final String CONDITIONAL_HEADERS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String HSTS = "featureHSTS";
        public static final String HSTS_DESC = "Avoid sending content if client already has same content, by checking ETag or LastModified properties.";
        public static final String CORS = "featureCORS";
        public static final String CORS_DESC = "Ktor by default provides an interceptor for implementing proper support for Cross-Origin Resource Sharing (CORS). See enable-cors.org.";
        public static final String COMPRESSION = "featureCompression";
        public static final String COMPRESSION_DESC = "Adds ability to compress outgoing content using gzip, deflate or custom encoder and thus reduce size of the response.";
    }
}

