/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openapi;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    private static ObjectMapper structureMapper = Json.mapper().copy();
    final Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);

    void flatten(OpenAPI openapi) {
        this.openapi = openapi;
        if (openapi.getComponents() == null) {
            openapi.setComponents(new Components());
        }
        if (openapi.getComponents().getSchemas() == null) {
            openapi.getComponents().setSchemas(new HashMap());
        }
        this.flattenPaths(openapi);
        this.flattenComponents(openapi);
    }

    private void flattenPaths(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            return;
        }
        for (Map.Entry pathsEntry : paths.entrySet()) {
            String pathname = (String)pathsEntry.getKey();
            PathItem path = (PathItem)pathsEntry.getValue();
            ArrayList operations = new ArrayList(path.readOperations());
            for (Operation operation : path.readOperations()) {
                Map callbacks = operation.getCallbacks();
                if (callbacks == null) continue;
                operations.addAll(callbacks.values().stream().flatMap(callback -> callback.values().stream()).flatMap(pathItem -> pathItem.readOperations().stream()).collect(Collectors.toList()));
            }
            for (Operation operation : operations) {
                this.flattenRequestBody(openAPI, pathname, operation);
                this.flattenParameters(openAPI, pathname, operation);
                this.flattenResponses(openAPI, pathname, operation);
            }
        }
    }

    private void flattenRequestBody(OpenAPI openAPI, String pathname, Operation operation) {
        ObjectSchema op;
        ArraySchema am;
        Schema inner;
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody == null) {
            return;
        }
        Schema model = ModelUtils.getSchemaFromRequestBody(requestBody);
        if (model instanceof ObjectSchema) {
            Schema obj = model;
            if ((obj.getType() == null || "object".equals(obj.getType())) && obj.getProperties() != null && obj.getProperties().size() > 0) {
                Set consumes;
                this.flattenProperties(openAPI, obj.getProperties(), pathname);
                String modelName = this.resolveModelName(obj.getTitle(), "inline_object");
                this.addGenerated(modelName, model);
                openAPI.getComponents().addSchemas(modelName, model);
                RequestBody rb = new RequestBody();
                rb.setRequired(requestBody.getRequired());
                Content content = new Content();
                MediaType mt = new MediaType();
                Schema schema = new Schema();
                schema.set$ref(modelName);
                mt.setSchema(schema);
                if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
                    consumes = new HashSet<String>();
                    consumes.add("application/json");
                    this.LOGGER.info("Default to application/json for inline body schema");
                } else {
                    consumes = requestBody.getContent().keySet();
                }
                for (String consume : consumes) {
                    content.addMediaType(consume, mt);
                }
                rb.setContent(content);
                if (openAPI.getComponents().getRequestBodies() == null) {
                    HashMap<String, RequestBody> requestBodies = new HashMap<String, RequestBody>();
                    requestBodies.put(modelName, rb);
                    openAPI.getComponents().setRequestBodies(requestBodies);
                } else {
                    openAPI.getComponents().getRequestBodies().put(modelName, rb);
                }
                requestBody.set$ref(modelName);
            }
        } else if (model instanceof ArraySchema && (inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema && (op = (ObjectSchema)inner).getProperties() != null && op.getProperties().size() > 0) {
            this.flattenProperties(openAPI, op.getProperties(), pathname);
            String modelName = this.resolveModelName(op.getTitle(), null);
            Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                Schema schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                am.setItems(schema);
            } else {
                Schema schema = new Schema().$ref(modelName);
                schema.setRequired(op.getRequired());
                am.setItems(schema);
                this.addGenerated(modelName, innerModel);
                openAPI.getComponents().addSchemas(modelName, innerModel);
            }
        }
    }

    private void flattenParameters(OpenAPI openAPI, String pathname, Operation operation) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            Schema schema;
            ObjectSchema op;
            ArraySchema am;
            Schema inner;
            if (parameter.getSchema() == null) continue;
            Schema model = parameter.getSchema();
            if (model instanceof ObjectSchema) {
                Schema obj = model;
                if (obj.getType() != null && !"object".equals(obj.getType()) || obj.getProperties() == null || obj.getProperties().size() <= 0) continue;
                this.flattenProperties(openAPI, obj.getProperties(), pathname);
                String modelName = this.resolveModelName(obj.getTitle(), parameter.getName());
                parameter.$ref(modelName);
                this.addGenerated(modelName, model);
                openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (!(model instanceof ArraySchema) || !((inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(openAPI, op.getProperties(), pathname);
            String modelName = this.resolveModelName(op.getTitle(), parameter.getName());
            Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                am.setItems(schema);
                continue;
            }
            schema = new Schema().$ref(modelName);
            schema.setRequired(op.getRequired());
            am.setItems(schema);
            this.addGenerated(modelName, innerModel);
            openAPI.getComponents().addSchemas(modelName, innerModel);
        }
    }

    private void flattenResponses(OpenAPI openAPI, String pathname, Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (responses == null) {
            return;
        }
        for (Map.Entry responsesEntry : responses.entrySet()) {
            MapSchema mp;
            Schema innerProperty;
            Schema schema;
            String existing;
            Schema innerModel;
            String modelName;
            ObjectSchema op;
            String key = (String)responsesEntry.getKey();
            ApiResponse response = (ApiResponse)responsesEntry.getValue();
            if (ModelUtils.getSchemaFromResponse(response) == null) continue;
            Schema property = ModelUtils.getSchemaFromResponse(response);
            if (property instanceof ObjectSchema) {
                ObjectSchema op2 = (ObjectSchema)property;
                if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                String modelName2 = this.resolveModelName(op2.getTitle(), "inline_response_" + key);
                Schema model = this.modelFromProperty(openAPI, (Schema)op2, modelName2);
                String existing2 = this.matchGenerated(model);
                Content content = response.getContent();
                for (MediaType mediaType : content.values()) {
                    Schema schema2;
                    if (existing2 != null) {
                        schema2 = this.makeSchema(existing2, property);
                        schema2.setRequired(op2.getRequired());
                        mediaType.setSchema(schema2);
                        continue;
                    }
                    schema2 = this.makeSchema(modelName2, property);
                    schema2.setRequired(op2.getRequired());
                    mediaType.setSchema(schema2);
                    this.addGenerated(modelName2, model);
                    openAPI.getComponents().addSchemas(modelName2, model);
                }
                continue;
            }
            if (property instanceof ArraySchema) {
                ArraySchema ap = (ArraySchema)property;
                Schema inner = ap.getItems();
                if (!(inner instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                this.flattenProperties(openAPI, op.getProperties(), pathname);
                modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    schema = this.makeSchema(existing, (Schema)op);
                    schema.setRequired(op.getRequired());
                    ap.setItems(schema);
                    continue;
                }
                schema = this.makeSchema(modelName, (Schema)op);
                schema.setRequired(op.getRequired());
                ap.setItems(schema);
                this.addGenerated(modelName, innerModel);
                openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (!(property instanceof MapSchema) || !((innerProperty = ModelUtils.getAdditionalProperties(openAPI, (Schema)(mp = (MapSchema)property))) instanceof ObjectSchema) || (op = (ObjectSchema)innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(openAPI, op.getProperties(), pathname);
            modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
            innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
            existing = this.matchGenerated(innerModel);
            if (existing != null) {
                schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                mp.setAdditionalProperties((Object)schema);
                continue;
            }
            schema = new Schema().$ref(modelName);
            schema.setRequired(op.getRequired());
            mp.setAdditionalProperties((Object)schema);
            this.addGenerated(modelName, innerModel);
            openAPI.getComponents().addSchemas(modelName, innerModel);
        }
    }

    private void flattenComposedChildren(OpenAPI openAPI, String key, List<Schema> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        ListIterator<Schema> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            Schema schema;
            Schema component = listIterator.next();
            if (component == null || component.get$ref() != null || (component.getProperties() == null || component.getProperties().isEmpty()) && (component.getEnum() == null || component.getEnum().isEmpty())) continue;
            String innerModelName = this.resolveModelName(component.getTitle(), key);
            Schema innerModel = this.modelFromProperty(openAPI, component, innerModelName);
            String existing = this.matchGenerated(innerModel);
            if (existing == null) {
                openAPI.getComponents().addSchemas(innerModelName, innerModel);
                this.addGenerated(innerModelName, innerModel);
                schema = new Schema().$ref(innerModelName);
                schema.setRequired(component.getRequired());
                listIterator.set(schema);
                continue;
            }
            schema = new Schema().$ref(existing);
            schema.setRequired(component.getRequired());
            listIterator.set(schema);
        }
    }

    private void flattenComponents(OpenAPI openAPI) {
        Map models = openAPI.getComponents().getSchemas();
        if (models == null) {
            return;
        }
        ArrayList modelNames = new ArrayList(models.keySet());
        for (String modelName : modelNames) {
            Schema schema;
            ObjectSchema op;
            Schema inner;
            ComposedSchema m;
            Schema model = (Schema)models.get(modelName);
            if (ModelUtils.isComposedSchema(model)) {
                m = (ComposedSchema)model;
                this.flattenComposedChildren(openAPI, modelName + "_allOf", m.getAllOf());
                this.flattenComposedChildren(openAPI, modelName + "_anyOf", m.getAnyOf());
                this.flattenComposedChildren(openAPI, modelName + "_oneOf", m.getOneOf());
                continue;
            }
            if (model instanceof Schema) {
                m = model;
                Map properties = m.getProperties();
                this.flattenProperties(openAPI, properties, modelName);
                this.fixStringModel((Schema)m);
                continue;
            }
            if (!ModelUtils.isArraySchema(model) || !((inner = (m = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
            Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, innerModelName);
            String existing = this.matchGenerated(innerModel);
            if (existing == null) {
                openAPI.getComponents().addSchemas(innerModelName, innerModel);
                this.addGenerated(innerModelName, innerModel);
                schema = new Schema().$ref(innerModelName);
                schema.setRequired(op.getRequired());
                m.setItems(schema);
                continue;
            }
            schema = new Schema().$ref(existing);
            schema.setRequired(op.getRequired());
            m.setItems(schema);
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (this.schemaIsOfType(m, "string") && this.schemaContainsExample(m) && (example = m.getExample().toString()).startsWith("\"") && example.endsWith("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private boolean schemaIsOfType(Schema m, String type) {
        return m.getType() != null && m.getType().equals(type);
    }

    private boolean schemaContainsExample(Schema m) {
        return m.getExample() != null && m.getExample() != "";
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            if (key == null) {
                this.LOGGER.warn("Found an inline schema without the `title` attribute. Default the model name to InlineObject instead. To have better control of the model naming, define the model separately so that it can be reused throughout the spec.");
                return this.uniqueName("InlineObject");
            }
            return this.uniqueName(this.sanitizeName(key));
        }
        return this.uniqueName(this.sanitizeName(title));
    }

    private String matchGenerated(Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            if (this.generatedSignature.containsKey(json)) {
                return this.generatedSignature.get(json);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addGenerated(String name, Schema model) {
        try {
            String json = structureMapper.writeValueAsString((Object)model);
            this.generatedSignature.put(json, name);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String sanitizeName(String name) {
        return name.replaceAll("^[0-9]", "_$0").replaceAll("[^A-Za-z0-9]", "_");
    }

    private String uniqueName(String name) {
        if (this.openapi.getComponents().getSchemas() == null) {
            return name;
        }
        String uniqueName = name;
        int count = 0;
        while (this.openapi.getComponents().getSchemas().containsKey(uniqueName)) {
            uniqueName = name + "_" + ++count;
        }
        return uniqueName;
    }

    private void flattenProperties(OpenAPI openAPI, Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> propertiesEntry : properties.entrySet()) {
            Schema schema;
            ObjectSchema op;
            Schema inner;
            ObjectSchema op2;
            ArraySchema ap;
            Schema inner2;
            String key = propertiesEntry.getKey();
            Schema property = propertiesEntry.getValue();
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                Schema schema2;
                ObjectSchema op3 = (ObjectSchema)property;
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(openAPI, (Schema)op3, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    schema2 = new Schema().$ref(existing);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                } else {
                    schema2 = new Schema().$ref(modelName);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                    modelsToAdd.put(modelName, model);
                    this.addGenerated(modelName, model);
                    this.openapi.getComponents().addSchemas(modelName, model);
                }
            } else if (property instanceof ArraySchema && (inner2 = (ap = (ArraySchema)property).getItems()) instanceof ObjectSchema && (op2 = (ObjectSchema)inner2).getProperties() != null && op2.getProperties().size() > 0) {
                Schema schema3;
                this.flattenProperties(openAPI, op2.getProperties(), path);
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema innerModel = this.modelFromProperty(openAPI, (Schema)op2, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    schema3 = new Schema().$ref(existing);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                } else {
                    schema3 = new Schema().$ref(modelName);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                    this.addGenerated(modelName, innerModel);
                    this.openapi.getComponents().addSchemas(modelName, innerModel);
                }
            }
            if (!ModelUtils.isMapSchema(property) || !((inner = ModelUtils.getAdditionalProperties(openAPI, property)) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(openAPI, op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.modelFromProperty(openAPI, (Schema)op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                property.setAdditionalProperties((Object)schema);
                continue;
            }
            schema = new Schema().$ref(modelName);
            schema.setRequired(op.getRequired());
            property.setAdditionalProperties((Object)schema);
            this.addGenerated(modelName, innerModel);
            this.openapi.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openapi.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    private Schema modelFromProperty(OpenAPI openAPI, Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setType(object.getType());
        model.setFormat(object.getFormat());
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(object.getName());
        model.setXml(xml);
        model.setRequired(object.getRequired());
        model.setNullable(object.getNullable());
        model.setEnum(object.getEnum());
        model.setType(object.getType());
        model.setDiscriminator(object.getDiscriminator());
        model.setWriteOnly(object.getWriteOnly());
        model.setUniqueItems(object.getUniqueItems());
        model.setTitle(object.getTitle());
        model.setReadOnly(object.getReadOnly());
        model.setPattern(object.getPattern());
        model.setNot(object.getNot());
        model.setMinProperties(object.getMinProperties());
        model.setMinLength(object.getMinLength());
        model.setMinItems(object.getMinItems());
        model.setMinimum(object.getMinimum());
        model.setMaxProperties(object.getMaxProperties());
        model.setMaxLength(object.getMaxLength());
        model.setMaxItems(object.getMaxItems());
        model.setMaximum(object.getMaximum());
        model.setExternalDocs(object.getExternalDocs());
        model.setExtensions(object.getExtensions());
        model.setExclusiveMinimum(object.getExclusiveMinimum());
        model.setExclusiveMaximum(object.getExclusiveMaximum());
        model.setExample(object.getExample());
        model.setDeprecated(object.getDeprecated());
        if (properties != null) {
            this.flattenProperties(openAPI, properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    private Schema makeSchema(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }

    static {
        structureMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        structureMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

