/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.EnumSet;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractRubyCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyOnRailsServerCodegen
extends AbstractRubyCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(RubyOnRailsServerCodegen.class);
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String appFolder = "app";
    protected String channelsFolder = this.appFolder + File.separator + "channels";
    protected String applicationCableFolder = this.channelsFolder + File.separator + "application_cable";
    protected String controllersFolder = this.appFolder + File.separator + "controllers";
    protected String jobsFolder = this.appFolder + File.separator + "jobs";
    protected String mailersFolder = this.appFolder + File.separator + "mailers";
    protected String modelsFolder = this.appFolder + File.separator + "models";
    protected String viewsFolder = this.appFolder + File.separator + "views";
    protected String layoutsFolder = this.viewsFolder + File.separator + "layouts";
    protected String binFolder = "bin";
    protected String configFolder = "config";
    protected String environmentsFolder = this.configFolder + File.separator + "environments";
    protected String initializersFolder = this.configFolder + File.separator + "initializers";
    protected String localesFolder = this.configFolder + File.separator + "locales";
    protected String dbFolder = "db";
    protected String migrateFolder = this.dbFolder + File.separator + "migrate";
    protected String libFolder = "lib";
    protected String tasksFolder = this.libFolder + File.separator + "tasks";
    protected String logFolder = "log";
    protected String publicFolder = "public";
    protected String testFolder = "test";
    protected String tmpFolder = "tmp";
    protected String cacheFolder = this.tmpFolder + File.separator + "cache";
    protected String pidFolder = this.tmpFolder + File.separator + "pids";
    protected String socketsFolder = this.tmpFolder + File.separator + "sockets";
    protected String vendorFolder = "vendor";
    protected String databaseAdapter = "sqlite";

    public RubyOnRailsServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code" + File.separator + "rails5";
        this.apiPackage = "app/controllers";
        this.apiTemplateFiles.put("controller.mustache", ".rb");
        this.modelPackage = "app/models";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.templateDir = "ruby-on-rails-server";
        this.embeddedTemplateDir = "ruby-on-rails-server";
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "integer");
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("long", "integer");
        this.typeMapping.put("short", "integer");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("boolean", "boolean");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("databaseAdapter", "The adapter for database (e.g. mysql, sqlite). Default: sqlite").defaultValue("sqlite"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setApiPackage("app/controllers");
        if (this.additionalProperties.containsKey("databaseAdapter")) {
            this.setDatabaseAdapter((String)this.additionalProperties.get("databaseAdapter"));
        } else {
            this.additionalProperties.put("databaseAdapter", this.databaseAdapter);
        }
        if ("sqlite".equals(this.databaseAdapter)) {
            this.additionalProperties.put("isDBSQLite", Boolean.TRUE);
        } else if ("mysql".equals(this.databaseAdapter)) {
            this.additionalProperties.put("isDBMySQL", Boolean.TRUE);
        } else {
            this.LOGGER.warn("Unknown database {}. Default to 'sqlite'.", (Object)this.databaseAdapter);
            this.additionalProperties.put("isDBSQLite", Boolean.TRUE);
        }
        this.supportingFiles.add(new SupportingFile("Gemfile.mustache", "", "Gemfile"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Rakefile", "", "Rakefile"));
        this.supportingFiles.add(new SupportingFile("config.ru", "", "config.ru"));
        this.supportingFiles.add(new SupportingFile("channel.rb", this.applicationCableFolder, "channel.rb"));
        this.supportingFiles.add(new SupportingFile("connection.rb", this.applicationCableFolder, "connection.rb"));
        this.supportingFiles.add(new SupportingFile("application_controller.rb", this.controllersFolder, "application_controller.rb"));
        this.supportingFiles.add(new SupportingFile("application_job.rb", this.jobsFolder, "application_job.rb"));
        this.supportingFiles.add(new SupportingFile("application_mailer.rb", this.mailersFolder, "application_mailer.rb"));
        this.supportingFiles.add(new SupportingFile("application_record.rb", this.modelsFolder, "application_record.rb"));
        this.supportingFiles.add(new SupportingFile("mailer.html.erb", this.layoutsFolder, "mailer.html.erb"));
        this.supportingFiles.add(new SupportingFile("mailer.text.erb", this.layoutsFolder, "mailer.text.erb"));
        this.supportingFiles.add(new SupportingFile("bundle", this.binFolder, "bundle"));
        this.supportingFiles.add(new SupportingFile("rails", this.binFolder, "rails"));
        this.supportingFiles.add(new SupportingFile("rake", this.binFolder, "rake"));
        this.supportingFiles.add(new SupportingFile("setup", this.binFolder, "setup"));
        this.supportingFiles.add(new SupportingFile("update", this.binFolder, "update"));
        this.supportingFiles.add(new SupportingFile("development.rb", this.environmentsFolder, "development.rb"));
        this.supportingFiles.add(new SupportingFile("production.rb", this.environmentsFolder, "production.rb"));
        this.supportingFiles.add(new SupportingFile("active_record_belongs_to_required_by_default.rb", this.initializersFolder, "active_record_belongs_to_required_by_default.rb"));
        this.supportingFiles.add(new SupportingFile("application_controller_renderer.rb", this.initializersFolder, "application_controller_renderer.rb"));
        this.supportingFiles.add(new SupportingFile("backtrace_silencers.rb", this.initializersFolder, "backtrace_silencers.rb"));
        this.supportingFiles.add(new SupportingFile("callback_terminator.rb", this.initializersFolder, "callback_terminator.rb"));
        this.supportingFiles.add(new SupportingFile("cors.rb", this.initializersFolder, "cors.rb"));
        this.supportingFiles.add(new SupportingFile("filter_parameter_logging.rb", this.initializersFolder, "filter_parameter_logging.rb"));
        this.supportingFiles.add(new SupportingFile("inflections.rb", this.initializersFolder, "inflections.rb"));
        this.supportingFiles.add(new SupportingFile("mime_types.rb", this.initializersFolder, "mime_types.rb"));
        this.supportingFiles.add(new SupportingFile("ssl_options.rb", this.initializersFolder, "ssl_options.rb"));
        this.supportingFiles.add(new SupportingFile("to_time_preserves_timezone.rb", this.initializersFolder, "to_time_preserves_timezone.rb"));
        this.supportingFiles.add(new SupportingFile("en.yml", this.localesFolder, "en.yml"));
        this.supportingFiles.add(new SupportingFile("application.rb", this.configFolder, "application.rb"));
        this.supportingFiles.add(new SupportingFile("boot.rb", this.configFolder, "boot.rb"));
        this.supportingFiles.add(new SupportingFile("cable.yml", this.configFolder, "cable.yml"));
        this.supportingFiles.add(new SupportingFile("database.mustache", this.configFolder, "database.yml"));
        this.supportingFiles.add(new SupportingFile("environment.rb", this.configFolder, "environment.rb"));
        this.supportingFiles.add(new SupportingFile("puma.rb", this.configFolder, "puma.rb"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", this.configFolder, "routes.rb"));
        this.supportingFiles.add(new SupportingFile("secrets.yml", this.configFolder, "secrets.yml"));
        this.supportingFiles.add(new SupportingFile("spring.rb", this.configFolder, "spring.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.migrateFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("migrate.mustache", this.migrateFolder, "0_init_tables.rb"));
        this.supportingFiles.add(new SupportingFile("schema.rb", this.dbFolder, "schema.rb"));
        this.supportingFiles.add(new SupportingFile("seeds.rb", this.dbFolder, "seeds.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.tasksFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.logFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("404.html", this.publicFolder, "404.html"));
        this.supportingFiles.add(new SupportingFile("422.html", this.publicFolder, "422.html"));
        this.supportingFiles.add(new SupportingFile("500.html", this.publicFolder, "500.html"));
        this.supportingFiles.add(new SupportingFile("apple-touch-icon-precomposed.png", this.publicFolder, "apple-touch-icon-precomposed.png"));
        this.supportingFiles.add(new SupportingFile("apple-touch-icon.png", this.publicFolder, "apple-touch-icon.png"));
        this.supportingFiles.add(new SupportingFile("favicon.ico", this.publicFolder, "favicon.ico"));
        this.supportingFiles.add(new SupportingFile("robots.txt", this.publicFolder, "robots.txt"));
        this.supportingFiles.add(new SupportingFile("robots.txt", this.publicFolder, "robots.txt"));
        this.supportingFiles.add(new SupportingFile("test_helper.rb", this.testFolder, "test_helper.rb"));
        this.supportingFiles.add(new SupportingFile(".keep", this.cacheFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.pidFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile(".keep", this.socketsFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("restart.txt", this.tmpFolder, "restart.txt"));
        this.supportingFiles.add(new SupportingFile(".keep", this.vendorFolder, ".keep"));
        this.supportingFiles.add(new SupportingFile("Dockerfile", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("docker-entrypoint.sh", "", "docker-entrypoint.sh"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "ruby-on-rails";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby on Rails (v5) server library.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        Object type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        return "string";
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            String modelName = StringUtils.camelize("Model" + name);
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.isReservedWord(name)) {
            String filename = StringUtils.underscore("model_" + name);
            this.LOGGER.warn("{} (reserved word) cannot be used as model filename. Renamed to {}", (Object)name, (Object)filename);
            return filename;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_controller";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "api";
        }
        return StringUtils.underscore(this.sanitizeName(name));
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "ApiController";
        }
        return StringUtils.camelize(name) + "Controller";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    public void setDatabaseAdapter(String databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }
}

