/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.CppQtAbstractCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.StringUtils;

public class CppQtClientCodegen
extends CppQtAbstractCodegen
implements CodegenConfig {
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate client.pri.";
    public static final String DEFAULT_PACKAGE_NAME = "QtOpenAPIClient";
    protected String packageName = "";
    protected String sourceFolder = "client";
    protected boolean optionalProjectFileFlag = true;

    public CppQtClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.MultiServer}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BasicAuth}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.ApiKey}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_AuthorizationCode}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_Implicit}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_ClientCredentials}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_Password}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterStyling}));
        this.outputFolder = "generated-code/cpp-qt-client";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "cpp-qt-client";
        this.embeddedTemplateDir = "cpp-qt-client";
        this.addOption("packageName", "C++ package (library) name.", DEFAULT_PACKAGE_NAME);
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "OAIHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "OAIHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, "OAIHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, "OAIHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpFileElement.h.mustache", this.sourceFolder, "OAIHttpFileElement.h"));
        this.supportingFiles.add(new SupportingFile("HttpFileElement.cpp.mustache", this.sourceFolder, "OAIHttpFileElement.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "OAIObject.h"));
        this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder, "OAIEnum.h"));
        this.supportingFiles.add(new SupportingFile("ServerConfiguration.mustache", this.sourceFolder, "OAIServerConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("ServerVariable.mustache", this.sourceFolder, "OAIServerVariable.h"));
        this.supportingFiles.add(new SupportingFile("oauth.cpp.mustache", this.sourceFolder, "OAIOauth.cpp"));
        this.supportingFiles.add(new SupportingFile("oauth.h.mustache", this.sourceFolder, "OAIOauth.h"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("CMakeConfig.mustache", this.sourceFolder, "Config.cmake.in"));
        this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, "client.pri"));
        }
        this.typeMapping.put("file", "OAIHttpFileElement");
        this.typeMapping.put("AnyType", "QJsonValue");
        this.importMapping.put("OAIHttpFileElement", "#include \"OAIHttpFileElement.h\"");
        this.importMapping.put("QJsonValue", "#include <QJsonValue>");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.packageName = this.additionalProperties.getOrDefault("packageName", DEFAULT_PACKAGE_NAME);
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        this.additionalProperties.put("packageName", this.packageName);
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.h"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.cpp"));
            this.supportingFiles.add(new SupportingFile("HttpFileElement.h.mustache", this.sourceFolder, this.modelNamePrefix + "HttpFileElement.h"));
            this.supportingFiles.add(new SupportingFile("HttpFileElement.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "HttpFileElement.cpp"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder, this.modelNamePrefix + "Enum.h"));
            this.supportingFiles.add(new SupportingFile("ServerConfiguration.mustache", this.sourceFolder, this.modelNamePrefix + "ServerConfiguration.h"));
            this.supportingFiles.add(new SupportingFile("ServerVariable.mustache", this.sourceFolder, this.modelNamePrefix + "ServerVariable.h"));
            this.supportingFiles.add(new SupportingFile("oauth.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "Oauth.cpp"));
            this.supportingFiles.add(new SupportingFile("oauth.h.mustache", this.sourceFolder, this.modelNamePrefix + "Oauth.h"));
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("CMakeConfig.mustache", this.sourceFolder, "Config.cmake.in"));
            this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
            this.typeMapping.put("file", this.modelNamePrefix + "HttpFileElement");
            this.typeMapping.put("AnyType", "QJsonValue");
            this.importMapping.put(this.modelNamePrefix + "HttpFileElement", "#include \"" + this.modelNamePrefix + "HttpFileElement.h\"");
            this.importMapping.put("QJsonValue", "#include <QJsonValue>");
            if (this.optionalProjectFileFlag) {
                this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, this.modelNamePrefix + "client.pri"));
            }
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-qt-client";
    }

    @Override
    public String getHelp() {
        return "Generates a Qt C++ client library.";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.sanitizeName(StringUtils.camelize(name)) + "Api";
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }
}

