/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenMediaType;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonCodegen.class);
    public static final String MAP_NUMBER_TO = "mapNumberTo";
    protected String packageName = "openapi_client";
    protected String packageVersion = "1.0.0";
    protected String projectName;
    protected boolean hasModelsToImport = Boolean.FALSE;
    protected String mapNumberTo = "Union[StrictFloat, StrictInt]";
    protected Map<Character, String> regexModifiers;
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();
    private HashMap<String, HashSet<String>> circularImports = new HashMap();
    private HashMap<String, CodegenModel> codegenModelMap = new HashMap();

    public AbstractPythonCodegen() {
        this.modifyFeatureSet(features -> features.securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)));
        this.setReservedWordsLowerCase(Arrays.asList("all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("dict");
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("object");
        this.languageSpecificPrimitives.add("file");
        this.languageSpecificPrimitives.add("bytes");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("set", "list");
        this.typeMapping.put("map", "dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("AnyType", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("binary", "str");
        this.typeMapping.put("ByteArray", "str");
        this.typeMapping.put("UUID", "str");
        this.typeMapping.put("URI", "str");
        this.typeMapping.put("null", "none_type");
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "False";
                }
                return "True";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                String defaultValue = (String)p.getDefault();
                if (defaultValue != null) {
                    defaultValue = defaultValue.replace("\\", "\\\\").replace("'", "'");
                    if (Pattern.compile("\r\n|\r|\n").matcher(defaultValue).find()) {
                        return "'''" + defaultValue + "'''";
                    }
                    return "'" + defaultValue + "'";
                }
            } else if (ModelUtils.isArraySchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        name = this.sanitizeName(name);
        if ((name = name.replace("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        name = StringUtils.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if ("callback".equals(name)) {
            return "param_callback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord((String)operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        if (((String)operationId).matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.underscore(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        return StringUtils.underscore(this.sanitizeName((String)operationId));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String pythonPostProcessFile = System.getenv("PYTHON_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pythonPostProcessFile)) {
            return;
        }
        if ("py".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = pythonPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toExampleValue(Schema schema) {
        return this.toExampleValueRecursive(schema, new ArrayList<Schema>(), 5);
    }

    private String toExampleValueRecursive(Schema schema, List<Schema> includedSchemas, int indentation) {
        boolean cycleFound;
        boolean bl = cycleFound = includedSchemas.stream().filter(s -> schema.equals(s)).count() > 1L;
        if (cycleFound) {
            return "";
        }
        Object indentationString = "";
        for (int i = 0; i < indentation; ++i) {
            indentationString = (String)indentationString + "    ";
        }
        Object example = null;
        if (schema.getExample() != null) {
            example = schema.getExample().toString();
        }
        if (ModelUtils.isNullType(schema) && null != example) {
            return "None";
        }
        if (ModelUtils.isBooleanSchema(schema) && null != example) {
            example = "false".equalsIgnoreCase((String)example) ? "False" : "True";
        }
        if (ModelUtils.isStringSchema(schema) && schema.getDefault() != null && !ModelUtils.isDateSchema(schema) && !ModelUtils.isDateTimeSchema(schema)) {
            example = (String)schema.getDefault();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)example) && !"null".equals(example)) {
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + (String)example + "'";
            }
            return example;
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            example = schema.getEnum().get(0).toString();
            if (ModelUtils.isStringSchema(schema)) {
                example = "'" + this.escapeText((String)example) + "'";
            }
            if (null == example) {
                this.LOGGER.warn("Empty enum. Cannot built an example!");
            }
            return example;
        }
        if (null != schema.get$ref()) {
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            String ref = ModelUtils.getSimpleRef(schema.get$ref());
            if (allDefinitions != null) {
                Schema refSchema = allDefinitions.get(ref);
                if (null == refSchema) {
                    return "None";
                }
                String refTitle = refSchema.getTitle();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                    refSchema.setTitle(ref);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema);
                }
                return this.toExampleValueRecursive(refSchema, includedSchemas, indentation);
            }
            this.LOGGER.warn("allDefinitions not defined in toExampleValue!\n");
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = "datetime.datetime.strptime('1975-12-30', '%Y-%m-%d').date()";
            return example;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = "datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f')";
            return example;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            example = "bytes(b'blah')";
            return example;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            example = "YQ==";
        } else if (ModelUtils.isStringSchema(schema)) {
            if ("Number".equalsIgnoreCase(schema.getFormat())) {
                return "1";
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                String pattern = schema.getPattern();
                RgxGen rgxGen = new RgxGen((CharSequence)this.patternCorrection(pattern));
                Random random = new Random(18L);
                String sample = rgxGen.generate(random);
                Pattern valueExtractor = Pattern.compile("^/\\^?(.+?)\\$?/.?$");
                Matcher m = valueExtractor.matcher(sample);
                example = m.find() ? m.group(m.groupCount()) : sample;
            }
            if (example == null) {
                example = "";
            }
            int len = 0;
            if (null != schema.getMinLength()) {
                len = schema.getMinLength();
                if (len < 1) {
                    example = "";
                } else {
                    for (int i = 0; i < len; ++i) {
                        example = (String)example + i;
                    }
                }
            }
        } else if (ModelUtils.isIntegerSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "56";
        } else if (ModelUtils.isNumberSchema(schema)) {
            example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1.337";
        } else if (ModelUtils.isBooleanSchema(schema)) {
            example = "True";
        } else if (ModelUtils.isArraySchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema);
            }
            ArraySchema arrayschema = (ArraySchema)schema;
            example = "[\n" + (String)indentationString + this.toExampleValueRecursive(arrayschema.getItems(), includedSchemas, indentation + 1) + "\n" + (String)indentationString + "]";
        } else if (ModelUtils.isMapSchema(schema)) {
            Object additionalObject;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                includedSchemas.add(schema);
            }
            if ((additionalObject = schema.getAdditionalProperties()) instanceof Schema) {
                Schema additional = (Schema)additionalObject;
                Object theKey = "'key'";
                if (additional.getEnum() != null && !additional.getEnum().isEmpty()) {
                    theKey = additional.getEnum().get(0).toString();
                    if (ModelUtils.isStringSchema(additional)) {
                        theKey = "'" + this.escapeText((String)theKey) + "'";
                    }
                }
                example = "{\n" + (String)indentationString + (String)theKey + " : " + this.toExampleValueRecursive(additional, includedSchemas, indentation + 1) + "\n" + (String)indentationString + "}";
            } else {
                example = "{ }";
            }
        } else if (ModelUtils.isObjectSchema(schema)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)schema.getTitle())) {
                example = "None";
                return example;
            }
            String toExclude = null;
            if (schema.getDiscriminator() != null) {
                toExclude = schema.getDiscriminator().getPropertyName();
            }
            example = this.packageName + ".models." + StringUtils.underscore(schema.getTitle()) + "." + schema.getTitle() + "(";
            ArrayList<String> reqs = new ArrayList<String>();
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                for (Object toAdd : schema.getProperties().keySet()) {
                    reqs.add((String)toAdd);
                }
                Map properties = schema.getProperties();
                Set propkeys = null;
                if (properties != null) {
                    propkeys = properties.keySet();
                }
                if (toExclude != null && reqs.contains(toExclude)) {
                    reqs.remove(toExclude);
                }
                for (String toRemove : includedSchemas.stream().map(Schema::getTitle).collect(Collectors.toList())) {
                    if (!reqs.contains(toRemove)) continue;
                    reqs.remove(toRemove);
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getTitle()) && !"null".equals(schema.getTitle())) {
                    includedSchemas.add(schema);
                }
                if (null != schema.getRequired()) {
                    for (Object toAdd : schema.getRequired()) {
                        reqs.add((String)toAdd);
                    }
                }
                if (null != propkeys) {
                    for (String propname : propkeys) {
                        Schema schema2 = (Schema)properties.get(propname);
                        if (!reqs.contains(propname)) continue;
                        String refTitle = schema2.getTitle();
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)refTitle) || "null".equals(refTitle)) {
                            schema2.setTitle(propname);
                        }
                        example = (String)example + "\n" + (String)indentationString + StringUtils.underscore(propname) + " = " + this.toExampleValueRecursive(schema2, includedSchemas, indentation + 1) + ", ";
                    }
                }
            }
            example = (String)example + ")";
        } else {
            this.LOGGER.warn("Type {} not handled properly in toExampleValue", (Object)schema.getType());
        }
        if (ModelUtils.isStringSchema(schema)) {
            example = "'" + this.escapeText((String)example) + "'";
        }
        return example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        Object example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText((String)example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.packageName + "." + type + "()";
        } else {
            this.LOGGER.warn("Type {} not handled properly in setParameterExampleValue", (Object)type);
        }
        if (example == null) {
            example = "None";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "[" + (String)example + "]";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "{'key': " + (String)example + "}";
        }
        p.example = example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema = parameter.getSchema();
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        } else if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public String sanitizeTag(String tag) {
        return this.sanitizeName(tag);
    }

    public String patternCorrection(String pattern) {
        boolean checkEnding;
        boolean bl = checkEnding = pattern.endsWith("/i") || pattern.endsWith("/g") || pattern.endsWith("/m");
        if (checkEnding) {
            pattern = pattern.substring(0, pattern.length() - 2);
        }
        if (pattern.endsWith("/")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        return pattern;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.additionalProperties.put("packageName", this.packageName);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p = ModelUtils.unaliasSchema(this.openAPI, p))) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        String openAPIType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            this.LOGGER.error("OpenAPI Type for {} is null. Default to UNKNOWN_OPENAPI_TYPE instead.", (Object)p.getName());
            openAPIType = "UNKNOWN_OPENAPI_TYPE";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (type != null) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        String origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        String sanitizedName = this.sanitizeName(name);
        sanitizedName = sanitizedName.replace("$", "");
        sanitizedName = sanitizedName.replaceAll("\\s+", "");
        Object nameWithPrefixSuffix = sanitizedName;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            this.schemaKeyToModelNameCache.put(origName, modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(origName, camelizedName);
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(AbstractPythonCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String toApiName(String name) {
        return super.toApiName(name);
    }

    @Override
    public String toApiVarName(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    protected static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.PYTHON;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(objs);
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            CodegenModel cm = ModelUtils.getModelByName(entry.getKey(), objs);
            this.codegenModelMap.put(cm.classname, ModelUtils.getModelByName(entry.getKey(), objs));
        }
        for (String string : this.codegenModelMap.keySet()) {
            this.createImportMapOfSet(string, this.codegenModelMap);
        }
        for (Map.Entry entry : processed.entrySet()) {
            entry.setValue(this.postProcessModelsMap((ModelsMap)entry.getValue()));
        }
        return processed;
    }

    private ModelsMap postProcessModelsMap(ModelsMap objs) {
        objs = this.postProcessModelsEnum(objs);
        TreeSet<String> typingImports = new TreeSet<String>();
        TreeSet<String> pydanticImports = new TreeSet<String>();
        TreeSet<String> datetimeImports = new TreeSet<String>();
        TreeSet<String> modelImports = new TreeSet<String>();
        TreeSet<String> postponedModelImports = new TreeSet<String>();
        for (ModelMap m : objs.getModels()) {
            TreeSet<CallSite> modelsToImport;
            TreeSet<String> exampleImports = new TreeSet<String>();
            TreeSet<String> postponedExampleImports = new TreeSet<String>();
            ArrayList<String> readOnlyFields = new ArrayList<String>();
            this.hasModelsToImport = false;
            int property_count = 1;
            typingImports.clear();
            pydanticImports.clear();
            datetimeImports.clear();
            CodegenModel model = m.getModel();
            if (model.getComposedSchemas() != null && model.getComposedSchemas().getOneOf() != null && !model.getComposedSchemas().getOneOf().isEmpty()) {
                int index = 0;
                List<CodegenProperty> oneOfs = model.getComposedSchemas().getOneOf();
                for (CodegenProperty oneOf : oneOfs) {
                    if ("none_type".equals(oneOf.dataType)) {
                        oneOfs.remove(index);
                        break;
                    }
                    ++index;
                }
            }
            List<CodegenProperty> codegenProperties = null;
            if (!model.oneOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getOneOf();
                typingImports.add("Any");
                typingImports.add("List");
                pydanticImports.add("Field");
                pydanticImports.add("StrictStr");
                pydanticImports.add("ValidationError");
                pydanticImports.add("validator");
            } else if (!model.anyOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getAnyOf();
                pydanticImports.add("Field");
                pydanticImports.add("StrictStr");
                pydanticImports.add("ValidationError");
                pydanticImports.add("validator");
            } else {
                codegenProperties = model.vars;
                if (model.getDiscriminator() != null && model.getDiscriminator().getMappedModels() != null) {
                    typingImports.add("Union");
                    Iterator discriminator = model.getDiscriminator().getMappedModels();
                    Iterator<Object> iterator = discriminator.iterator();
                    while (iterator.hasNext()) {
                        CodegenDiscriminator.MappedModel mappedModel = (CodegenDiscriminator.MappedModel)((Object)iterator.next());
                        postponedModelImports.add(mappedModel.getMappingName());
                    }
                }
            }
            if (!model.allOf.isEmpty()) {
                for (CodegenProperty cp : model.allVars) {
                    if (cp.isPrimitiveType && !cp.isModel) continue;
                    if (cp.isArray) {
                        modelImports.add(cp.items.dataType);
                        continue;
                    }
                    modelImports.add(cp.dataType);
                }
            }
            if (model.oneOf.isEmpty() && model.anyOf.isEmpty() && !model.isEnum && !this.disallowAdditionalPropertiesIfNotPresent) {
                typingImports.add("Dict");
                typingImports.add("Any");
            }
            for (CodegenProperty cp : codegenProperties) {
                Object typing = this.getPydanticType(cp, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, model.classname);
                ArrayList<String> fields = new ArrayList<String>();
                String firstField = "";
                if (cp.isReadOnly) {
                    readOnlyFields.add(cp.name);
                }
                if (!cp.required) {
                    firstField = "None";
                    typing = "Optional[" + (String)typing + "]";
                    typingImports.add("Optional");
                } else {
                    firstField = "...";
                    if (cp.isNullable) {
                        typing = "Optional[" + (String)typing + "]";
                        typingImports.add("Optional");
                    }
                }
                if (cp.baseName != null && !cp.baseName.equals(cp.name)) {
                    fields.add(String.format(Locale.ROOT, "alias=\"%s\"", cp.baseName));
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cp.description)) {
                    fields.add(String.format(Locale.ROOT, "description=\"%s\"", cp.description));
                }
                String fieldCustomization = "None".equals(firstField) ? (cp.defaultValue == null ? "None" : (cp.isArray || cp.isMap ? "None" : cp.defaultValue)) : firstField;
                if (!fields.isEmpty()) {
                    fields.add(0, fieldCustomization);
                    pydanticImports.add("Field");
                    fieldCustomization = String.format(Locale.ROOT, "Field(%s)", org.apache.commons.lang3.StringUtils.join(fields, (String)", "));
                }
                if ("...".equals(fieldCustomization)) {
                    pydanticImports.add("Field");
                    fieldCustomization = "Field(...)";
                }
                cp.vendorExtensions.put("x-py-typing", (String)typing + " = " + fieldCustomization);
                if (!model.oneOf.isEmpty()) {
                    cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "oneof_schema_%d_validator", property_count++));
                    continue;
                }
                if (model.anyOf.isEmpty()) continue;
                cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "anyof_schema_%d_validator", property_count++));
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.parent)) {
                modelImports.add(model.parent);
            } else if (!model.isEnum) {
                pydanticImports.add("BaseModel");
            }
            if (model.isEnum) {
                for (Map enumVars : (List)model.getAllowableValues().get("enumVars")) {
                    if (((Boolean)enumVars.get("isString")).booleanValue()) {
                        model.vendorExtensions.putIfAbsent("x-py-enum-type", "str");
                        enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "str"));
                        continue;
                    }
                    model.vendorExtensions.putIfAbsent("x-py-enum-type", "int");
                    enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "int"));
                }
            }
            model.getVendorExtensions().putIfAbsent("x-py-typing-imports", typingImports);
            model.getVendorExtensions().putIfAbsent("x-py-pydantic-imports", pydanticImports);
            model.getVendorExtensions().putIfAbsent("x-py-datetime-imports", datetimeImports);
            model.getVendorExtensions().putIfAbsent("x-py-readonly", readOnlyFields);
            if (!modelImports.isEmpty()) {
                modelsToImport = new TreeSet<CallSite>();
                for (String modelImport : modelImports) {
                    if (modelImport.equals(model.classname)) continue;
                    modelsToImport.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
                }
                model.getVendorExtensions().putIfAbsent("x-py-model-imports", modelsToImport);
            }
            if (postponedModelImports.isEmpty()) continue;
            modelsToImport = new TreeSet();
            for (String modelImport : postponedModelImports) {
                if (modelImport.equals(model.classname)) continue;
                modelsToImport.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
            }
            model.getVendorExtensions().putIfAbsent("x-py-postponed-model-imports", modelsToImport);
        }
        return objs;
    }

    private String getPydanticType(CodegenParameter cp, Set<String> typingImports, Set<String> pydanticImports, Set<String> datetimeImports, Set<String> modelImports, Set<String> exampleImports, Set<String> postponedModelImports, Set<String> postponedExampleImports, String classname) {
        if (cp == null) {
            this.LOGGER.warn("Codegen property is null (e.g. map/dict of undefined type). Default to typing.Any.");
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isArray) {
            Object constraints = "";
            if (cp.maxItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", max_items=%d", cp.maxItems);
            }
            if (cp.minItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", min_items=%d", cp.minItems);
            }
            if (cp.getUniqueItems()) {
                constraints = (String)constraints + ", unique_items=True";
            }
            pydanticImports.add("conlist");
            return String.format(Locale.ROOT, "conlist(%s%s)", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, classname), constraints);
        }
        if (cp.isMap) {
            typingImports.add("Dict");
            return String.format(Locale.ROOT, "Dict[str, %s]", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, classname));
        }
        if (cp.isString) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("constr");
                return String.format(Locale.ROOT, "constr(%s)", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("password".equals(cp.getFormat())) {
                pydanticImports.add("SecretStr");
                return "SecretStr";
            }
            pydanticImports.add("StrictStr");
            return "StrictStr";
        }
        if (cp.isNumber || cp.isFloat || cp.isDouble) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                ArrayList<Object> intFieldCustomization = new ArrayList<Object>();
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                        intFieldCustomization.add("lt=" + Math.ceil(Double.valueOf(cp.getMaximum())));
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                        intFieldCustomization.add("le=" + Math.floor(Double.valueOf(cp.getMaximum())));
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                        intFieldCustomization.add("gt=" + Math.floor(Double.valueOf(cp.getMinimum())));
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                        intFieldCustomization.add("ge=" + Math.ceil(Double.valueOf(cp.getMinimum())));
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    intFieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    pydanticImports.add("conint");
                    typingImports.add("Union");
                    return String.format(Locale.ROOT, "Union[%s(%s), %s(%s)]", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "), "conint", org.apache.commons.lang3.StringUtils.join(intFieldCustomization, (String)", "));
                }
                if ("StrictFloat".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
                }
                pydanticImports.add("confloat");
                return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                typingImports.add("Union");
                pydanticImports.add("StrictFloat");
                pydanticImports.add("StrictInt");
                return "Union[StrictFloat, StrictInt]";
            }
            if ("StrictFloat".equals(this.mapNumberTo)) {
                pydanticImports.add("StrictFloat");
                return "StrictFloat";
            }
            return "float";
        }
        if (cp.isInteger || cp.isLong || cp.isShort || cp.isUnboundedInteger) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("conint");
                return String.format(Locale.ROOT, "%s(%s)", "conint", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictInt");
            return "StrictInt";
        }
        if (cp.isBinary || cp.isByteArray) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("conbytes");
                pydanticImports.add("constr");
                typingImports.add("Union");
                return String.format(Locale.ROOT, "Union[conbytes(%s), constr(%<s)]", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictBytes");
            pydanticImports.add("StrictStr");
            typingImports.add("Union");
            return "Union[StrictBytes, StrictStr]";
        }
        if (cp.isBoolean) {
            pydanticImports.add("StrictBool");
            return "StrictBool";
        }
        if (cp.isDecimal) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("gt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("lt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("condecimal");
                return String.format(Locale.ROOT, "%s(%s)", "condecimal", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("condecimal");
            return "condecimal()";
        }
        if (cp.getIsAnyType()) {
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isDate || cp.isDateTime) {
            if (cp.isDate) {
                datetimeImports.add("date");
            }
            if (cp.isDateTime) {
                datetimeImports.add("datetime");
            }
            return cp.dataType;
        }
        if (cp.isUuid) {
            return cp.dataType;
        }
        if (cp.isFreeFormObject) {
            typingImports.add("Dict");
            typingImports.add("Any");
            return "Dict[str, Any]";
        }
        if (!cp.isPrimitiveType) {
            this.hasModelsToImport = true;
            modelImports.add(cp.dataType);
            exampleImports.add(cp.dataType);
            return cp.dataType;
        }
        if (cp.getContent() != null) {
            LinkedHashMap<String, CodegenMediaType> contents = cp.getContent();
            for (String key : contents.keySet()) {
                CodegenMediaType cmt = contents.get(key);
                if (cmt == null) continue;
                return this.getPydanticType(cmt.getSchema(), typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, classname);
            }
            throw new RuntimeException("Error! Failed to process getPydanticType when getting the content: " + cp);
        }
        throw new RuntimeException("Error! Codegen Parameter not yet supported in getPydanticType: " + cp);
    }

    private String getPydanticType(CodegenProperty cp, Set<String> typingImports, Set<String> pydanticImports, Set<String> datetimeImports, Set<String> modelImports, Set<String> exampleImports, Set<String> postponedModelImports, Set<String> postponedExampleImports, String classname) {
        if (cp == null) {
            this.LOGGER.warn("Codegen property is null (e.g. map/dict of undefined type). Default to typing.Any.");
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isEnum) {
            pydanticImports.add("validator");
        }
        if (cp.isArray) {
            Object constraints = "";
            if (cp.maxItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", max_items=%d", cp.maxItems);
            }
            if (cp.minItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", min_items=%d", cp.minItems);
            }
            if (cp.getUniqueItems()) {
                constraints = (String)constraints + ", unique_items=True";
            }
            pydanticImports.add("conlist");
            typingImports.add("List");
            return String.format(Locale.ROOT, "conlist(%s%s)", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, classname), constraints);
        }
        if (cp.isMap) {
            typingImports.add("Dict");
            return String.format(Locale.ROOT, "Dict[str, %s]", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, classname));
        }
        if (cp.isString) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("constr");
                return String.format(Locale.ROOT, "constr(%s)", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("password".equals(cp.getFormat())) {
                pydanticImports.add("SecretStr");
                return "SecretStr";
            }
            pydanticImports.add("StrictStr");
            return "StrictStr";
        }
        if (cp.isNumber || cp.isFloat || cp.isDouble) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                ArrayList<Object> intFieldCustomization = new ArrayList<Object>();
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                        intFieldCustomization.add("lt=" + (int)Math.ceil(Double.valueOf(cp.getMaximum())));
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                        intFieldCustomization.add("le=" + (int)Math.floor(Double.valueOf(cp.getMaximum())));
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                        intFieldCustomization.add("gt=" + (int)Math.floor(Double.valueOf(cp.getMinimum())));
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                        intFieldCustomization.add("ge=" + (int)Math.ceil(Double.valueOf(cp.getMinimum())));
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    intFieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    pydanticImports.add("conint");
                    typingImports.add("Union");
                    return String.format(Locale.ROOT, "Union[%s(%s), %s(%s)]", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "), "conint", org.apache.commons.lang3.StringUtils.join(intFieldCustomization, (String)", "));
                }
                if ("StrictFloat".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
                }
                pydanticImports.add("confloat");
                return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                typingImports.add("Union");
                pydanticImports.add("StrictFloat");
                pydanticImports.add("StrictInt");
                return "Union[StrictFloat, StrictInt]";
            }
            if ("StrictFloat".equals(this.mapNumberTo)) {
                pydanticImports.add("StrictFloat");
                return "StrictFloat";
            }
            return "float";
        }
        if (cp.isInteger || cp.isLong || cp.isShort || cp.isUnboundedInteger) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("conint");
                return String.format(Locale.ROOT, "%s(%s)", "conint", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictInt");
            return "StrictInt";
        }
        if (cp.isBinary || cp.isByteArray) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("conbytes");
                pydanticImports.add("constr");
                typingImports.add("Union");
                return String.format(Locale.ROOT, "Union[conbytes(%s), constr(%<s)]", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictBytes");
            pydanticImports.add("StrictStr");
            typingImports.add("Union");
            return "Union[StrictBytes, StrictStr]";
        }
        if (cp.isBoolean) {
            pydanticImports.add("StrictBool");
            return "StrictBool";
        }
        if (cp.isDecimal) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("gt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("lt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("condecimal");
                return String.format(Locale.ROOT, "%s(%s)", "condecimal", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("condecimal");
            return "condecimal()";
        }
        if (cp.getIsAnyType()) {
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isDate || cp.isDateTime) {
            if (cp.isDate) {
                datetimeImports.add("date");
            }
            if (cp.isDateTime) {
                datetimeImports.add("datetime");
            }
            return cp.dataType;
        }
        if (cp.isUuid) {
            return cp.dataType;
        }
        if (cp.isFreeFormObject) {
            typingImports.add("Dict");
            typingImports.add("Any");
            return "Dict[str, Any]";
        }
        if (!cp.isPrimitiveType || cp.isModel) {
            if (classname == null) {
                this.hasModelsToImport = true;
                modelImports.add(cp.dataType);
                exampleImports.add(cp.dataType);
            } else if (this.circularImports.containsKey(cp.dataType)) {
                if (this.circularImports.get(cp.dataType).contains(classname)) {
                    this.hasModelsToImport = true;
                    postponedModelImports.add(cp.dataType);
                    postponedExampleImports.add(cp.dataType);
                    this.LOGGER.debug("Skipped importing {} in {} due to circular import.", (Object)cp.dataType, (Object)classname);
                } else {
                    this.hasModelsToImport = true;
                    modelImports.add(cp.dataType);
                    exampleImports.add(cp.dataType);
                }
            } else {
                this.LOGGER.error("Failed to look up {} from the imports (map of set) of models.", (Object)cp.dataType);
            }
            return cp.dataType;
        }
        throw new RuntimeException("Error! Codegen Property not yet supported in getPydanticType: " + cp);
    }

    public void setMapNumberTo(String mapNumberTo) {
        if (!("Union[StrictFloat, StrictInt]".equals(mapNumberTo) || "StrictFloat".equals(mapNumberTo) || "float".equals(mapNumberTo))) {
            throw new IllegalArgumentException("mapNumberTo value must be Union[StrictFloat, StrictInt], StrictStr or float");
        }
        this.mapNumberTo = mapNumberTo;
    }

    public String toEnumVariableName(String name, String datatype) {
        if ("int".equals(datatype)) {
            return "NUMBER_" + ((String)name).replace("-", "MINUS_");
        }
        if (((String)(name = ((String)name).substring(1, ((String)name).length() - 1))).length() == 0) {
            return "EMPTY";
        }
        if (" ".equals(name)) {
            return "SPACE";
        }
        if ("_".equals(name)) {
            return "UNDERSCORE";
        }
        name = this.reservedWords.contains(name) ? ((String)name).toUpperCase(Locale.ROOT) : (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains(String.valueOf((char)character))) ? StringUtils.underscore(StringUtils.escape((String)name, this.specialCharReplacements, Collections.singletonList("_"), "_")).toUpperCase(Locale.ROOT) : ((String)name).toUpperCase(Locale.ROOT));
        name = ((String)name).replace(" ", "_");
        name = ((String)name).replaceFirst("^_", "");
        if (((String)(name = ((String)name).replaceFirst("_$", ""))).matches("\\d.*")) {
            name = "ENUM_" + ((String)name).toUpperCase(Locale.ROOT);
        }
        return name;
    }

    void createImportMapOfSet(String modelName, Map<String, CodegenModel> codegenModelMap) {
        HashSet<String> imports = new HashSet<String>();
        this.circularImports.put(modelName, imports);
        CodegenModel cm = codegenModelMap.get(modelName);
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet: " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    private String getModelNameFromDataType(CodegenProperty cp) {
        if (cp.isArray) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (cp.isMap) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (!cp.isPrimitiveType || cp.isModel) {
            return cp.dataType;
        }
        return null;
    }

    public void updateImportsFromCodegenModel(String modelName, CodegenModel cm, Set<String> imports) {
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null || modelName.equals(modelNameFromDataType) || imports.contains(modelNameFromDataType)) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, this.codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        HashMap<String, CallSite> item;
        HashMap<String, String> item2;
        this.hasModelsToImport = false;
        TreeSet<String> typingImports = new TreeSet<String>();
        TreeSet<String> pydanticImports = new TreeSet<String>();
        TreeSet<String> datetimeImports = new TreeSet<String>();
        TreeSet<String> modelImports = new TreeSet<String>();
        TreeSet<String> postponedModelImports = new TreeSet<String>();
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            ArrayList<CallSite> imports;
            TreeSet<String> exampleImports = new TreeSet<String>();
            TreeSet<String> postponedExampleImports = new TreeSet<String>();
            List<CodegenParameter> params = operation.allParams;
            for (CodegenParameter param : params) {
                Object typing = this.getPydanticType(param, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, null);
                ArrayList<String> fields = new ArrayList<String>();
                String firstField = "";
                if (!param.required) {
                    firstField = "None";
                    typing = "Optional[" + (String)typing + "]";
                    typingImports.add("Optional");
                } else {
                    firstField = "...";
                    if (param.isNullable) {
                        typing = "Optional[" + (String)typing + "]";
                        typingImports.add("Optional");
                    }
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.description)) {
                    fields.add(String.format(Locale.ROOT, "description=\"%s\"", param.description));
                }
                String fieldCustomization = "None".equals(firstField) ? null : firstField;
                if (!fields.isEmpty()) {
                    if (fieldCustomization != null) {
                        fields.add(0, fieldCustomization);
                    }
                    pydanticImports.add("Field");
                    fieldCustomization = String.format(Locale.ROOT, "Field(%s)", org.apache.commons.lang3.StringUtils.join(fields, (String)", "));
                } else {
                    fieldCustomization = "Field()";
                }
                if ("Field()".equals(fieldCustomization)) {
                    param.vendorExtensions.put("x-py-typing", typing);
                    continue;
                }
                param.vendorExtensions.put("x-py-typing", String.format(Locale.ROOT, "Annotated[%s, %s]", typing, fieldCustomization));
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operation.returnType)) {
                String string = this.getPydanticType(operation.returnProperty, typingImports, new TreeSet<String>(), datetimeImports, modelImports, exampleImports, postponedModelImports, postponedExampleImports, null);
            }
            if (!exampleImports.isEmpty()) {
                imports = new ArrayList<CallSite>();
                for (String exampleImport : exampleImports) {
                    imports.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(exampleImport) + " import " + exampleImport)));
                }
                operation.vendorExtensions.put("x-py-example-import", imports);
            }
            if (postponedExampleImports.isEmpty()) continue;
            imports = new ArrayList();
            for (String exampleImport : postponedExampleImports) {
                imports.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(exampleImport) + " import " + exampleImport)));
            }
            operation.vendorExtensions.put("x-py-example-import", imports);
        }
        ArrayList<Map<String, String>> newImports = new ArrayList<Map<String, String>>();
        if (!datetimeImports.isEmpty()) {
            item2 = new HashMap<String, String>();
            item2.put("import", String.format(Locale.ROOT, "from datetime import %s\n", org.apache.commons.lang3.StringUtils.join(datetimeImports, (String)", ")));
            newImports.add(item2);
        }
        if (!pydanticImports.isEmpty()) {
            item2 = new HashMap();
            item2.put("import", String.format(Locale.ROOT, "from pydantic import %s\n", org.apache.commons.lang3.StringUtils.join(pydanticImports, (String)", ")));
            newImports.add(item2);
        }
        if (!typingImports.isEmpty()) {
            item2 = new HashMap();
            item2.put("import", String.format(Locale.ROOT, "from typing import %s\n", org.apache.commons.lang3.StringUtils.join(typingImports, (String)", ")));
            newImports.add(item2);
        }
        if (!modelImports.isEmpty()) {
            for (String modelImport : modelImports) {
                item = new HashMap<String, CallSite>();
                item.put("import", (CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
                newImports.add(item);
            }
        }
        if (!postponedModelImports.isEmpty()) {
            for (String modelImport : postponedModelImports) {
                item = new HashMap();
                item.put("import", (CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
                newImports.add(item);
            }
        }
        objs.setImports(newImports);
        return objs;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex.replace("\"", "\\\""));
            vendorExtensions.put("x-pattern", pattern.replace("\"", "\\\""));
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return name;
        }
        return "'" + name + "'";
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return value;
    }
}

