/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Sets;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.TemplateManager;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.AbstractDartCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.CommonTemplateContentLocator;
import org.openapitools.codegen.templating.GeneratorTemplateContentLocator;
import org.openapitools.codegen.templating.MustacheEngineAdapter;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartDioClientCodegen
extends AbstractDartCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(DartDioClientCodegen.class);
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String DATE_LIBRARY_CORE = "core";
    public static final String DATE_LIBRARY_TIME_MACHINE = "timemachine";
    public static final String DATE_LIBRARY_DEFAULT = "core";
    public static final String SERIALIZATION_LIBRARY_BUILT_VALUE = "built_value";
    public static final String SERIALIZATION_LIBRARY_JSON_SERIALIZABLE = "json_serializable";
    public static final String SERIALIZATION_LIBRARY_DEFAULT = "built_value";
    private static final String DIO_IMPORT = "package:dio/dio.dart";
    public static final String FINAL_PROPERTIES = "finalProperties";
    public static final String FINAL_PROPERTIES_DEFAULT_VALUE = "true";
    private static final String CLIENT_NAME = "clientName";
    private String dateLibrary;
    private String clientName;
    private TemplateManager templateManager;
    private final String kIsChild = "x-is-child";
    private final String kIsParent = "x-is-parent";
    private final String kIsPure = "x-is-pure";
    private final String kSelfOnlyProps = "x-self-only-props";
    private final String kHasSelfOnlyProps = "x-has-self-only-props";
    private final String kAncestorOnlyProps = "x-ancestor-only-props";
    private final String kHasAncestorOnlyProps = "x-has-ancestor-only-props";
    private final String kSelfAndAncestorOnlyProps = "x-self-and-ancestor-only-props";
    private final String kHasSelfAndAncestorOnlyProps = "x-has-self-and-ancestor-only-props";
    private final String kParentDiscriminator = "x-parent-discriminator";

    public DartDioClientCodegen() {
        this.modifyFeatureSet(features -> features.includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.Authorizations, ClientModificationFeature.UserAgent}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.Union, SchemaSupportFeature.Composite, SchemaSupportFeature.allOf, SchemaSupportFeature.oneOf, SchemaSupportFeature.anyOf}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.outputFolder = "generated-code/dart-dio";
        this.embeddedTemplateDir = "dart/libraries/dio";
        this.setTemplateDir(this.embeddedTemplateDir);
        this.supportedLibraries.put("built_value", "[DEFAULT] built_value");
        this.supportedLibraries.put(SERIALIZATION_LIBRARY_JSON_SERIALIZABLE, "[BETA] json_serializable");
        CliOption serializationLibrary = CliOption.newString("serializationLibrary", "Specify serialization library");
        serializationLibrary.setEnum(this.supportedLibraries);
        serializationLibrary.setDefault("built_value");
        this.cliOptions.add(serializationLibrary);
        CliOption dateOption = CliOption.newString(DATE_LIBRARY, "Specify Date library");
        dateOption.setDefault("core");
        CliOption finalProperties = CliOption.newBoolean(FINAL_PROPERTIES, "Whether properties are marked as final when using Json Serializable for serialization");
        finalProperties.setDefault(FINAL_PROPERTIES_DEFAULT_VALUE);
        this.cliOptions.add(finalProperties);
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put("core", "[DEFAULT] Dart core library (DateTime)");
        dateOptions.put(DATE_LIBRARY_TIME_MACHINE, "Time Machine is date and time library for Flutter, Web, and Server with support for timezones, calendars, cultures, formatting and parsing.");
        dateOption.setEnum(dateOptions);
        this.cliOptions.add(dateOption);
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getName() {
        return "dart-dio";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Dio client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (!this.additionalProperties.containsKey("serializationLibrary")) {
            this.additionalProperties.put("serializationLibrary", "built_value");
            this.LOGGER.debug("Serialization library not set, using default {}", (Object)"built_value");
        }
        this.setLibrary(this.additionalProperties.get("serializationLibrary").toString());
        if ("built_value".equals(this.library)) {
            this.setLegacyDiscriminatorBehavior(false);
        }
        if (!this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.additionalProperties.put(DATE_LIBRARY, "core");
            this.LOGGER.debug("Date library not set, using default {}", (Object)"core");
        }
        this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        if (!this.additionalProperties.containsKey(FINAL_PROPERTIES)) {
            this.additionalProperties.put(FINAL_PROPERTIES, Boolean.parseBoolean(FINAL_PROPERTIES_DEFAULT_VALUE));
            this.LOGGER.debug("finalProperties not set, using default {}", (Object)FINAL_PROPERTIES_DEFAULT_VALUE);
        } else {
            this.additionalProperties.put(FINAL_PROPERTIES, Boolean.parseBoolean(this.additionalProperties.get(FINAL_PROPERTIES).toString()));
        }
        if (!this.additionalProperties.containsKey(CLIENT_NAME)) {
            String name = StringUtils.camelize(this.pubName);
            this.additionalProperties.put(CLIENT_NAME, name);
            this.LOGGER.debug("Client name not set, using default {}", (Object)"core");
        }
        this.setClientName(this.additionalProperties.get(CLIENT_NAME).toString());
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", this.libPath, this.pubName + ".dart"));
        String srcFolder = this.libPath + this.sourceFolder;
        this.supportingFiles.add(new SupportingFile("api_client.mustache", srcFolder, "api.dart"));
        String authFolder = srcFolder + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/basic_auth.mustache", authFolder, "basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/bearer_auth.mustache", authFolder, "bearer_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/auth.mustache", authFolder, "auth.dart"));
        this.configureSerializationLibrary(srcFolder);
        this.configureDateLibrary(srcFolder);
    }

    private void configureSerializationLibrary(String srcFolder) {
        switch (this.library) {
            case "json_serializable": {
                this.additionalProperties.put("useJsonSerializable", FINAL_PROPERTIES_DEFAULT_VALUE);
                this.configureSerializationLibraryJsonSerializable(srcFolder);
                break;
            }
            default: {
                this.additionalProperties.put("useBuiltValue", FINAL_PROPERTIES_DEFAULT_VALUE);
                this.configureSerializationLibraryBuiltValue(srcFolder);
            }
        }
        TemplateManagerOptions templateManagerOptions = new TemplateManagerOptions(this.isEnableMinimalUpdate(), this.isSkipOverwrite());
        CommonTemplateContentLocator commonTemplateLocator = new CommonTemplateContentLocator();
        GeneratorTemplateContentLocator generatorTemplateLocator = new GeneratorTemplateContentLocator(this);
        this.templateManager = new TemplateManager(templateManagerOptions, this.getTemplatingEngine(), new TemplatePathLocator[]{generatorTemplateLocator, commonTemplateLocator});
        this.additionalProperties.put("includeLibraryTemplate", (fragment, writer) -> {
            MustacheEngineAdapter engine = (MustacheEngineAdapter)this.getTemplatingEngine();
            String templateFile = "serialization/" + this.library + "/" + fragment.execute() + ".mustache";
            Template tmpl = engine.getCompiler().withLoader(name -> engine.findTemplate(this.templateManager, name)).defaultValue("").compile(this.templateManager.getFullTemplateContents(templateFile));
            fragment.executeTemplate(tmpl, writer);
        });
    }

    private void configureSerializationLibraryBuiltValue(String srcFolder) {
        this.supportingFiles.add(new SupportingFile("serialization/built_value/serializers.mustache", srcFolder, "serializers.dart"));
        this.supportingFiles.add(new SupportingFile("serialization/built_value/api_util.mustache", srcFolder, "api_util.dart"));
        this.typeMapping.put("Array", "BuiltList");
        this.typeMapping.put("array", "BuiltList");
        this.typeMapping.put("List", "BuiltList");
        this.typeMapping.put("set", "BuiltSet");
        this.typeMapping.put("map", "BuiltMap");
        this.typeMapping.put("file", "Uint8List");
        this.typeMapping.put("binary", "Uint8List");
        this.typeMapping.put("object", "JsonObject");
        this.typeMapping.put("AnyType", "JsonObject");
        this.imports.put("BuiltList", "package:built_collection/built_collection.dart");
        this.imports.put("BuiltSet", "package:built_collection/built_collection.dart");
        this.imports.put("BuiltMap", "package:built_collection/built_collection.dart");
        this.imports.put("JsonObject", "package:built_value/json_object.dart");
        this.imports.put("Uint8List", "dart:typed_data");
        this.imports.put("MultipartFile", DIO_IMPORT);
    }

    private void configureSerializationLibraryJsonSerializable(String srcFolder) {
        this.supportingFiles.add(new SupportingFile("serialization/json_serializable/build.yaml.mustache", "", "build.yaml"));
        this.supportingFiles.add(new SupportingFile("serialization/json_serializable/deserialize.mustache", srcFolder, "deserialize.dart"));
        this.languageSpecificPrimitives.add("Object");
        this.imports.put("Uint8List", "dart:typed_data");
        this.imports.put("MultipartFile", DIO_IMPORT);
    }

    private void configureDateLibrary(String srcFolder) {
        switch (this.dateLibrary) {
            case "timemachine": {
                this.additionalProperties.put("useDateLibTimeMachine", FINAL_PROPERTIES_DEFAULT_VALUE);
                this.typeMapping.put("date", "OffsetDate");
                this.typeMapping.put("Date", "OffsetDate");
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("datetime", "OffsetDateTime");
                this.imports.put("OffsetDate", "package:time_machine/time_machine.dart");
                this.imports.put("OffsetDateTime", "package:time_machine/time_machine.dart");
                if (!"built_value".equals(this.library)) break;
                this.supportingFiles.add(new SupportingFile("serialization/built_value/offset_date_serializer.mustache", srcFolder, "local_date_serializer.dart"));
                break;
            }
            default: {
                this.additionalProperties.put("useDateLibCore", FINAL_PROPERTIES_DEFAULT_VALUE);
                if (!"built_value".equals(this.library)) break;
                this.typeMapping.put("date", "Date");
                this.typeMapping.put("Date", "Date");
                this.importMapping.put("Date", "package:" + this.pubName + "/" + this.sourceFolder + "/" + this.modelPackage() + "/date.dart");
                this.supportingFiles.add(new SupportingFile("serialization/built_value/date.mustache", srcFolder + File.separator + this.modelPackage(), "date.dart"));
                this.supportingFiles.add(new SupportingFile("serialization/built_value/date_serializer.mustache", srcFolder, "date_serializer.dart"));
            }
        }
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            if ("built_value".equals(this.library)) {
                if (ModelUtils.isArraySchema(schema)) {
                    if (ModelUtils.isSet(schema)) {
                        return "SetBuilder()";
                    }
                    return "ListBuilder()";
                }
                if (ModelUtils.isMapSchema(schema)) {
                    return "MapBuilder()";
                }
            }
            if (ModelUtils.isDateSchema(schema) || ModelUtils.isDateTimeSchema(schema)) {
                return null;
            }
            if (ModelUtils.isStringSchema(schema)) {
                return "'" + schema.getDefault().toString().replaceAll("'", "\\'") + "'";
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<ModelMap> models = objs.getModels();
        ProcessUtils.addIndexToProperties(models, 1);
        return objs;
    }

    private void getAncestors(CodegenModel cm, Map<String, CodegenModel> allModels, Set<String> accumulator) {
        Set<String> directParentNames = cm.allOf;
        if (directParentNames != null && !directParentNames.isEmpty()) {
            for (String directParentName : directParentNames) {
                if (!accumulator.add(directParentName)) continue;
                CodegenModel parent = allModels.get(directParentName);
                this.getAncestors(parent, allModels, accumulator);
            }
        }
    }

    private void syncRootTypesWithInnerVars(Map<String, ModelsMap> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (ModelsMap modelsEntries : objs.values()) {
            for (ModelMap modelsMap : modelsEntries.getModels()) {
                CodegenModel model = modelsMap.getModel();
                allModels.put(model.getClassname(), model);
            }
        }
        for (CodegenModel model : allModels.values()) {
            this.syncRootTypesWithInnerVars(allModels, model);
        }
    }

    private void syncRootTypesWithInnerVars(Map<String, CodegenModel> objs, CodegenModel model) {
        ArrayList allVars = new ArrayList();
        allVars.addAll((Collection)model.vendorExtensions.get("x-self-and-ancestor-only-props"));
        allVars.addAll((Collection)model.vendorExtensions.get("x-self-only-props"));
        allVars.addAll((Collection)model.vendorExtensions.get("x-ancestor-only-props"));
        for (CodegenProperty prop : allVars) {
            String type = prop.openApiType;
            if (!objs.containsKey(type)) continue;
            CodegenModel relatedModel = objs.get(type);
            prop.getVendorExtensions().put("x-is-parent", relatedModel.getVendorExtensions().get("x-is-parent"));
            prop.isEnum = relatedModel.isEnum;
        }
    }

    private void adaptToDartInheritance(Map<String, ModelsMap> objs) {
        Set allAncestors;
        CodegenModel cm;
        String key;
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (ModelsMap modelsEntries : objs.values()) {
            for (ModelMap modelMap : modelsEntries.getModels()) {
                CodegenModel model = modelMap.getModel();
                allModels.put(model.getClassname(), model);
            }
        }
        HashSet<String> allAncestorsForAllModelsFlat = new HashSet<String>();
        HashMap<String, HashSet<String>> allAncestorsForAllModels = new HashMap<String, HashSet<String>>();
        for (Map.Entry entry : allModels.entrySet()) {
            HashSet<String> allAncestors2 = new HashSet<String>();
            this.getAncestors((CodegenModel)entry.getValue(), allModels, allAncestors2);
            allAncestors2.remove(entry.getKey());
            allAncestorsForAllModels.put((String)entry.getKey(), allAncestors2);
            allAncestorsForAllModelsFlat.addAll(allAncestors2);
        }
        HashSet<String> allPureClasses = new HashSet<String>();
        for (Map.Entry cmEntry : allModels.entrySet()) {
            key = (String)cmEntry.getKey();
            cm = (CodegenModel)cmEntry.getValue();
            allAncestors = (Set)allAncestorsForAllModels.get(key);
            boolean isParent = allAncestorsForAllModelsFlat.contains(key);
            boolean isChild = !allAncestors.isEmpty();
            boolean isPure = !(isChild || cm.oneOf != null && !cm.oneOf.isEmpty() || cm.anyOf != null && !cm.anyOf.isEmpty());
            cm.vendorExtensions.put("x-is-child", isChild);
            cm.vendorExtensions.put("x-is-parent", isParent);
            cm.vendorExtensions.put("x-is-pure", isPure);
            if (!isParent && (cm.oneOf == null || cm.oneOf.isEmpty()) && cm.discriminator != null) {
                cm.vendorExtensions.put("x-parent-discriminator", cm.discriminator);
                cm.discriminator = null;
            }
            if (!isPure) continue;
            cm.vendorExtensions.put("x-self-only-props", new ArrayList<CodegenProperty>(cm.getVars()));
            cm.vendorExtensions.put("x-has-self-only-props", !cm.getVars().isEmpty());
            cm.vendorExtensions.put("x-ancestor-only-props", new ArrayList());
            cm.vendorExtensions.put("x-has-ancestor-only-props", false);
            cm.vendorExtensions.put("x-self-and-ancestor-only-props", new ArrayList<CodegenProperty>(cm.getVars()));
            cm.vendorExtensions.put("x-has-self-and-ancestor-only-props", !cm.getVars().isEmpty());
            allPureClasses.add(key);
        }
        for (Map.Entry cmEntry : allModels.entrySet()) {
            key = (String)cmEntry.getKey();
            cm = (CodegenModel)cmEntry.getValue();
            if (allPureClasses.contains(key)) continue;
            allAncestors = (Set)allAncestorsForAllModels.get(key);
            HashSet<String> compositeProperties = new HashSet<String>();
            HashSet compositeModelNames = new HashSet();
            compositeModelNames.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{cm.oneOf, new HashSet()}));
            compositeModelNames.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{cm.anyOf, new HashSet()}));
            compositeModelNames.addAll(allAncestors);
            for (String compositeModelName : compositeModelNames) {
                CodegenModel model = (CodegenModel)allModels.get(compositeModelName);
                if (model == null) continue;
                List allVars = (List)ObjectUtils.firstNonNull((Object[])new List[]{model.getAllVars(), new ArrayList()});
                Iterator iterator = allVars.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty prop = (CodegenProperty)iterator.next();
                    compositeProperties.add(prop.getName());
                }
            }
            HashMap<String, CodegenProperty> selfOnlyProperties = new HashMap<String, CodegenProperty>();
            HashMap<String, CodegenProperty> ancestorOnlyProperties = new HashMap<String, CodegenProperty>();
            HashMap<String, CodegenProperty> selfAndAncestorOnlyProperties = new HashMap<String, CodegenProperty>();
            for (String ancestorKey : allAncestors) {
                CodegenModel ancestorCM = (CodegenModel)allModels.get(ancestorKey);
                for (CodegenProperty prop : ancestorCM.getVars()) {
                    ancestorOnlyProperties.put(prop.getName(), prop);
                }
            }
            for (CodegenProperty p : cm.getVars()) {
                p.isInherited = ancestorOnlyProperties.containsKey(p.getName());
                if (p.isInherited || compositeProperties.contains(p.getName())) continue;
                selfOnlyProperties.put(p.getName(), p);
            }
            selfAndAncestorOnlyProperties.putAll(selfOnlyProperties);
            selfAndAncestorOnlyProperties.putAll(ancestorOnlyProperties);
            cm.vendorExtensions.put("x-self-only-props", new ArrayList(selfOnlyProperties.values()));
            cm.vendorExtensions.put("x-has-self-only-props", !selfOnlyProperties.isEmpty());
            cm.vendorExtensions.put("x-ancestor-only-props", new ArrayList(ancestorOnlyProperties.values()));
            cm.vendorExtensions.put("x-has-ancestor-only-props", !ancestorOnlyProperties.isEmpty());
            cm.vendorExtensions.put("x-self-and-ancestor-only-props", new ArrayList(selfAndAncestorOnlyProperties.values()));
            cm.vendorExtensions.put("x-has-self-and-ancestor-only-props", !selfAndAncestorOnlyProperties.isEmpty());
            HashSet<String> interfaceImports = new HashSet<String>();
            interfaceImports.addAll(cm.allOf);
            interfaceImports.addAll(cm.oneOf);
            interfaceImports.addAll(cm.anyOf);
            cm.imports.addAll(this.rewriteImports(interfaceImports, true));
        }
    }

    @Override
    protected CodegenDiscriminator createDiscriminator(String schemaName, Schema schema) {
        Map originalMapping;
        CodegenDiscriminator sub = super.createDiscriminator(schemaName, schema);
        Discriminator originalDiscriminator = schema.getDiscriminator();
        if (originalDiscriminator != null && (originalMapping = originalDiscriminator.getMapping()) != null && !originalMapping.isEmpty()) {
            for (CodegenDiscriminator.MappedModel currentMappings : new HashSet<CodegenDiscriminator.MappedModel>(sub.getMappedModels())) {
                if (originalMapping.containsKey(currentMappings.getMappingName())) continue;
                sub.getMapping().remove(currentMappings.getMappingName());
                sub.getMappedModels().remove(currentMappings);
            }
        }
        return sub;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        if ("built_value".equals(this.library)) {
            this.adaptToDartInheritance(objs);
            this.syncRootTypesWithInnerVars(objs);
        }
        for (ModelsMap entry : objs.values()) {
            for (ModelMap mo : entry.getModels()) {
                CodegenModel cm = mo.getModel();
                cm.imports = this.rewriteImports(cm.imports, true);
                cm.vendorExtensions.put("x-has-vars", !cm.vars.isEmpty());
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("built_value".equals(this.library)) {
            CodegenProperty items;
            if (property.isEnum && property.getComposedSchemas() == null) {
                model.imports.add("BuiltSet");
            }
            if (property.isContainer && (items = property.items).getAdditionalProperties() != null) {
                this.addBuiltValueSerializer(new BuiltValueSerializer(items.isArray, items.getUniqueItems(), items.isMap, items.items.isNullable, items.getAdditionalProperties().dataType));
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        HashSet<Object> resultImports = new HashSet<Object>();
        for (CodegenOperation op : operationList) {
            for (CodegenParameter param2 : op.allParams) {
                if ((!op.isMultipart || !param2.isFormParam) && !param2.isBodyParam || !param2.isBinary && !param2.isFile) continue;
                param2.dataType = param2.dataType.replace("Uint8List", "MultipartFile");
                param2.baseType = param2.baseType.replace("Uint8List", "MultipartFile");
                op.imports.add("MultipartFile");
                if (!"built_value".equals(this.library)) continue;
                boolean skipFormModel = Boolean.parseBoolean(GlobalSettings.getProperty("skipFormModel", FINAL_PROPERTIES_DEFAULT_VALUE));
                if (!param2.isFormParam || !param2.isContainer || skipFormModel) continue;
                this.addBuiltValueSerializerImport("Uint8List");
            }
            if (op.allParams.stream().noneMatch(param -> param.dataType.equals("Uint8List")) && op.responses.stream().filter(response -> response.dataType != null).noneMatch(response -> response.dataType.equals("Uint8List"))) {
                op.imports.remove("Uint8List");
            }
            resultImports.addAll(this.rewriteImports(op.imports, false));
            if ("built_value".equals(this.library)) {
                for (CodegenParameter param2 : op.allParams) {
                    if (!param2.isContainer || param2.isBinary || param2.isFile) continue;
                    this.addBuiltValueSerializer(new BuiltValueSerializer(param2.isArray, param2.uniqueItems, param2.isMap, param2.items.isNullable, param2.baseType));
                }
            }
            if ("built_value".equals(this.library) && (op.getHasFormParams() || op.getHasQueryParams() || op.getHasPathParams())) {
                resultImports.add("package:" + this.pubName + "/" + this.sourceFolder + "/api_util.dart");
            }
            if (op.returnContainer == null || op.isResponseBinary || op.isResponseFile) continue;
            this.addBuiltValueSerializer(new BuiltValueSerializer(Objects.equals("array", op.returnContainer) || Objects.equals("set", op.returnContainer), op.uniqueItems, Objects.equals("map", op.returnContainer), false, op.returnBaseType));
        }
        objs.put("imports", resultImports.stream().sorted().collect(Collectors.toList()));
        return objs;
    }

    private void addBuiltValueSerializerImport(String type) {
        this.additionalProperties.compute("builtValueSerializerImports", (k, v) -> {
            Set<String> imports = v == null ? Sets.newHashSet() : (Set)v;
            imports.addAll(this.rewriteImports(Sets.newHashSet((Object[])new String[]{type}), true));
            return imports;
        });
    }

    private void addBuiltValueSerializer(BuiltValueSerializer serializer) {
        this.additionalProperties.compute("builtValueSerializers", (k, v) -> {
            Set<BuiltValueSerializer> serializers = v == null ? Sets.newHashSet() : (Set)v;
            serializers.add(serializer);
            return serializers;
        });
    }

    private Set<String> rewriteImports(Set<String> originalImports, boolean isModel) {
        HashSet resultImports = Sets.newHashSet();
        for (String modelImport : originalImports) {
            if (modelImport.startsWith("BuiltList", 0)) {
                modelImport = "BuiltList";
            } else if (modelImport.startsWith("BuiltSet", 0)) {
                modelImport = "BuiltSet";
            } else if (modelImport.startsWith("BuiltMap", 0)) {
                modelImport = "BuiltMap";
            }
            if (this.imports.containsKey(modelImport)) {
                String i = (String)this.imports.get(modelImport);
                if (Objects.equals(i, DIO_IMPORT) && !isModel) continue;
                resultImports.add(i);
                continue;
            }
            if (this.importMapping().containsKey(modelImport)) {
                resultImports.add(this.importMapping().get(modelImport));
                continue;
            }
            if (modelImport.startsWith("dart:")) {
                resultImports.add(modelImport);
                continue;
            }
            if (modelImport.startsWith("package:")) {
                resultImports.add(modelImport);
                continue;
            }
            resultImports.add("package:" + this.pubName + "/" + this.sourceFolder + "/" + this.modelPackage() + "/" + StringUtils.underscore(modelImport) + ".dart");
        }
        return resultImports;
    }

    static class BuiltValueSerializer {
        final boolean isArray;
        final boolean uniqueItems;
        final boolean isMap;
        final boolean isNullable;
        final String dataType;

        private BuiltValueSerializer(boolean isArray, boolean uniqueItems, boolean isMap, boolean isNullable, String dataType) {
            this.isArray = isArray;
            this.uniqueItems = uniqueItems;
            this.isMap = isMap;
            this.isNullable = isNullable;
            this.dataType = dataType;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public boolean isUniqueItems() {
            return this.uniqueItems;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public String getDataType() {
            return this.dataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuiltValueSerializer that = (BuiltValueSerializer)o;
            return this.isArray == that.isArray && this.uniqueItems == that.uniqueItems && this.isMap == that.isMap && this.isNullable == that.isNullable && this.dataType.equals(that.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.isArray, this.uniqueItems, this.isMap, this.isNullable, this.dataType);
        }
    }
}

