/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.CaseFormat;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.languages.features.GzipFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.CaseFormatLambda;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
GzipFeatures {
    static final String MEDIA_TYPE = "mediaType";
    private final Logger LOGGER = LoggerFactory.getLogger(JavaClientCodegen.class);
    public static final String USE_RX_JAVA2 = "useRxJava2";
    public static final String USE_RX_JAVA3 = "useRxJava3";
    public static final String DO_NOT_USE_RX = "doNotUseRx";
    public static final String USE_PLAY_WS = "usePlayWS";
    public static final String ASYNC_NATIVE = "asyncNative";
    public static final String CONFIG_KEY = "configKey";
    public static final String PARCELABLE_MODEL = "parcelableModel";
    public static final String USE_RUNTIME_EXCEPTION = "useRuntimeException";
    public static final String USE_REFLECTION_EQUALS_HASHCODE = "useReflectionEqualsHashCode";
    public static final String CASE_INSENSITIVE_RESPONSE_HEADERS = "caseInsensitiveResponseHeaders";
    public static final String MICROPROFILE_FRAMEWORK = "microprofileFramework";
    public static final String MICROPROFILE_MUTINY = "microprofileMutiny";
    public static final String USE_ABSTRACTION_FOR_FILES = "useAbstractionForFiles";
    public static final String DYNAMIC_OPERATIONS = "dynamicOperations";
    public static final String SUPPORT_STREAMING = "supportStreaming";
    public static final String SUPPORT_URL_QUERY = "supportUrlQuery";
    public static final String GRADLE_PROPERTIES = "gradleProperties";
    public static final String ERROR_OBJECT_TYPE = "errorObjectType";
    public static final String FEIGN = "feign";
    public static final String GOOGLE_API_CLIENT = "google-api-client";
    public static final String JERSEY1 = "jersey1";
    public static final String JERSEY2 = "jersey2";
    public static final String JERSEY3 = "jersey3";
    public static final String NATIVE = "native";
    public static final String OKHTTP_GSON = "okhttp-gson";
    public static final String RESTEASY = "resteasy";
    public static final String RESTTEMPLATE = "resttemplate";
    public static final String WEBCLIENT = "webclient";
    public static final String REST_ASSURED = "rest-assured";
    public static final String RETROFIT_2 = "retrofit2";
    public static final String VERTX = "vertx";
    public static final String MICROPROFILE = "microprofile";
    public static final String APACHE = "apache-httpclient";
    public static final String MICROPROFILE_REST_CLIENT_VERSION = "microprofileRestClientVersion";
    public static final String MICROPROFILE_REST_CLIENT_DEFAULT_VERSION = "2.0";
    public static final String MICROPROFILE_REST_CLIENT_DEFAULT_ROOT_PACKAGE = "javax";
    public static final String MICROPROFILE_DEFAULT = "default";
    public static final String MICROPROFILE_KUMULUZEE = "kumuluzee";
    public static final String WEBCLIENT_BLOCKING_OPERATIONS = "webclientBlockingOperations";
    public static final String USE_ENUM_CASE_INSENSITIVE = "useEnumCaseInsensitive";
    public static final String SERIALIZATION_LIBRARY_GSON = "gson";
    public static final String SERIALIZATION_LIBRARY_JACKSON = "jackson";
    public static final String SERIALIZATION_LIBRARY_JSONB = "jsonb";
    public static final String GENERATE_CLIENT_AS_BEAN = "generateClientAsBean";
    protected String gradleWrapperPackage = "gradle.wrapper";
    protected boolean useRxJava = false;
    protected boolean useRxJava2 = false;
    protected boolean useRxJava3 = false;
    protected boolean doNotUseRx = true;
    protected boolean usePlayWS = false;
    protected String microprofileFramework = "default";
    protected boolean microprofileMutiny = false;
    protected String configKey = null;
    protected boolean asyncNative = false;
    protected boolean parcelableModel = false;
    protected boolean useBeanValidation = false;
    protected boolean performBeanValidation = false;
    protected boolean useGzipFeature = false;
    protected boolean useRuntimeException = false;
    protected boolean useReflectionEqualsHashCode = false;
    protected boolean caseInsensitiveResponseHeaders = false;
    protected boolean useAbstractionForFiles = false;
    protected boolean dynamicOperations = false;
    protected boolean supportStreaming = false;
    protected boolean withAWSV4Signature = false;
    protected String gradleProperties;
    protected String errorObjectType;
    protected String authFolder;
    protected String serializationLibrary = null;
    protected boolean useOneOfDiscriminatorLookup = false;
    protected String rootJavaEEPackage;
    protected Map<String, MpRestClientVersion> mpRestClientVersions = new HashMap<String, MpRestClientVersion>();
    protected boolean useSingleRequestParameter = false;
    protected boolean webclientBlockingOperations = false;
    protected boolean generateClientAsBean = false;
    protected boolean useEnumCaseInsensitive = false;

    @Override
    public DocumentationProviderFeatures.DocumentationProvider defaultDocumentationProvider() {
        return DocumentationProviderFeatures.DocumentationProvider.SOURCE;
    }

    @Override
    public List<DocumentationProviderFeatures.DocumentationProvider> supportedDocumentationProvider() {
        ArrayList<DocumentationProviderFeatures.DocumentationProvider> documentationProviders = new ArrayList<DocumentationProviderFeatures.DocumentationProvider>();
        documentationProviders.add(DocumentationProviderFeatures.DocumentationProvider.NONE);
        documentationProviders.add(DocumentationProviderFeatures.DocumentationProvider.SOURCE);
        return documentationProviders;
    }

    @Override
    public List<DocumentationProviderFeatures.AnnotationLibrary> supportedAnnotationLibraries() {
        ArrayList<DocumentationProviderFeatures.AnnotationLibrary> annotationLibraries = new ArrayList<DocumentationProviderFeatures.AnnotationLibrary>();
        annotationLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.NONE);
        annotationLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1);
        annotationLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2);
        return annotationLibraries;
    }

    public JavaClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.SignatureAuth}));
        this.outputFolder = "generated-code" + File.separator + "java";
        this.templateDir = "Java";
        this.embeddedTemplateDir = "Java";
        this.invokerPackage = "org.openapitools.client";
        this.artifactId = "openapi-java-client";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.rootJavaEEPackage = MICROPROFILE_REST_CLIENT_DEFAULT_ROOT_PACKAGE;
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.modelTestTemplateFiles.put("model_test.mustache", ".java");
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA2, "Whether to use the RxJava2 adapter with the retrofit2 library. IMPORTANT: This option has been deprecated."));
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA3, "Whether to use the RxJava3 adapter with the retrofit2 library. IMPORTANT: This option has been deprecated."));
        this.cliOptions.add(CliOption.newBoolean(PARCELABLE_MODEL, "Whether to generate models for Android that implement Parcelable with the okhttp-gson library."));
        this.cliOptions.add(CliOption.newBoolean(USE_PLAY_WS, "Use Play! Async HTTP client (Play WS API)"));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Perform BeanValidation"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeature", "Send gzip-encoded requests"));
        this.cliOptions.add(CliOption.newBoolean(USE_RUNTIME_EXCEPTION, "Use RuntimeException instead of Exception. Only jersey, jersey2, jersey3, okhttp-gson, vertx, microprofile support this option."));
        this.cliOptions.add(CliOption.newBoolean(ASYNC_NATIVE, "If true, async handlers will be used, instead of the sync version"));
        this.cliOptions.add(CliOption.newBoolean(USE_REFLECTION_EQUALS_HASHCODE, "Use org.apache.commons.lang3.builder for equals and hashCode in the models. WARNING: This will fail under a security manager, unless the appropriate permissions are set up correctly and also there's potential performance impact."));
        this.cliOptions.add(CliOption.newBoolean(CASE_INSENSITIVE_RESPONSE_HEADERS, "Make API response's headers case-insensitive. Available on okhttp-gson, jersey2 libraries"));
        this.cliOptions.add(CliOption.newString(MICROPROFILE_FRAMEWORK, "Framework for microprofile. Possible values \"kumuluzee\""));
        this.cliOptions.add(CliOption.newString(MICROPROFILE_MUTINY, "Whether to use async types for microprofile (currently only Smallrye Mutiny is supported)."));
        this.cliOptions.add(CliOption.newBoolean(USE_ABSTRACTION_FOR_FILES, "Use alternative types instead of java.io.File to allow passing bytes without a file on disk. Available on resttemplate, webclient, libraries"));
        this.cliOptions.add(CliOption.newBoolean(DYNAMIC_OPERATIONS, "Generate operations dynamically at runtime from an OAS", this.dynamicOperations));
        this.cliOptions.add(CliOption.newBoolean(SUPPORT_STREAMING, "Support streaming endpoint (beta)", this.supportStreaming));
        this.cliOptions.add(CliOption.newBoolean("withAWSV4Signature", "whether to include AWS v4 signature support (only available for okhttp-gson library)", this.withAWSV4Signature));
        this.cliOptions.add(CliOption.newString(GRADLE_PROPERTIES, "Append additional Gradle properties to the gradle.properties file"));
        this.cliOptions.add(CliOption.newString(ERROR_OBJECT_TYPE, "Error Object type. (This option is for okhttp-gson-next-gen only)"));
        this.cliOptions.add(CliOption.newString(CONFIG_KEY, "Config key in @RegisterRestClient. Default to none. Only `microprofile` supports this option."));
        this.cliOptions.add(CliOption.newBoolean("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped. Only jersey2, jersey3, native, okhttp-gson support this option."));
        this.cliOptions.add(CliOption.newString(MICROPROFILE_REST_CLIENT_VERSION, "Version of MicroProfile Rest Client API."));
        this.cliOptions.add(CliOption.newBoolean("useSingleRequestParameter", "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter. ONLY jersey2, jersey3, okhttp-gson support this option."));
        this.cliOptions.add(CliOption.newBoolean(WEBCLIENT_BLOCKING_OPERATIONS, "Making all WebClient operations blocking(sync). Note that if on operation 'x-webclient-blocking: false' then such operation won't be sync", this.webclientBlockingOperations));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_CLIENT_AS_BEAN, "For resttemplate, configure whether to create `ApiClient.java` and Apis clients as bean (with `@Component` annotation).", this.generateClientAsBean));
        this.cliOptions.add(CliOption.newBoolean(SUPPORT_URL_QUERY, "Generate toUrlQueryString in POJO (default to true). Available on `native`, `apache-httpclient` libraries."));
        this.cliOptions.add(CliOption.newBoolean(USE_ENUM_CASE_INSENSITIVE, "Use `equalsIgnoreCase` when String for enum comparison", this.useEnumCaseInsensitive));
        this.supportedLibraries.put(JERSEY1, "HTTP client: Jersey client 1.19.x. JSON processing: Jackson 2.9.x. Enable gzip request encoding using '-DuseGzipFeature=true'. IMPORTANT NOTE: jersey 1.x is no longer actively maintained so please upgrade to 'jersey3' or other HTTP libraries instead.");
        this.supportedLibraries.put(JERSEY2, "HTTP client: Jersey client 2.25.1. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(JERSEY3, "HTTP client: Jersey client 3.x. JSON processing: Jackson 2.x");
        this.supportedLibraries.put(FEIGN, "HTTP client: OpenFeign 10.x. JSON processing: Jackson 2.9.x. or Gson 2.x");
        this.supportedLibraries.put(OKHTTP_GSON, "[DEFAULT] HTTP client: OkHttp 3.x. JSON processing: Gson 2.8.x. Enable Parcelable models on Android using '-DparcelableModel=true'. Enable gzip request encoding using '-DuseGzipFeature=true'.");
        this.supportedLibraries.put(RETROFIT_2, "HTTP client: OkHttp 3.x. JSON processing: Gson 2.x (Retrofit 2.3.0). Enable the RxJava adapter using '-DuseRxJava[2/3]=true'. (RxJava 1.x or 2.x or 3.x)");
        this.supportedLibraries.put(RESTTEMPLATE, "HTTP client: Spring RestTemplate 4.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(WEBCLIENT, "HTTP client: Spring WebClient 5.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(RESTEASY, "HTTP client: Resteasy client 3.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(VERTX, "HTTP client: VertX client 3.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(GOOGLE_API_CLIENT, "HTTP client: Google API client 1.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(REST_ASSURED, "HTTP client: rest-assured : 4.x. JSON processing: Gson 2.x or Jackson 2.10.x. Only for Java 8");
        this.supportedLibraries.put(NATIVE, "HTTP client: Java native HttpClient. JSON processing: Jackson 2.9.x. Only for Java11+");
        this.supportedLibraries.put(MICROPROFILE, "HTTP client: Microprofile client 1.x. JSON processing: JSON-B or Jackson 2.9.x");
        this.supportedLibraries.put(APACHE, "HTTP client: Apache httpclient 5.x");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(OKHTTP_GSON);
        this.cliOptions.add(libraryOption);
        this.setLibrary(OKHTTP_GSON);
        CliOption serializationLibrary = new CliOption("serializationLibrary", "Serialization library, default depends on value of the option library");
        HashMap<String, String> serializationOptions = new HashMap<String, String>();
        serializationOptions.put(SERIALIZATION_LIBRARY_GSON, "Use Gson as serialization library");
        serializationOptions.put(SERIALIZATION_LIBRARY_JACKSON, "Use Jackson as serialization library");
        serializationOptions.put(SERIALIZATION_LIBRARY_JSONB, "Use JSON-B as serialization library");
        serializationLibrary.setEnum(serializationOptions);
        this.cliOptions.add(serializationLibrary);
        this.setLegacyDiscriminatorBehavior(false);
        this.initMpRestClientVersionToRootPackage();
    }

    private void initMpRestClientVersionToRootPackage() {
        this.mpRestClientVersions.put("1.4.1", new MpRestClientVersion(MICROPROFILE_REST_CLIENT_DEFAULT_ROOT_PACKAGE, "pom.mustache"));
        this.mpRestClientVersions.put(MICROPROFILE_REST_CLIENT_DEFAULT_VERSION, new MpRestClientVersion(MICROPROFILE_REST_CLIENT_DEFAULT_ROOT_PACKAGE, "pom.mustache"));
        this.mpRestClientVersions.put("3.0", new MpRestClientVersion("jakarta", "pom_3.0.mustache"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public String getHelp() {
        return "Generates a Java client library (HTTP lib: Jersey (1.x, 2.x), Retrofit (2.x), OpenFeign (10.x) and more.";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        if (MICROPROFILE.equals(this.getLibrary())) {
            co.subresourceOperation = !co.path.isEmpty();
        }
    }

    @Override
    public void processOpts() {
        String mpRestClientVersion;
        if (WEBCLIENT.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary())) {
            this.dateLibrary = "java8";
        } else if (MICROPROFILE.equals(this.getLibrary())) {
            this.dateLibrary = "legacy";
        }
        super.processOpts();
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
        if (this.additionalProperties.containsKey(USE_RX_JAVA2) && this.additionalProperties.containsKey(USE_RX_JAVA3)) {
            this.LOGGER.warn("You specified all RxJava versions 2 and 3 but they are mutually exclusive. Defaulting to v3.");
            this.setUseRxJava3(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA3).toString()));
        } else if (this.additionalProperties.containsKey(USE_RX_JAVA2) && this.additionalProperties.containsKey(USE_RX_JAVA3)) {
            this.LOGGER.warn("You specified both RxJava versions 2 and 3 but they are mutually exclusive. Defaulting to v3.");
            this.setUseRxJava3(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA3).toString()));
        } else {
            if (this.additionalProperties.containsKey(USE_RX_JAVA2)) {
                this.setUseRxJava2(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA2).toString()));
            }
            if (this.additionalProperties.containsKey(USE_RX_JAVA3)) {
                this.setUseRxJava3(Boolean.parseBoolean(this.additionalProperties.get(USE_RX_JAVA3).toString()));
            }
        }
        if (this.additionalProperties.containsKey("useSingleRequestParameter")) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean("useSingleRequestParameter"));
        }
        this.writePropertyBack("useSingleRequestParameter", this.getUseSingleRequestParameter());
        if (!(this.useRxJava || this.useRxJava2 || this.useRxJava3)) {
            this.additionalProperties.put(DO_NOT_USE_RX, true);
        }
        if (this.additionalProperties.containsKey(USE_PLAY_WS)) {
            this.setUsePlayWS(Boolean.parseBoolean(this.additionalProperties.get(USE_PLAY_WS).toString()));
        }
        this.additionalProperties.put(USE_PLAY_WS, this.usePlayWS);
        if (this.additionalProperties.containsKey(MICROPROFILE_FRAMEWORK)) {
            if (!MICROPROFILE_KUMULUZEE.equals(this.microprofileFramework)) {
                throw new RuntimeException("Invalid microprofileFramework '" + this.microprofileFramework + "'. Must be 'kumuluzee' or none.");
            }
            this.setMicroprofileFramework(this.additionalProperties.get(MICROPROFILE_FRAMEWORK).toString());
        }
        this.additionalProperties.put(MICROPROFILE_FRAMEWORK, this.microprofileFramework);
        if (this.additionalProperties.containsKey(MICROPROFILE_MUTINY)) {
            this.setMicroprofileMutiny(this.convertPropertyToBooleanAndWriteBack(MICROPROFILE_MUTINY));
        }
        if (!this.additionalProperties.containsKey(MICROPROFILE_REST_CLIENT_VERSION)) {
            this.additionalProperties.put(MICROPROFILE_REST_CLIENT_VERSION, MICROPROFILE_REST_CLIENT_DEFAULT_VERSION);
        } else {
            mpRestClientVersion = (String)this.additionalProperties.get(MICROPROFILE_REST_CLIENT_VERSION);
            if (!this.mpRestClientVersions.containsKey(mpRestClientVersion)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Version %s of MicroProfile Rest Client is not supported or incorrect. Supported versions are %s", mpRestClientVersion, String.join((CharSequence)", ", this.mpRestClientVersions.keySet())));
            }
        }
        if (!this.additionalProperties.containsKey("rootJavaEEPackage")) {
            mpRestClientVersion = (String)this.additionalProperties.get(MICROPROFILE_REST_CLIENT_VERSION);
            if (this.mpRestClientVersions.containsKey(mpRestClientVersion)) {
                this.rootJavaEEPackage = this.mpRestClientVersions.get((Object)mpRestClientVersion).rootPackage;
            }
            this.additionalProperties.put("rootJavaEEPackage", this.rootJavaEEPackage);
        }
        if (this.additionalProperties.containsKey(CONFIG_KEY)) {
            this.setConfigKey(this.additionalProperties.get(CONFIG_KEY).toString());
        }
        if (this.additionalProperties.containsKey(ASYNC_NATIVE)) {
            this.setAsyncNative(this.convertPropertyToBooleanAndWriteBack(ASYNC_NATIVE));
        }
        if (this.additionalProperties.containsKey(PARCELABLE_MODEL)) {
            this.setParcelableModel(Boolean.parseBoolean(this.additionalProperties.get(PARCELABLE_MODEL).toString()));
        }
        this.additionalProperties.put(PARCELABLE_MODEL, this.parcelableModel);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBooleanAndWriteBack("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("performBeanValidation")) {
            this.setPerformBeanValidation(this.convertPropertyToBooleanAndWriteBack("performBeanValidation"));
        }
        if (this.additionalProperties.containsKey("useGzipFeature")) {
            this.setUseGzipFeature(this.convertPropertyToBooleanAndWriteBack("useGzipFeature"));
        }
        if (this.additionalProperties.containsKey(USE_RUNTIME_EXCEPTION)) {
            this.setUseRuntimeException(this.convertPropertyToBooleanAndWriteBack(USE_RUNTIME_EXCEPTION));
        }
        if (this.additionalProperties.containsKey(USE_REFLECTION_EQUALS_HASHCODE)) {
            this.setUseReflectionEqualsHashCode(this.convertPropertyToBooleanAndWriteBack(USE_REFLECTION_EQUALS_HASHCODE));
        }
        if (this.additionalProperties.containsKey(CASE_INSENSITIVE_RESPONSE_HEADERS)) {
            this.setUseReflectionEqualsHashCode(this.convertPropertyToBooleanAndWriteBack(CASE_INSENSITIVE_RESPONSE_HEADERS));
        }
        if (this.additionalProperties.containsKey(USE_ABSTRACTION_FOR_FILES)) {
            this.setUseAbstractionForFiles(this.convertPropertyToBooleanAndWriteBack(USE_ABSTRACTION_FOR_FILES));
        }
        if (this.additionalProperties.containsKey(DYNAMIC_OPERATIONS)) {
            this.setDynamicOperations(Boolean.parseBoolean(this.additionalProperties.get(DYNAMIC_OPERATIONS).toString()));
        }
        this.additionalProperties.put(DYNAMIC_OPERATIONS, this.dynamicOperations);
        if (this.additionalProperties.containsKey(SUPPORT_STREAMING)) {
            this.setSupportStreaming(Boolean.parseBoolean(this.additionalProperties.get(SUPPORT_STREAMING).toString()));
        }
        this.additionalProperties.put(SUPPORT_STREAMING, this.supportStreaming);
        if (this.additionalProperties.containsKey("withAWSV4Signature")) {
            this.setWithAWSV4Signature(Boolean.parseBoolean(this.additionalProperties.get("withAWSV4Signature").toString()));
        }
        this.additionalProperties.put("withAWSV4Signature", this.withAWSV4Signature);
        if (this.additionalProperties.containsKey(GRADLE_PROPERTIES)) {
            this.setGradleProperties(this.additionalProperties.get(GRADLE_PROPERTIES).toString());
        }
        this.additionalProperties.put(GRADLE_PROPERTIES, this.gradleProperties);
        if (this.additionalProperties.containsKey(ERROR_OBJECT_TYPE)) {
            this.setErrorObjectType(this.additionalProperties.get(ERROR_OBJECT_TYPE).toString());
        }
        this.additionalProperties.put(ERROR_OBJECT_TYPE, this.errorObjectType);
        if (this.additionalProperties.containsKey(WEBCLIENT_BLOCKING_OPERATIONS)) {
            this.webclientBlockingOperations = Boolean.parseBoolean(this.additionalProperties.get(WEBCLIENT_BLOCKING_OPERATIONS).toString());
        }
        if (!this.additionalProperties.containsKey(SUPPORT_URL_QUERY)) {
            if (this.isLibrary(NATIVE) || this.isLibrary(APACHE)) {
                this.additionalProperties.put(SUPPORT_URL_QUERY, true);
            }
        } else {
            this.additionalProperties.put(SUPPORT_URL_QUERY, Boolean.parseBoolean(this.additionalProperties.get(SUPPORT_URL_QUERY).toString()));
        }
        if (this.additionalProperties.containsKey(GENERATE_CLIENT_AS_BEAN)) {
            this.setGenerateClientAsBean(this.convertPropertyToBooleanAndWriteBack(GENERATE_CLIENT_AS_BEAN));
        }
        if (this.additionalProperties.containsKey(USE_ENUM_CASE_INSENSITIVE)) {
            this.setUseEnumCaseInsensitive(Boolean.parseBoolean(this.additionalProperties.get(USE_ENUM_CASE_INSENSITIVE).toString()));
        }
        this.writePropertyBack(USE_ENUM_CASE_INSENSITIVE, this.useEnumCaseInsensitive);
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage).replace(".", "/");
        String modelsFolder = (this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
        this.authFolder = (this.sourceFolder + "/" + this.invokerPackage + ".auth").replace(".", "/");
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("gradle.properties.mustache", "", "gradle.properties").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", invokerFolder, "ApiClient.java"));
        this.supportingFiles.add(new SupportingFile("ServerConfiguration.mustache", invokerFolder, "ServerConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("ServerVariable.mustache", invokerFolder, "ServerVariable.java"));
        this.supportingFiles.add(new SupportingFile("maven.yml.mustache", ".github/workflows", "maven.yml"));
        if (this.dynamicOperations) {
            this.supportingFiles.add(new SupportingFile("openapi.mustache", this.projectFolder + "/resources/openapi", "openapi.yaml"));
            this.supportingFiles.add(new SupportingFile("apiOperation.mustache", invokerFolder, "ApiOperation.java"));
        } else {
            this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        }
        if (this.additionalProperties.containsKey("jsr310") && (this.isLibrary(WEBCLIENT) || this.isLibrary(VERTX) || this.isLibrary(RESTTEMPLATE) || this.isLibrary(RESTEASY) || this.isLibrary(MICROPROFILE) || this.isLibrary(JERSEY1) || this.isLibrary(JERSEY2) || this.isLibrary(JERSEY3) || this.isLibrary(APACHE))) {
            this.supportingFiles.add(new SupportingFile("JavaTimeFormatter.mustache", invokerFolder, "JavaTimeFormatter.java"));
        }
        if (!(RESTTEMPLATE.equals(this.getLibrary()) || this.isLibrary(REST_ASSURED) || this.isLibrary(NATIVE) || this.isLibrary(MICROPROFILE))) {
            this.supportingFiles.add(new SupportingFile("StringUtil.mustache", invokerFolder, "StringUtil.java"));
        }
        if (!(this.isLibrary(GOOGLE_API_CLIENT) || this.isLibrary(REST_ASSURED) || this.isLibrary(NATIVE) || this.isLibrary(MICROPROFILE))) {
            this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.mustache", this.authFolder, "HttpBasicAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/HttpBearerAuth.mustache", this.authFolder, "HttpBearerAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.mustache", this.authFolder, "ApiKeyAuth.java"));
            if (OKHTTP_GSON.equals(this.getLibrary()) && this.withAWSV4Signature) {
                this.supportingFiles.add(new SupportingFile("auth/AWS4Auth.mustache", this.authFolder, "AWS4Auth.java"));
            }
        }
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.jar"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.performBeanValidation) {
            this.supportingFiles.add(new SupportingFile("BeanValidationException.mustache", invokerFolder, "BeanValidationException.java"));
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary(this.additionalProperties.get("serializationLibrary").toString());
        }
        if (FEIGN.equals(this.getLibrary())) {
            this.modelDocTemplateFiles.remove("model_doc.mustache");
            this.apiDocTemplateFiles.remove("api_doc.mustache");
            this.supportingFiles.add(new SupportingFile("model/ApiResponse.mustache", modelsFolder, "ApiResponse.java"));
            this.reservedWords.remove("file");
        }
        if (!(FEIGN.equals(this.getLibrary()) || RESTTEMPLATE.equals(this.getLibrary()) || RETROFIT_2.equals(this.getLibrary()) || GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || WEBCLIENT.equals(this.getLibrary()) || MICROPROFILE.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("apiException.mustache", invokerFolder, "ApiException.java"));
            this.supportingFiles.add(new SupportingFile("Configuration.mustache", invokerFolder, "Configuration.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
        }
        if (!(FEIGN.equals(this.getLibrary()) || RESTTEMPLATE.equals(this.getLibrary()) || RETROFIT_2.equals(this.getLibrary()) || GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary()) || MICROPROFILE.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
        }
        if (FEIGN.equals(this.getLibrary())) {
            if (this.getSerializationLibrary() == null) {
                this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)SERIALIZATION_LIBRARY_JACKSON);
                this.setSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            }
            if (SERIALIZATION_LIBRARY_JACKSON.equals(this.getSerializationLibrary())) {
                this.supportingFiles.add(new SupportingFile("ApiResponseDecoder.mustache", invokerFolder, "ApiResponseDecoder.java"));
                this.supportingFiles.add(new SupportingFile("ParamExpander.mustache", invokerFolder, "ParamExpander.java"));
            }
            this.supportingFiles.add(new SupportingFile("EncodingUtils.mustache", invokerFolder, "EncodingUtils.java"));
        } else if (OKHTTP_GSON.equals(this.getLibrary()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("ApiCallback.mustache", invokerFolder, "ApiCallback.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ProgressRequestBody.mustache", invokerFolder, "ProgressRequestBody.java"));
            this.supportingFiles.add(new SupportingFile("ProgressResponseBody.mustache", invokerFolder, "ProgressResponseBody.java"));
            this.supportingFiles.add(new SupportingFile("GzipRequestInterceptor.mustache", invokerFolder, "GzipRequestInterceptor.java"));
            if (OKHTTP_GSON.equals(this.getLibrary())) {
                this.supportingFiles.add(new SupportingFile("AbstractOpenApiSchema.mustache", modelsFolder, "AbstractOpenApiSchema.java"));
            }
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
            this.supportsAdditionalPropertiesWithComposedSchema = true;
        } else if (RETROFIT_2.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.mustache", this.authFolder, "OAuthOkHttpClient.java"));
            this.supportingFiles.add(new SupportingFile("CollectionFormats.mustache", invokerFolder, "CollectionFormats.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
            if (RETROFIT_2.equals(this.getLibrary()) && !this.usePlayWS) {
                this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            }
        } else if (JERSEY2.equals(this.getLibrary())) {
            this.additionalProperties.put(JERSEY2, true);
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            if (ProcessUtils.hasHttpSignatureMethods(this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/HttpSignatureAuth.mustache", this.authFolder, "HttpSignatureAuth.java"));
            }
            this.supportingFiles.add(new SupportingFile("AbstractOpenApiSchema.mustache", modelsFolder, "AbstractOpenApiSchema.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.supportsAdditionalPropertiesWithComposedSchema = true;
        } else if (JERSEY3.equals(this.getLibrary())) {
            this.additionalProperties.put(JERSEY3, true);
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            if (ProcessUtils.hasHttpSignatureMethods(this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/HttpSignatureAuth.mustache", this.authFolder, "HttpSignatureAuth.java"));
            }
            this.supportingFiles.add(new SupportingFile("AbstractOpenApiSchema.mustache", modelsFolder, "AbstractOpenApiSchema.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.supportsAdditionalPropertiesWithComposedSchema = true;
            this.applyJakartaPackage();
        } else if (NATIVE.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("AbstractOpenApiSchema.mustache", modelsFolder, "AbstractOpenApiSchema.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (RESTEASY.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (JERSEY1.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (RESTTEMPLATE.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
        } else if (WEBCLIENT.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (VERTX.equals(this.getLibrary())) {
            this.typeMapping.put("file", "AsyncFile");
            this.importMapping.put("AsyncFile", "io.vertx.core.file.AsyncFile");
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
            this.apiTemplateFiles.put("rxApiImpl.mustache", ".java");
            this.supportingFiles.remove((Object)new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        } else if (GOOGLE_API_CLIENT.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (REST_ASSURED.equals(this.getLibrary())) {
            if (this.getSerializationLibrary() == null) {
                this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)SERIALIZATION_LIBRARY_GSON);
                this.setSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
            }
            if (SERIALIZATION_LIBRARY_JACKSON.equals(this.getSerializationLibrary())) {
                this.supportingFiles.add(new SupportingFile("JacksonObjectMapper.mustache", invokerFolder, "JacksonObjectMapper.java"));
            } else if (SERIALIZATION_LIBRARY_GSON.equals(this.getSerializationLibrary())) {
                this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
                this.supportingFiles.add(new SupportingFile("GsonObjectMapper.mustache", invokerFolder, "GsonObjectMapper.java"));
            }
            this.supportingFiles.add(new SupportingFile("Oper.mustache", apiFolder, "Oper.java"));
            this.additionalProperties.put("convert", new CaseFormatLambda(CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_UNDERSCORE));
            this.apiTemplateFiles.put("api.mustache", ".java");
            this.supportingFiles.add(new SupportingFile("ResponseSpecBuilders.mustache", invokerFolder, "ResponseSpecBuilders.java"));
        } else if (MICROPROFILE.equals(this.getLibrary())) {
            this.supportingFiles.clear();
            String apiExceptionFolder = (this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
            String mpRestClientVersion2 = (String)this.additionalProperties.get(MICROPROFILE_REST_CLIENT_VERSION);
            String pomTemplate = this.mpRestClientVersions.get((Object)mpRestClientVersion2).pomTemplate;
            this.supportingFiles.add(new SupportingFile(pomTemplate, "", "pom.xml"));
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("api_exception.mustache", apiExceptionFolder, "ApiException.java"));
            this.supportingFiles.add(new SupportingFile("api_exception_mapper.mustache", apiExceptionFolder, "ApiExceptionMapper.java"));
            if (this.getSerializationLibrary() == null) {
                this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)SERIALIZATION_LIBRARY_JSONB);
                this.setSerializationLibrary(SERIALIZATION_LIBRARY_JSONB);
            } else if (this.getSerializationLibrary().equals(SERIALIZATION_LIBRARY_GSON)) {
                this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JSONB);
            }
            if (this.microprofileFramework.equals(MICROPROFILE_KUMULUZEE)) {
                this.supportingFiles.add(new SupportingFile("kumuluzee.pom.mustache", "", "pom.xml"));
                this.supportingFiles.add(new SupportingFile("kumuluzee.config.yaml.mustache", "src/main/resources", "config.yaml"));
                this.supportingFiles.add(new SupportingFile("kumuluzee.beans.xml.mustache", "src/main/resources/META-INF", "beans.xml"));
            }
            if ("3.0".equals(mpRestClientVersion2)) {
                this.additionalProperties.put("microprofile3", true);
            }
        } else if (APACHE.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else {
            this.LOGGER.error("Unknown library option (-l/--library): {}", (Object)this.getLibrary());
        }
        if (this.usePlayWS) {
            Iterator iter = this.supportingFiles.iterator();
            while (iter.hasNext()) {
                SupportingFile sf = (SupportingFile)((Object)iter.next());
                if (!sf.getTemplateFile().startsWith("auth/")) continue;
                iter.remove();
            }
            this.apiTemplateFiles.remove("api.mustache");
            this.apiTemplateFiles.put("play26/api.mustache", ".java");
            this.supportingFiles.add(new SupportingFile("play26/ApiClient.mustache", invokerFolder, "ApiClient.java"));
            this.supportingFiles.add(new SupportingFile("play26/Play26CallFactory.mustache", invokerFolder, "Play26CallFactory.java"));
            this.supportingFiles.add(new SupportingFile("play26/Play26CallAdapterFactory.mustache", invokerFolder, "Play26CallAdapterFactory.java"));
            this.supportingFiles.add(new SupportingFile("play-common/auth/ApiKeyAuth.mustache", this.authFolder, "ApiKeyAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        }
        if (this.getSerializationLibrary() == null) {
            this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)SERIALIZATION_LIBRARY_GSON);
            this.setSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
        }
        switch (this.getSerializationLibrary()) {
            case "jackson": {
                this.additionalProperties.put(SERIALIZATION_LIBRARY_JACKSON, "true");
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_GSON);
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JSONB);
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", invokerFolder, "RFC3339DateFormat.java"));
                break;
            }
            case "gson": {
                this.additionalProperties.put(SERIALIZATION_LIBRARY_GSON, "true");
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JACKSON);
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JSONB);
                break;
            }
            case "jsonb": {
                this.additionalProperties.put(SERIALIZATION_LIBRARY_JSONB, "true");
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JACKSON);
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_GSON);
                break;
            }
            default: {
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JACKSON);
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_GSON);
                this.additionalProperties.remove(SERIALIZATION_LIBRARY_JSONB);
            }
        }
        if (ProcessUtils.hasOAuthMethods(this.openAPI)) {
            if (OKHTTP_GSON.equals(this.getLibrary()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) {
                this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.mustache", this.authFolder, "OAuthOkHttpClient.java"));
                this.supportingFiles.add(new SupportingFile("auth/RetryingOAuth.mustache", this.authFolder, "RetryingOAuth.java"));
            }
            if (!(GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || this.usePlayWS || NATIVE.equals(this.getLibrary()) || MICROPROFILE.equals(this.getLibrary()))) {
                this.supportingFiles.add(new SupportingFile("auth/OAuth.mustache", this.authFolder, "OAuth.java"));
                this.supportingFiles.add(new SupportingFile("auth/OAuthFlow.mustache", this.authFolder, "OAuthFlow.java"));
            }
            if (FEIGN.equals(this.getLibrary())) {
                this.supportingFiles.add(new SupportingFile("auth/DefaultApi20Impl.mustache", this.authFolder, "DefaultApi20Impl.java"));
                this.supportingFiles.add(new SupportingFile("auth/OauthPasswordGrant.mustache", this.authFolder, "OauthPasswordGrant.java"));
                this.supportingFiles.add(new SupportingFile("auth/OauthClientCredentialsGrant.mustache", this.authFolder, "OauthClientCredentialsGrant.java"));
                this.supportingFiles.add(new SupportingFile("auth/ApiErrorDecoder.mustache", this.authFolder, "ApiErrorDecoder.java"));
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        Pattern methodPattern;
        List<CodegenOperation> operationList;
        List<CodegenOperation> ops;
        OperationMap operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (this.useSingleRequestParameter && (JERSEY2.equals(this.getLibrary()) || JERSEY3.equals(this.getLibrary()) || OKHTTP_GSON.equals(this.getLibrary())) && (operations = objs.getOperations()) != null) {
            ops = operations.getOperation();
            for (CodegenOperation codegenOperation : ops) {
                if (codegenOperation.vendorExtensions.containsKey("x-group-parameters")) continue;
                codegenOperation.vendorExtensions.put("x-group-parameters", true);
            }
        }
        if (RETROFIT_2.equals(this.getLibrary()) && (operations = objs.getOperations()) != null) {
            ops = operations.getOperation();
            for (CodegenOperation codegenOperation : ops) {
                if (codegenOperation.hasConsumes == Boolean.TRUE) {
                    if (JavaClientCodegen.isMultipartType(codegenOperation.consumes)) {
                        codegenOperation.isMultipart = Boolean.TRUE;
                    } else {
                        codegenOperation.prioritizedContentTypes = JavaClientCodegen.prioritizeContentTypes(codegenOperation.consumes);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)codegenOperation.path) && codegenOperation.path.startsWith("/")) {
                    codegenOperation.path = codegenOperation.path.substring(1);
                }
                if (codegenOperation.allParams == null) continue;
                Collections.sort(codegenOperation.allParams, new Comparator<CodegenParameter>(){

                    @Override
                    public int compare(CodegenParameter one, CodegenParameter another) {
                        if (one.isPathParam && another.isQueryParam) {
                            return -1;
                        }
                        if (one.isQueryParam && another.isPathParam) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
        }
        if (FEIGN.equals(this.getLibrary())) {
            operations = objs.getOperations();
            operationList = operations.getOperation();
            methodPattern = Pattern.compile("^(.*):([^:]*)$");
            for (CodegenOperation op : operationList) {
                String path = op.path;
                String method = "";
                Matcher m = methodPattern.matcher(path);
                if (m.find()) {
                    path = m.group(1);
                    method = m.group(2);
                }
                Object[] items = path.split("/", -1);
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].matches("^\\{(.*)\\}$")) continue;
                    items[i] = "{" + StringUtils.camelize(((String)items[i]).substring(1, ((String)items[i]).length() - 1), CamelizeOption.LOWERCASE_FIRST_LETTER) + "}";
                }
                op.path = org.apache.commons.lang3.StringUtils.join((Object[])items, (String)"/");
                if (method.isEmpty()) continue;
                op.path = op.path + ":" + method;
            }
        }
        if (NATIVE.equals(this.getLibrary()) || APACHE.equals(this.getLibrary())) {
            operations = objs.getOperations();
            operationList = operations.getOperation();
            methodPattern = Pattern.compile("^(.*):([^:]*)$");
            for (CodegenOperation op : operationList) {
                if (op.produces == null) continue;
                for (Map<String, String> produce : op.produces) {
                    if (!"text/plain".equalsIgnoreCase(produce.get(MEDIA_TYPE).split(";")[0].trim()) || !"String".equals(op.returnType)) continue;
                    op.vendorExtensions.put("x-java-text-plain-string", true);
                }
            }
        }
        if (MICROPROFILE.equals(this.getLibrary())) {
            objs = AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
        }
        if (WEBCLIENT.equals(this.getLibrary()) && (operations = objs.getOperations()) != null) {
            ops = operations.getOperation();
            for (CodegenOperation codegenOperation : ops) {
                if (!codegenOperation.vendorExtensions.containsKey(VendorExtension.X_WEBCLIENT_BLOCKING.getName()) && this.webclientBlockingOperations) {
                    codegenOperation.vendorExtensions.put(VendorExtension.X_WEBCLIENT_BLOCKING.getName(), true);
                }
                if (!codegenOperation.isArray || "string".equalsIgnoreCase(codegenOperation.returnBaseType)) continue;
                codegenOperation.vendorExtensions.put(VendorExtension.X_WEBCLIENT_RETURN_EXCEPT_LIST_OF_STRING.getName(), true);
            }
        }
        return objs;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        if (VERTX.equals(this.getLibrary())) {
            String suffix = this.apiTemplateFiles().get(templateName);
            String subFolder = "";
            if (templateName.startsWith("rx")) {
                subFolder = "/rxjava";
            }
            return this.apiFileFolder() + subFolder + "/" + this.toApiFilename(tag) + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    static List<Map<String, String>> prioritizeContentTypes(List<Map<String, String>> consumes) {
        if (consumes.size() <= 1) {
            return consumes;
        }
        ArrayList<Map<String, String>> prioritizedContentTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonVendorMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        for (Map<String, String> consume : consumes) {
            if (JavaClientCodegen.isJsonVendorMimeType(consume.get(MEDIA_TYPE))) {
                jsonVendorMimeTypes.add(consume);
                continue;
            }
            if (JavaClientCodegen.isJsonMimeType(consume.get(MEDIA_TYPE))) {
                jsonMimeTypes.add(consume);
                continue;
            }
            prioritizedContentTypes.add(consume);
        }
        prioritizedContentTypes.addAll(0, jsonMimeTypes);
        prioritizedContentTypes.addAll(0, jsonVendorMimeTypes);
        return prioritizedContentTypes;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        return firstType != null && "multipart/form-data".equals(firstType.get(MEDIA_TYPE));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON)) {
                model.imports.add("JsonProperty");
                model.imports.add("JsonValue");
                model.imports.add("JsonInclude");
                model.imports.add("JsonTypeName");
            }
            if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_GSON)) {
                model.imports.add("SerializedName");
                model.imports.add("TypeAdapter");
                model.imports.add("JsonAdapter");
                model.imports.add("JsonReader");
                model.imports.add("JsonWriter");
                model.imports.add("IOException");
            }
        } else if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON)) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
        if (MICROPROFILE.equals(this.getLibrary())) {
            model.imports.remove("ApiModelProperty");
            model.imports.remove("ApiModel");
            model.imports.remove("JsonSerialize");
            model.imports.remove("ToStringSerializer");
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum) && DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2.equals((Object)this.getAnnotationLibrary())) {
            model.imports.add("Schema");
        }
        if ("set".equals(property.containerType) && !SERIALIZATION_LIBRARY_JACKSON.equals(this.serializationLibrary)) {
            model.imports.remove("JsonDeserialize");
            property.vendorExtensions.remove("x-setter-extra-annotation");
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (MICROPROFILE.equals(this.getLibrary()) && codegenModel.imports.contains("ApiModel")) {
            codegenModel.imports.remove("ApiModel");
        }
        if (!DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1.equals((Object)this.getAnnotationLibrary())) {
            codegenModel.imports.remove("ApiModel");
            codegenModel.imports.remove("ApiModelProperty");
        }
        if (codegenModel.description != null && DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2.equals((Object)this.getAnnotationLibrary())) {
            codegenModel.imports.add("Schema");
        }
        return codegenModel;
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_GSON)) {
            List<Map<String, String>> imports = objs.getImports();
            for (ModelMap mo : objs.getModels()) {
                CodegenModel cm = mo.getModel();
                if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
                cm.imports.add((String)this.importMapping.get("SerializedName"));
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("import", (String)this.importMapping.get("SerializedName"));
                imports.add(item);
            }
        }
        return objs;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<ModelMap> models = objs.getModels();
        if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON) && !JERSEY1.equals(this.getLibrary())) {
            List<Map<String, String>> imports = objs.getImports();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                boolean addNullableImports = false;
                for (CodegenProperty var : cm.vars) {
                    addNullableImports = this.isAddNullableImports(cm, addNullableImports, var);
                    if (!Boolean.TRUE.equals(var.getVendorExtensions().get("x-enum-as-string"))) continue;
                    var.datatypeWithEnum = var.dataType;
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)var.defaultValue)) {
                        String defaultValue = var.defaultValue.substring(var.defaultValue.lastIndexOf(46) + 1);
                        for (Map enumVars : (List)var.getAllowableValues().get("enumVars")) {
                            if (!defaultValue.equals(enumVars.get("name"))) continue;
                            var.defaultValue = (String)enumVars.get("value");
                        }
                    }
                    cm.imports.add("Set");
                    HashMap<String, String> importsSet = new HashMap<String, String>();
                    importsSet.put("import", "java.util.Set");
                    imports.add(importsSet);
                    HashMap<String, String> importsHashSet = new HashMap<String, String>();
                    importsHashSet.put("import", "java.util.HashSet");
                    imports.add(importsHashSet);
                }
                if (!addNullableImports) continue;
                HashMap<String, String> imports2Classnames = new HashMap<String, String>();
                imports2Classnames.put("JsonNullable", "org.openapitools.jackson.nullable.JsonNullable");
                imports2Classnames.put("NoSuchElementException", "java.util.NoSuchElementException");
                imports2Classnames.put("JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
                JavaClientCodegen.addImports(imports, cm, imports2Classnames);
            }
        }
        for (ModelMap mo : models) {
            CodegenModel cm = mo.getModel();
            cm.getVendorExtensions().putIfAbsent("x-implements", new ArrayList());
            if (JERSEY2.equals(this.getLibrary()) || JERSEY3.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary()) || OKHTTP_GSON.equals(this.getLibrary())) {
                if (cm.oneOf != null && !cm.oneOf.isEmpty() && cm.oneOf.contains("ModelNull")) {
                    cm.isNullable = true;
                    cm.oneOf.remove("ModelNull");
                }
                if (cm.anyOf != null && !cm.anyOf.isEmpty() && cm.anyOf.contains("ModelNull")) {
                    cm.isNullable = true;
                    cm.anyOf.remove("ModelNull");
                }
            }
            if (!this.parcelableModel) continue;
            ((ArrayList)cm.getVendorExtensions().get("x-implements")).add("Parcelable");
        }
        return objs;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    public void setUseRxJava(boolean useRxJava) {
        this.useRxJava = useRxJava;
        this.doNotUseRx = false;
    }

    public void setUseRxJava2(boolean useRxJava2) {
        this.useRxJava2 = useRxJava2;
        this.doNotUseRx = false;
    }

    public void setUseRxJava3(boolean useRxJava3) {
        this.useRxJava3 = useRxJava3;
        this.doNotUseRx = false;
    }

    public void setDoNotUseRx(boolean doNotUseRx) {
        this.doNotUseRx = doNotUseRx;
    }

    public void setUsePlayWS(boolean usePlayWS) {
        this.usePlayWS = usePlayWS;
    }

    public void setAsyncNative(boolean asyncNative) {
        this.asyncNative = asyncNative;
    }

    public void setMicroprofileFramework(String microprofileFramework) {
        this.microprofileFramework = microprofileFramework;
    }

    public void setMicroprofileMutiny(boolean microprofileMutiny) {
        this.microprofileMutiny = microprofileMutiny;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setParcelableModel(boolean parcelableModel) {
        this.parcelableModel = parcelableModel;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    @Override
    public void setUseGzipFeature(boolean useGzipFeature) {
        this.useGzipFeature = useGzipFeature;
    }

    public void setUseRuntimeException(boolean useRuntimeException) {
        this.useRuntimeException = useRuntimeException;
    }

    public void setUseReflectionEqualsHashCode(boolean useReflectionEqualsHashCode) {
        this.useReflectionEqualsHashCode = useReflectionEqualsHashCode;
    }

    public void setCaseInsensitiveResponseHeaders(Boolean caseInsensitiveResponseHeaders) {
        this.caseInsensitiveResponseHeaders = caseInsensitiveResponseHeaders;
    }

    public void setUseAbstractionForFiles(boolean useAbstractionForFiles) {
        this.useAbstractionForFiles = useAbstractionForFiles;
    }

    public void setDynamicOperations(boolean dynamicOperations) {
        this.dynamicOperations = dynamicOperations;
    }

    public void setSupportStreaming(boolean supportStreaming) {
        this.supportStreaming = supportStreaming;
    }

    public void setWithAWSV4Signature(boolean withAWSV4Signature) {
        this.withAWSV4Signature = withAWSV4Signature;
    }

    public void setGradleProperties(String gradleProperties) {
        this.gradleProperties = gradleProperties;
    }

    public void setErrorObjectType(String errorObjectType) {
        this.errorObjectType = errorObjectType;
    }

    public void setGenerateClientAsBean(boolean generateClientAsBean) {
        this.generateClientAsBean = generateClientAsBean;
    }

    public void setUseEnumCaseInsensitive(boolean useEnumCaseInsensitive) {
        this.useEnumCaseInsensitive = useEnumCaseInsensitive;
    }

    public String getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        if (SERIALIZATION_LIBRARY_JACKSON.equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = SERIALIZATION_LIBRARY_JACKSON;
        } else if (SERIALIZATION_LIBRARY_GSON.equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = SERIALIZATION_LIBRARY_GSON;
        } else if (SERIALIZATION_LIBRARY_JSONB.equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = SERIALIZATION_LIBRARY_JSONB;
        } else {
            throw new IllegalArgumentException("Unexpected serializationLibrary value: " + serializationLibrary);
        }
    }

    public void forceSerializationLibrary(String serializationLibrary) {
        if (this.serializationLibrary != null && !this.serializationLibrary.equalsIgnoreCase(serializationLibrary)) {
            this.LOGGER.warn("The configured serializationLibrary '{}', is not supported by the library: '{}', switching back to: {}", new Object[]{this.serializationLibrary, this.getLibrary(), serializationLibrary});
        }
        this.setSerializationLibrary(serializationLibrary);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    @Override
    public void addImportsToOneOfInterface(List<Map<String, String>> imports) {
        for (String i : Arrays.asList("JsonSubTypes", "JsonTypeInfo", "JsonIgnoreProperties")) {
            HashMap<String, String> oneImport = new HashMap<String, String>();
            oneImport.put("import", (String)this.importMapping.get(i));
            if (imports.contains(oneImport)) continue;
            imports.add(oneImport);
        }
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        List<VendorExtension> extensions = super.getSupportedVendorExtensions();
        extensions.add(VendorExtension.X_WEBCLIENT_BLOCKING);
        return extensions;
    }

    private static class MpRestClientVersion {
        public final String rootPackage;
        public final String pomTemplate;

        public MpRestClientVersion(String rootPackage, String pomTemplate) {
            this.rootPackage = rootPackage;
            this.pomTemplate = pomTemplate;
        }
    }
}

