/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validations.oas;

import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.SemVer;
import org.openapitools.codegen.validation.GenericValidator;
import org.openapitools.codegen.validation.ValidationRule;
import org.openapitools.codegen.validations.oas.RuleConfiguration;
import org.openapitools.codegen.validations.oas.SchemaWrapper;

class OpenApiSchemaValidations
extends GenericValidator<SchemaWrapper> {
    private static Set<String> validTypes = new HashSet<String>(Arrays.asList("null", "boolean", "object", "array", "number", "string", "integer"));

    OpenApiSchemaValidations(RuleConfiguration ruleConfiguration) {
        super(new ArrayList());
        if (ruleConfiguration.isEnableRecommendations()) {
            if (ruleConfiguration.isEnableOneOfWithPropertiesRecommendation()) {
                this.rules.add(ValidationRule.warn((String)"Schema defines properties alongside oneOf.", (String)"Schemas defining properties and oneOf are not clearly defined in the OpenAPI Specification. While our tooling supports this, it may cause issues with other tools.", OpenApiSchemaValidations::checkOneOfWithProperties));
            }
            if (ruleConfiguration.isEnableSchemaTypeRecommendation()) {
                this.rules.add(ValidationRule.warn((String)"Schema uses the 'null' type but OAS document is version 3.0.", (String)"The 'null' type is not supported in OpenAPI 3.0.x. It is supported in OpenAPI 3.1 and above. While our tooling supports this, it may cause issues with other tools.", OpenApiSchemaValidations::checkNullType));
            }
            if (ruleConfiguration.isEnableNullableAttributeRecommendation()) {
                this.rules.add(ValidationRule.warn((String)"Schema uses the 'nullable' attribute.", (String)"The 'nullable' attribute is deprecated in OpenAPI 3.1, and may no longer be supported in future releases. Consider migrating to the 'null' type.", OpenApiSchemaValidations::checkNullableAttribute));
            }
            if (ruleConfiguration.isEnableInvalidTypeRecommendation()) {
                this.rules.add(ValidationRule.warn((String)"Schema uses an invalid value for the 'type' attribute.", (String)"The 'type' attribute must be one of 'null', 'boolean', 'object', 'array', 'number', 'string', or 'integer'.", OpenApiSchemaValidations::checkInvalidType));
            }
        }
    }

    private static ValidationRule.Result checkOneOfWithProperties(SchemaWrapper schemaWrapper) {
        Schema schema = schemaWrapper.getSchema();
        ValidationRule.Result result = ValidationRule.Pass.empty();
        if (ModelUtils.isComposedSchema(schema) && schema.getOneOf() != null && schema.getOneOf().size() > 0 && schema.getProperties() != null && schema.getProperties().size() >= 1 && schema.getProperties().get("discriminator") == null) {
            result = ValidationRule.Fail.empty();
        }
        return result;
    }

    private static ValidationRule.Result checkNullType(SchemaWrapper schemaWrapper) {
        SemVer version;
        Schema schema = schemaWrapper.getSchema();
        ValidationRule.Result result = ValidationRule.Pass.empty();
        if (schemaWrapper.getOpenAPI() != null && (version = new SemVer(schemaWrapper.getOpenAPI().getOpenapi())).atLeast("3.0") && version.compareTo(new SemVer("3.1")) < 0 && ModelUtils.isNullType(schema)) {
            result = new ValidationRule.Fail();
            String name = schema.getName();
            if (name == null) {
                name = schema.getTitle();
            }
            result.setDetails(String.format(Locale.ROOT, "Schema '%s' uses a 'null' type, which is specified in OAS 3.1 and above, but OAS document is version %s", name, schemaWrapper.getOpenAPI().getOpenapi()));
            return result;
        }
        return result;
    }

    private static ValidationRule.Result checkNullableAttribute(SchemaWrapper schemaWrapper) {
        SemVer version;
        Schema schema = schemaWrapper.getSchema();
        ValidationRule.Result result = ValidationRule.Pass.empty();
        if (schemaWrapper.getOpenAPI() != null && (version = new SemVer(schemaWrapper.getOpenAPI().getOpenapi())).atLeast("3.1") && ModelUtils.isNullable(schema)) {
            result = new ValidationRule.Fail();
            String name = schema.getName();
            if (name == null) {
                name = schema.getTitle();
            }
            result.setDetails(String.format(Locale.ROOT, "OAS document is version '%s'. Schema '%s' uses 'nullable' attribute, which has been deprecated in OAS 3.1.", schemaWrapper.getOpenAPI().getOpenapi(), name));
            return result;
        }
        return result;
    }

    private static ValidationRule.Result checkInvalidType(SchemaWrapper schemaWrapper) {
        Schema schema = schemaWrapper.getSchema();
        ValidationRule.Result result = ValidationRule.Pass.empty();
        if (schema.getType() != null && !validTypes.contains(schema.getType())) {
            result = new ValidationRule.Fail();
            String name = schema.getName();
            if (name == null) {
                name = schema.getTitle();
            }
            result.setDetails(String.format(Locale.ROOT, "Schema '%s' uses the '%s' type, which is not a valid type.", name, schema.getType()));
            return result;
        }
        return result;
    }
}

