/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpNextgenClientCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpNextgenClientCodegen.class);

    public PhpNextgenClientCodegen() {
        this.setSrcBasePath("src");
        this.setTestBasePath("tests");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.importMapping.clear();
        this.setInvokerPackage("OpenAPI\\Client");
        this.setApiPackage(this.getInvokerPackage() + "\\" + this.apiDirName);
        this.setModelPackage(this.getInvokerPackage() + "\\" + this.modelDirName);
        this.setPackageName("OpenAPIClient-php");
        this.supportsInheritance = true;
        this.setOutputDir("generated-code" + File.separator + "php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.templateDir = "php-nextgen";
        this.embeddedTemplateDir = "php-nextgen";
        this.hideGenerationTimestamp = Boolean.TRUE;
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php-nextgen";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client library (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ApiException.php"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "Configuration.php"));
        this.supportingFiles.add(new SupportingFile("ObjectSerializer.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "ObjectSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toSrcPath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("HeaderSelector.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "HeaderSelector.php"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", "", "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php-cs-fixer.dist.php", "", ".php-cs-fixer.dist.php"));
        this.supportingFiles.add(new SupportingFile(".phplint.mustache", "", ".phplint.yml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(objs);
        for (Map.Entry<String, ModelsMap> entry : processed.entrySet()) {
            entry.setValue(this.postProcessModelsMap(entry.getValue()));
        }
        return processed;
    }

    private ModelsMap postProcessModelsMap(ModelsMap objs) {
        for (ModelMap m : objs.getModels()) {
            CodegenModel model = m.getModel();
            for (CodegenProperty prop : model.vars) {
                Object propType = prop.isArray || prop.isMap ? "array" : prop.dataType;
                if (!prop.required || prop.isNullable) {
                    propType = "?" + (String)propType;
                }
                prop.vendorExtensions.putIfAbsent("x-php-prop-type", propType);
            }
            if (!model.isEnum) continue;
            for (Map enumVars : (List)model.getAllowableValues().get("enumVars")) {
                if (((Boolean)enumVars.get("isString")).booleanValue()) {
                    model.vendorExtensions.putIfAbsent("x-php-enum-type", "string");
                    continue;
                }
                model.vendorExtensions.putIfAbsent("x-php-enum-type", "int");
            }
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        for (CodegenOperation operation : operations.getOperation()) {
            if (operation.returnType == null) {
                operation.vendorExtensions.putIfAbsent("x-php-return-type", "void");
            } else if (operation.returnProperty.isContainer) {
                operation.vendorExtensions.putIfAbsent("x-php-return-type", "array");
            } else {
                operation.vendorExtensions.putIfAbsent("x-php-return-type", operation.returnType);
            }
            for (CodegenParameter param : operation.allParams) {
                if (param.isArray || param.isMap) {
                    param.vendorExtensions.putIfAbsent("x-php-param-type", "array");
                    continue;
                }
                param.vendorExtensions.putIfAbsent("x-php-param-type", param.dataType);
            }
        }
        return objs;
    }

    @Override
    public String toDefaultValue(CodegenProperty codegenProperty, Schema schema) {
        if (codegenProperty.isArray) {
            if (schema.getDefault() != null) {
                return "[" + schema.getDefault().toString() + "]";
            }
            if (schema.getItems().getDefault() != null) {
                return "[" + this.toDefaultValue(schema.getItems()) + "]";
            }
            return null;
        }
        return super.toDefaultValue(codegenProperty, schema);
    }

    @Override
    public String toDefaultParameterValue(CodegenProperty codegenProperty, Schema<?> schema) {
        return this.toDefaultValue(codegenProperty, schema);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.isArray && p.items.defaultValue != null) {
            p.example = p.defaultValue;
        } else {
            super.setParameterExampleValue(p);
        }
    }
}

