/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.ignore.rules;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.List;
import org.openapitools.codegen.ignore.rules.FileRule;
import org.openapitools.codegen.ignore.rules.Part;

public class DirectoryRule
extends FileRule {
    private PathMatcher directoryMatcher = null;
    private PathMatcher contentsMatcher = null;

    DirectoryRule(List<Part> syntax, String definition) {
        super(syntax, definition);
        String pattern = this.getPattern();
        StringBuilder sb = new StringBuilder();
        sb.append("glob:");
        sb.append(pattern);
        if (!pattern.endsWith("/")) {
            sb.append("/");
        }
        this.directoryMatcher = FileSystems.getDefault().getPathMatcher(sb.toString());
        sb.append("**");
        this.contentsMatcher = FileSystems.getDefault().getPathMatcher(sb.toString());
    }

    @Override
    public Boolean matches(String relativePath) {
        return this.contentsMatcher.matches(FileSystems.getDefault().getPath(relativePath, new String[0])) || this.directoryMatcher.matches(FileSystems.getDefault().getPath(relativePath, new String[0]));
    }
}

