/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ApiInfoMap;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaHttp4sServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ScalaHttp4sServerCodegen.class);
    protected String artifactId = "http4s-server";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "scala";
    protected String sourceSubFolder = "main";
    private String packageName = "org.openapitools";
    public static final String EXCLUDE_SBT = "excludeSbt";
    public static final String SOURCE_SUBFOLDER = "sourceSubfolder";
    private static final Map<String, String> locationStatusToResponse = new HashMap<String, String>();
    private static final Map<String, String> wwwAuthStatusToResponse;
    private static final Map<String, String> allowStatusToResponse;
    private static final Map<String, String> proxyAuthStatusToResponse;
    private static final Map<String, String> statusToResponse;

    public ScalaHttp4sServerCodegen() {
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.templateDir = "scala-http4s-server";
        this.embeddedTemplateDir = "scala-http4s-server";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        this.useOneOfInterfaces = true;
        this.supportsMultipleInheritance = true;
        this.supportsInheritance = true;
        this.supportsMixins = true;
        this.addOneOfInterfaceImports = true;
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield", "abstract", "continue", "switch", "assert", "default", "synchronized", "goto", "break", "double", "implements", "byte", "public", "throws", "enum", "instanceof", "transient", "int", "short", "char", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.typeMapping.put("date-time", "ZonedDateTime");
        this.typeMapping.put("offset-date-time", "OffsetDateTime");
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "Array[Byte]");
        this.typeMapping.put("Date", "LocalDate");
        this.typeMapping.put("DateTime", "ZonedDateTime");
        this.typeMapping.put("OffsetDateTime", "OffsetDateTime");
        this.typeMapping.put("uuid", "UUID");
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("infoUrl", "http://org.openapitools");
        this.additionalProperties.put("infoEmail", "team@openapitools.org");
        this.additionalProperties.put("licenseInfo", "Apache 2.0");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Double", "Int", "Integer", "Long", "Float", "Any", "AnyVal", "AnyRef", "Object", "BigDecimal"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "scala.collection.immutable.Map");
        this.importMapping.put("HashMap", "scala.collection.immutable.HashMap");
        this.importMapping.put("Seq", "scala.collection.immutable.Seq");
        this.importMapping.put("ArrayBuffer", "scala.collection.mutable.ArrayBuffer");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("Refined", "eu.timepit.refined.api.Refined");
        this.importMapping.put("And", "eu.timepit.refined.boolean.And");
        this.importMapping.put("MinSize", "eu.timepit.refined.collection.MinSize");
        this.importMapping.put("MaxSize", "eu.timepit.refined.collection.MaxSize");
        this.importMapping.put("MatchesRegex", "eu.timepit.refined.string.MatchesRegex");
        this.importMapping.put("Greater", "eu.timepit.refined.numeric.Greater");
        this.importMapping.put("GreaterEqual", "eu.timepit.refined.numeric.GreaterEqual");
        this.importMapping.put("Less", "eu.timepit.refined.numeric.Less");
        this.importMapping.put("LessEqual", "eu.timepit.refined.numeric.LessEqual");
        this.cliOptions.add(new CliOption(EXCLUDE_SBT, "exclude sbt from generation"));
        this.cliOptions.add(new CliOption(SOURCE_SUBFOLDER, "name of subfolder, for example to generate code in src/scala/generated"));
        this.inlineSchemaOption.put("SKIP_SCHEMA_REUSE", "true");
        this.inlineSchemaOption.put("REFACTOR_ALLOF_INLINE_SCHEMAS", "true");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.packageName = (String)this.additionalProperties.get("packageName");
            this.setApiPackage(this.packageName + ".apis");
            this.additionalProperties.put("apiPackage", this.apiPackage());
            this.setModelPackage(this.packageName + ".models");
            this.additionalProperties.put("packageName", this.modelPackage());
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey(SOURCE_SUBFOLDER)) {
            this.sourceSubFolder = (String)this.additionalProperties.get(SOURCE_SUBFOLDER);
        }
        this.sourceFolder = "src" + File.separator + this.sourceSubFolder + File.separator + this.sourceFolder;
        this.supportingFiles.add(new SupportingFile("types.mustache", this.modelFileFolderRelative(), "types.scala"));
        this.supportingFiles.add(new SupportingFile("path.mustache", this.apiFileFolderRelative(), "path.scala"));
        this.supportingFiles.add(new SupportingFile("query.mustache", this.apiFileFolderRelative(), "query.scala"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.packageFileFolderRelative(), "api.scala"));
        this.apiTemplateFiles.put("api.mustache", ".scala");
        if (!this.additionalProperties.containsKey(EXCLUDE_SBT) && !Boolean.parseBoolean((String)this.additionalProperties.get(EXCLUDE_SBT))) {
            this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
            this.supportingFiles.add(new SupportingFile("build.properties", "project", "build.properties"));
        }
    }

    @Override
    public Map<String, String> inlineSchemaOption() {
        return super.inlineSchemaOption();
    }

    @Override
    public boolean isEnablePostProcessFile() {
        return true;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        this.LOGGER.debug("postprocess " + file.toString());
        super.postProcessFile(file, fileType);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> modelsMap = super.postProcessAllModels(objs);
        for (ModelsMap mm : modelsMap.values()) {
            for (ModelMap model : mm.getModels()) {
                CodegenModel cModel = model.getModel();
                cModel.getVendorExtensions().put("x-isSealedTrait", !cModel.oneOf.isEmpty());
                if (cModel.discriminator != null) {
                    cModel.getVendorExtensions().put("x-use-discr", true);
                    if (cModel.discriminator.getMapping() != null) {
                        cModel.getVendorExtensions().put("x-use-discr-mapping", true);
                    }
                }
                try {
                    List exts = (List)cModel.getVendorExtensions().get("x-implements");
                    if (exts != null) {
                        cModel.getVendorExtensions().put("x-extends", exts.subList(0, 1));
                        cModel.getVendorExtensions().put("x-extendsWith", exts.subList(1, exts.size()));
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                for (CodegenProperty prop : cModel.vars) {
                    TreeSet<String> imports = new TreeSet<String>();
                    prop.getVendorExtensions().putAll(this.refineProp(prop, imports));
                    cModel.imports.addAll(imports);
                }
            }
        }
        return modelsMap;
    }

    private Map<String, Object> makeRefiined(Set<String> imports, String dataType, ArrayList<String> refined) {
        HashMap<String, Object> vendorExtensions = new HashMap<String, Object>();
        if (!refined.isEmpty()) {
            imports.add("And");
            imports.add("Refined");
            String refinedRgt = String.join((CharSequence)" And ", refined);
            vendorExtensions.put("x-type", "Refined[" + dataType + ", " + refinedRgt + "]");
            vendorExtensions.put("x-refined-lft", dataType);
            vendorExtensions.put("x-refined-rgt", refinedRgt);
            vendorExtensions.put("x-refined", true);
        } else {
            vendorExtensions.put("x-type", dataType);
        }
        return vendorExtensions;
    }

    private Map<String, Object> refineProp(IJsonSchemaValidationProperties prop, Set<String> imports) {
        ArrayList<String> refined;
        HashMap<String, Object> vendorExtensions = new HashMap<String, Object>();
        vendorExtensions.put("x-type", prop.getDataType());
        if (prop.getIsString()) {
            refined = new ArrayList<String>();
            if (prop.getMinLength() != null) {
                refined.add("MinSize[" + prop.getMinLength() + "]");
                imports.add("MinSize");
            }
            if (prop.getMaxLength() != null) {
                refined.add("MaxSize[" + prop.getMaxLength() + "]");
                imports.add("MaxSize");
            }
            if (prop.getPattern() != null) {
                try {
                    String fixedPattern = prop.getPattern().substring(1, prop.getPattern().length() - 1);
                    refined.add("MatchesRegex[\"" + fixedPattern + "\"]");
                    imports.add("MatchesRegex");
                }
                catch (IndexOutOfBoundsException fixedPattern) {
                    // empty catch block
                }
            }
            vendorExtensions.putAll(this.makeRefiined(imports, prop.getDataType(), refined));
        }
        if ("Int".equals(prop.getDataType()) || "Long".equals(prop.getDataType()) || "Float".equals(prop.getDataType()) || "Double".equals(prop.getDataType()) || "BigDecimal".equals(prop.getDataType())) {
            refined = new ArrayList();
            if (prop.getMinimum() != null) {
                if (prop.getExclusiveMinimum()) {
                    refined.add("Greater[" + prop.getMinimum() + "]");
                    imports.add("Greater");
                } else {
                    refined.add("GreaterEqual[" + prop.getMinimum() + "]");
                    imports.add("GreaterEqual");
                }
            }
            if (prop.getMaximum() != null) {
                if (prop.getExclusiveMaximum()) {
                    refined.add("Less[" + prop.getMaximum() + "]");
                    imports.add("Less");
                } else {
                    refined.add("LessEqual[" + prop.getMaximum() + "]");
                    imports.add("LessEqual");
                }
            }
            vendorExtensions.putAll(this.makeRefiined(imports, prop.getDataType(), refined));
        }
        if (prop.getIsUuid() || "Uuid".equals(prop.getDataType())) {
            prop.setDataType("UUID");
        }
        if (prop.getIsArray() && prop.getItems() != null) {
            Map<String, Object> subVendorExtensions = this.refineProp(prop.getItems(), imports);
            prop.getItems().getVendorExtensions().putAll(subVendorExtensions);
            ArrayList<String> refined2 = new ArrayList<String>();
            if (prop.getMinItems() != null) {
                refined2.add("MinSize[" + prop.getMinItems() + "]");
                imports.add("MinSize");
            }
            if (prop.getMaxItems() != null) {
                refined2.add("MaxSize[" + prop.getMaxItems() + "]");
                imports.add("MaxSize");
            }
            vendorExtensions.putAll(this.makeRefiined(imports, prop.getDataType(), refined2));
        }
        return vendorExtensions;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Map<String, Object> bundle = super.postProcessSupportingFileData(objs);
        List models = (List)bundle.get("models");
        TreeSet<String> allImports = new TreeSet<String>();
        for (ModelMap mm : models) {
            for (String nextImport : mm.getModel().imports) {
                String mapping = this.importMapping().get(nextImport);
                if (mapping != null && !this.defaultIncludes().contains(mapping)) {
                    allImports.add(mapping);
                }
                if ((mapping = this.instantiationTypes().get(nextImport)) == null || this.defaultIncludes().contains(mapping)) continue;
                allImports.add(mapping);
            }
        }
        bundle.put("imports", allImports);
        bundle.put("packageName", this.packageName);
        ApiInfoMap apiInfoMap = (ApiInfoMap)bundle.get("apiInfo");
        TreeMap<String, List> authToOperationMap = new TreeMap<String, List>();
        for (OperationsMap op : apiInfoMap.getApis()) {
            List opsByAuth = (List)op.get("operationsByAuth");
            for (HashMap auth : opsByAuth) {
                String autName = (String)auth.get("auth");
                String classname = (String)op.get("classname");
                List classnames = authToOperationMap.computeIfAbsent(autName, k -> new ArrayList());
                classnames.add(classname);
            }
        }
        bundle.put("authToOperationMap", authToOperationMap.entrySet().stream().map(ent -> {
            HashMap<String, Object> tuple = new HashMap<String, Object>();
            String auth = (String)ent.getKey();
            tuple.put("auth", auth);
            tuple.put("ops", ent.getValue());
            tuple.put("addMiddleware", !"".equals(auth));
            return tuple;
        }).collect(Collectors.toList()));
        return bundle;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-http4s-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala http4s server bindings.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiFileFolderRelative();
    }

    private String apiFileFolderRelative() {
        return this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelFileFolderRelative();
    }

    public String modelFileFolderRelative() {
        return this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    public String packageFileFolderRelative() {
        return this.sourceFolder + File.separator + this.packageName.replace('.', File.separatorChar);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objsI, List<ModelMap> allModels) {
        OperationsMap objs = super.postProcessOperationsWithModels(objsI, allModels);
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        HashSet<String> allAuth = new HashSet<String>();
        HashMap<String, List> opsByAuth = new HashMap<String, List>();
        for (CodegenOperation op : operationList) {
            this.generateScalaPath(op);
            this.generateQueryParameters(op);
            if (op.consumes == null || op.consumes.size() == 0) {
                op.vendorExtensions.put("x-generic-body", true);
            } else {
                if (op.consumes.stream().anyMatch(x -> x.containsKey("isJson"))) {
                    op.vendorExtensions.put("x-json-body", true);
                }
                if (op.consumes.stream().anyMatch(x -> !x.containsKey("isJson"))) {
                    op.vendorExtensions.put("x-generic-body", true);
                }
            }
            for (CodegenResponse codegenResponse : op.responses) {
                String responseName;
                if (codegenResponse.code.equals("0")) {
                    codegenResponse.code = "200";
                }
                if ((responseName = locationStatusToResponse.get(codegenResponse.code)) != null) {
                    codegenResponse.vendorExtensions.put("x-response-location", true);
                } else {
                    responseName = wwwAuthStatusToResponse.get(codegenResponse.code);
                    if (responseName != null) {
                        codegenResponse.vendorExtensions.put("x-response-www-auth", true);
                    } else {
                        responseName = allowStatusToResponse.get(codegenResponse.code);
                        if (responseName != null) {
                            codegenResponse.vendorExtensions.put("x-response-allow", true);
                        } else {
                            responseName = proxyAuthStatusToResponse.get(codegenResponse.code);
                            if (responseName != null) {
                                codegenResponse.vendorExtensions.put("x-response-proxy-auth", true);
                            } else {
                                responseName = statusToResponse.get(codegenResponse.code);
                                if (responseName != null) {
                                    codegenResponse.vendorExtensions.put("x-response-standard", true);
                                } else {
                                    throw new IllegalArgumentException("unsupported status " + codegenResponse.code);
                                }
                            }
                        }
                    }
                }
                codegenResponse.vendorExtensions.put("x-response", responseName);
                if (codegenResponse.getContent() == null) {
                    codegenResponse.vendorExtensions.put("x-generic-response", true);
                    continue;
                }
                if (codegenResponse.getContent().containsKey("application/json")) {
                    codegenResponse.vendorExtensions.put("x-json-response", true);
                } else {
                    codegenResponse.vendorExtensions.put("x-generic-response", true);
                }
                if (codegenResponse.getContent().size() <= 1) continue;
                codegenResponse.vendorExtensions.put("x-generic-response", true);
            }
            if (op.authMethods != null) {
                for (CodegenSecurity codegenSecurity : op.authMethods) {
                    allAuth.add(codegenSecurity.name);
                }
                ArrayList authDup = new ArrayList();
                for (CodegenSecurity authMeth : op.authMethods) {
                    HashMap<String, Object> vals = new HashMap<String, Object>();
                    vals.put("authName", authMeth.name);
                    vals.put("operation", op);
                    authDup.add(vals);
                    opsByAuth.computeIfAbsent(authMeth.name, k -> new ArrayList()).add(op.operationId);
                }
                op.vendorExtensions.put("x-authed", authDup);
                continue;
            }
            opsByAuth.computeIfAbsent("", k -> new ArrayList()).add(op.operationId);
        }
        TreeSet<String> allImports = new TreeSet<String>();
        List currentImports = objs.getImports().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
        for (CodegenOperation codegenOperation : operationList) {
            for (String nextImport : codegenOperation.imports) {
                String mapping = this.importMapping().get(nextImport);
                if (mapping != null && !this.defaultIncludes().contains(mapping) && !currentImports.contains(mapping)) {
                    allImports.add(mapping);
                }
                if ((mapping = this.instantiationTypes().get(nextImport)) == null || currentImports.contains(mapping) || currentImports.contains(mapping)) continue;
                allImports.add(mapping);
            }
        }
        objs.put("operationsByAuth", opsByAuth.entrySet().stream().map(ent -> {
            HashMap<String, Object> tuple = new HashMap<String, Object>();
            tuple.put("auth", ent.getKey());
            tuple.put("ops", ent.getValue());
            return tuple;
        }).collect(Collectors.toList()));
        objs.put("extraImports", allImports);
        objs.put("allAuth", allAuth);
        return objs;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String schemaType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = schemaType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private void generateScalaPath(CodegenOperation op) {
        HashSet<String> imports = new HashSet<String>();
        String path = op.path;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] items = path.split("/", -1);
        Object scalaPath = "";
        int pathParamIndex = 0;
        for (String item : items) {
            if (item.matches("^\\{(.*)}$")) {
                CodegenParameter cp = op.pathParams.get(pathParamIndex);
                scalaPath = (String)scalaPath + " / " + this.cpToPathParameter(cp, imports, cp.vendorExtensions);
                ++pathParamIndex;
                continue;
            }
            scalaPath = (String)scalaPath + " / \"" + item + "\"";
        }
        op.vendorExtensions.put("x-codegen-path", scalaPath);
        op.imports.addAll(imports);
    }

    private String cpToPathParameter(CodegenParameter cp, Set<String> imports, Map<String, Object> vendorExtensions) {
        if (cp.isContainer || cp.isArray) {
            cp.setDataType("String");
            cp.setIsArray(false);
            cp.setIsString(true);
            cp.isContainer = false;
        }
        Map<String, Object> _vendorExtensions = this.refineProp(cp, imports);
        vendorExtensions.putAll(_vendorExtensions);
        if (_vendorExtensions.size() == 1) {
            if ("String".equals(cp.getDataType())) {
                return cp.baseName;
            }
            return cp.dataType + "Varr(" + cp.baseName + ")";
        }
        return cp.baseName + "Varr(" + cp.baseName + ")";
    }

    private void generateQueryParameters(CodegenOperation op) {
        HashSet<String> imports = new HashSet<String>();
        Object queryString = "";
        for (CodegenParameter cp : op.queryParams) {
            queryString = ((String)queryString).isEmpty() ? (String)queryString + " :? " : (String)queryString + " +& ";
            queryString = (String)queryString + this.cpToQueryParameter(cp, imports, cp.vendorExtensions);
        }
        op.vendorExtensions.put("x-codegen-query", queryString);
        op.imports.addAll(imports);
    }

    private String cpToQueryParameter(CodegenParameter cp, Set<String> imports, Map<String, Object> vendorExtensions) {
        if (cp.isContainer && !cp.isArray) {
            cp.setDataType("String");
            cp.setIsArray(false);
            cp.setIsString(true);
            cp.isContainer = false;
        }
        vendorExtensions.putAll(this.refineProp(cp, imports));
        return cp.baseName + "QueryParam(" + cp.baseName + ")";
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Jim Schubert (https://github.com/jimschubert)#");
        System.out.println("# Please support his work directly via https://patreon.com/jimschubert \ud83d\ude4f      #");
        System.out.println("################################################################################");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.SCALA;
    }

    static {
        locationStatusToResponse.put("300", "MultipleChoices");
        locationStatusToResponse.put("301", "MovedPermanently");
        locationStatusToResponse.put("302", "Found");
        locationStatusToResponse.put("303", "SeeOther");
        locationStatusToResponse.put("307", "TemporaryRedirect");
        locationStatusToResponse.put("308", "PermanentRedirect");
        wwwAuthStatusToResponse = new HashMap<String, String>();
        wwwAuthStatusToResponse.put("401", "Unauthorized");
        allowStatusToResponse = new HashMap<String, String>();
        allowStatusToResponse.put("405", "MethodNotAllowed");
        proxyAuthStatusToResponse = new HashMap<String, String>();
        proxyAuthStatusToResponse.put("407", "ProxyAuthenticationRequired");
        statusToResponse = new HashMap<String, String>();
        statusToResponse.put("100", "Continue");
        statusToResponse.put("101", "SwitchingProtocols");
        statusToResponse.put("102", "Processing");
        statusToResponse.put("103", "EarlyHints");
        statusToResponse.put("200", "Ok");
        statusToResponse.put("201", "Created");
        statusToResponse.put("202", "Accepted");
        statusToResponse.put("203", "NonAuthoritativeInformation");
        statusToResponse.put("204", "NoContent");
        statusToResponse.put("205", "ResetContent");
        statusToResponse.put("206", "PartialContent");
        statusToResponse.put("207", "MultiStatus");
        statusToResponse.put("208", "AlreadyReported");
        statusToResponse.put("226", "IMUsed");
        statusToResponse.put("304", "NotModified");
        statusToResponse.put("305", "UseProxy");
        statusToResponse.put("400", "BadRequest");
        statusToResponse.put("402", "PaymentRequired");
        statusToResponse.put("403", "Forbidden");
        statusToResponse.put("404", "NotFound");
        statusToResponse.put("406", "NotAcceptable");
        statusToResponse.put("408", "RequestTimeout");
        statusToResponse.put("409", "Conflict");
        statusToResponse.put("410", "Gone");
        statusToResponse.put("411", "LengthRequired");
        statusToResponse.put("412", "PreconditionFailed");
        statusToResponse.put("413", "PayloadTooLarge");
        statusToResponse.put("414", "UriTooLong");
        statusToResponse.put("415", "UnsupportedMediaType");
        statusToResponse.put("416", "RangeNotSatisfiable");
        statusToResponse.put("417", "ExpectationFailed");
        statusToResponse.put("418", "ImATeapot");
        statusToResponse.put("421", "MisdirectedRequest");
        statusToResponse.put("422", "UnprocessableEntity");
        statusToResponse.put("423", "Locked");
        statusToResponse.put("424", "FailedDependency");
        statusToResponse.put("425", "TooEarly");
        statusToResponse.put("426", "UpgradeRequired");
        statusToResponse.put("428", "PreconditionRequired");
        statusToResponse.put("429", "TooManyRequests");
        statusToResponse.put("431", "RequestHeaderFieldsTooLarge");
        statusToResponse.put("451", "UnavailableForLegalReasons");
        statusToResponse.put("500", "InternalServerError");
        statusToResponse.put("501", "NotImplemented");
        statusToResponse.put("502", "BadGateway");
        statusToResponse.put("503", "ServiceUnavailable");
        statusToResponse.put("504", "GatewayTimeout");
        statusToResponse.put("505", "HttpVersionNotSupported");
        statusToResponse.put("506", "VariantAlsoNegotiates");
        statusToResponse.put("507", "InsufficientStorage");
        statusToResponse.put("508", "LoopDetected");
        statusToResponse.put("510", "NotExtended");
        statusToResponse.put("511", "NetworkAuthenticationRequired");
    }
}

